/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.item;

import lucraft.mods.lucraftcore.superpowers.effects.EffectVibrating;
import lucraft.mods.lucraftcore.superpowers.models.ModelBipedSuitSet;
import lucraft.mods.lucraftcore.superpowers.suitsets.JsonSuitSet;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.helper.ItemHelper;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.util.items.OpenableArmor;
import lucraft.mods.lucraftcore.util.render.ModelCache;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import spyeedy.mods.lcu.suitsets.LCUSuitSet;

public class ItemArmorNonSuitSet
extends ItemArmor
implements OpenableArmor.IOpenableArmor {
    private SuitSet suitSet;
    private LCUSuitSet.LCUDataInfo dataInfo;

    public ItemArmorNonSuitSet(SuitSet suitSet, EntityEquipmentSlot equipmentSlotIn, LCUSuitSet.LCUDataInfo dataInfo) {
        super(suitSet.getArmorMaterial(equipmentSlotIn), 0, equipmentSlotIn);
        this.setRegistryName(suitSet.getRegistryName().func_110624_b(), suitSet.getRegistryName().func_110623_a() + "_" + this.getArmorSlotName(equipmentSlotIn).toLowerCase());
        if (suitSet.showInCreativeTab()) {
            this.func_77637_a(suitSet.getCreativeTab());
        } else {
            this.func_77637_a(null);
        }
        this.func_77655_b(suitSet.getUnlocalizedName() + "_" + this.getArmorSlotName(equipmentSlotIn).toLowerCase());
        this.suitSet = suitSet;
        this.dataInfo = dataInfo;
    }

    public String func_77653_i(ItemStack stack) {
        return StringHelper.translateToLocal((String)this.dataInfo.translateName);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return this.getArmorTexturePath(false, entity instanceof EntityPlayer ? PlayerHelper.hasSmallArms((EntityPlayer)((EntityPlayer)entity)) : false, this.isArmorOpen(entity, stack));
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped armorModel = null;
        if (!itemStack.func_190926_b()) {
            boolean smallArms = false;
            if (entityLiving instanceof EntityPlayer) {
                smallArms = PlayerHelper.hasSmallArms((EntityPlayer)((EntityPlayer)entityLiving));
            }
            if ((armorModel = this.getArmorModel(this.suitSet, itemStack, (Entity)entityLiving, armorSlot, smallArms, this.isArmorOpen((Entity)entityLiving, itemStack))) != null) {
                armorModel.func_178686_a((ModelBase)_default);
                return armorModel;
            }
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(SuitSet suitSet, ItemStack stack, Entity entity, EntityEquipmentSlot slot, boolean smallArms, boolean open) {
        String key = suitSet.getRegistryName().toString() + "_" + this.dataInfo.armor_model_scale + "_" + this.getArmorTexturePath(false, smallArms, open) + "_" + this.getArmorTexturePath(true, smallArms, open) + "_" + slot.toString() + "_" + smallArms + "_" + EffectVibrating.isVibrating((Entity)entity);
        ModelBase model = ModelCache.getModel((String)key);
        if (model != null && model instanceof ModelBiped) {
            return (ModelBiped)model;
        }
        return (ModelBiped)ModelCache.storeModel((String)key, (ModelBase)new ModelBipedSuitSet(this.dataInfo.armor_model_scale, this.getArmorTexturePath(false, smallArms, open), this.getArmorTexturePath(true, smallArms, open), suitSet, slot, smallArms, EffectVibrating.isVibrating((Entity)entity)));
    }

    public String getArmorTexturePath(boolean light, boolean smallArms, boolean open) {
        String key;
        String string = key = light ? "glow" : "normal";
        if (smallArms && this.dataInfo.textures.containsKey(key + "_smallarms")) {
            key = key + "_smallarms";
        }
        if (open && this.dataInfo.textures.containsKey(key + "_open")) {
            key = key + "_open";
        }
        return this.dataInfo.textures.containsKey(key) ? this.dataInfo.textures.get(key) : "";
    }

    public boolean canBeOpened(Entity entity, ItemStack stack) {
        return this.dataInfo.openable;
    }

    public void setArmorOpen(Entity entity, ItemStack stack, boolean open) {
        if (this.dataInfo.openable) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (stack.func_77942_o()) {
                nbt = stack.func_77978_p();
            }
            nbt.func_74757_a("IsOpen", open);
            this.onArmorToggled(entity, stack, nbt.func_74767_n("IsOpen"));
            stack.func_77982_d(nbt);
        }
    }

    public boolean isArmorOpen(Entity entity, ItemStack stack) {
        if (this.dataInfo.openable && stack.func_77942_o()) {
            return stack.func_77978_p().func_74767_n("IsOpen");
        }
        return false;
    }

    public void onArmorToggled(Entity entity, ItemStack stack, boolean open) {
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketCustomSound(SoundEvents.field_187725_r.getRegistryName().toString(), entity.func_184176_by(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1.0f, 1.0f));
        }
    }

    public String getArmorSlotName(EntityEquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return "Helmet";
            }
            case LEGS: {
                return "Legs";
            }
            case FEET: {
                return "Boots";
            }
        }
        return "";
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        if (this.dataInfo.itemModelType == null || this.dataInfo.itemModelType != null && this.dataInfo.itemModelLoc.isEmpty()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(this.suitSet.getRegistryName().func_110624_b(), this.suitSet.getRegistryName().func_110623_a() + "_suit"), this.func_185083_B_().toString().toLowerCase()));
        } else if (this.dataInfo.itemModelType == JsonSuitSet.JsonSuitSetItemModelType.MODEL) {
            ResourceLocation loc = new ResourceLocation(this.dataInfo.itemModelLoc);
            ItemHelper.registerItemModel((Item)this, (String)loc.func_110624_b(), (String)loc.func_110623_a());
        } else if (this.dataInfo.itemModelType == JsonSuitSet.JsonSuitSetItemModelType.BLOCKSTATE) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(this.dataInfo.itemModelLoc), this.func_185083_B_().toString().toLowerCase()));
        }
    }
}

