/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.network.server;

import io.netty.buffer.ByteBuf;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import spyeedy.mods.lcu.abilities.AbilityProjectiles;

public class MessageSendAbilityProjectileInfo
implements IMessage {
    private String ability;
    private Ability.EnumAbilityContext context;
    private InfoType messageType;
    private int selectedProjectile;

    public MessageSendAbilityProjectileInfo() {
    }

    public MessageSendAbilityProjectileInfo(Ability ability, InfoType messageType, int selectedProjectile) {
        this.ability = ability.getKey();
        this.context = ability.context;
        this.messageType = messageType;
        this.selectedProjectile = selectedProjectile;
    }

    public void fromBytes(ByteBuf buf) {
        this.ability = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.context = Ability.EnumAbilityContext.fromString((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.messageType = InfoType.values()[buf.readInt()];
        this.selectedProjectile = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.ability);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.context.toString());
        buf.writeInt(this.messageType.ordinal());
        buf.writeInt(this.selectedProjectile);
    }

    public static enum InfoType {
        SELECTED_PROJECTILE;

    }

    public static class Handler
    implements IMessageHandler<MessageSendAbilityProjectileInfo, IMessage> {
        public MessageSendAbilityProjectileInfo onMessage(MessageSendAbilityProjectileInfo message, MessageContext ctx) {
            WorldServer thread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            thread.func_152344_a(() -> {
                AbilityContainer container = Ability.getAbilityContainer((Ability.EnumAbilityContext)message.context, (EntityLivingBase)ctx.getServerHandler().field_147369_b);
                if (container == null) {
                    return;
                }
                AbilityProjectiles ability = (AbilityProjectiles)container.getAbility(message.ability);
                if (ability == null) {
                    return;
                }
                if (message.messageType == InfoType.SELECTED_PROJECTILE) {
                    System.out.println("Message sent");
                    ability.setSelectedProjectile(message.selectedProjectile);
                }
            });
            return null;
        }
    }
}

