/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.suitsets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lucraft.mods.lucraftcore.superpowers.suitsets.JsonSuitSet;
import lucraft.mods.lucraftcore.superpowers.suitsets.RegisterSuitSetEvent;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import spyeedy.mods.lcu.item.ItemArmorNonSuitSet;

@Mod.EventBusSubscriber(modid="spylcu")
public class LCUSuitSet
extends SuitSet {
    public static final LCUSuitSet GREEN_LANTERN = new LCUSuitSet("green_lantern");
    private static final ArrayList<JsonSuitSet> SUIT_SETS = new ArrayList();
    private static final ArrayList<ItemArmorNonSuitSet> ARMOR_PARTS = new ArrayList();
    private static EntityEquipmentSlot[] SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    @SubscribeEvent
    public static void onRegisterSuitSets(RegisterSuitSetEvent e) {
        e.register((SuitSet)GREEN_LANTERN);
        for (ResourceLocation sets : SuitSet.REGISTRY.func_148742_b()) {
            if (!(SuitSet.REGISTRY.func_82594_a((Object)sets) instanceof JsonSuitSet) || ((JsonSuitSet)SuitSet.REGISTRY.func_82594_a((Object)sets)).getParent() != GREEN_LANTERN) continue;
            JsonSuitSet suitSet = (JsonSuitSet)SuitSet.REGISTRY.func_82594_a((Object)sets);
            SUIT_SETS.add(suitSet);
        }
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> e) throws Exception {
        for (JsonSuitSet set : SUIT_SETS) {
            for (EntityEquipmentSlot slot : SLOTS) {
                if (!LCUSuitSet.shouldMakePart((SuitSet)set, slot) || set.slotInfos.containsKey(slot)) continue;
                LCUDataInfo dataInfo = new LCUDataInfo();
                NBTTagCompound tag = LCUSuitSet.getPartTag((SuitSet)set, slot);
                if (tag == null) continue;
                dataInfo.glow = tag.func_74764_b("glow") && tag.func_74767_n("glow");
                boolean bl = dataInfo.openable = tag.func_74764_b("openable") && tag.func_74767_n("openable");
                if (tag.func_74764_b("armor_model_scale")) {
                    dataInfo.armor_model_scale = tag.func_74760_g("armor_model_scale");
                } else {
                    float f = slot == EntityEquipmentSlot.HEAD ? 0.5f : (dataInfo.armor_model_scale = slot == EntityEquipmentSlot.FEET ? 0.252f : 0.25f);
                }
                if (!tag.func_74764_b("translate_name")) {
                    dataInfo.translateName = null;
                    throw new Exception("Missing 'translate_name' for suit set %SSName - part %PartName".replace("%SSName", set.getRegistryName().toString()).replace("%PartName", slot.func_188450_d()));
                }
                dataInfo.translateName = tag.func_74779_i("translate_name");
                dataInfo.textures = tag.func_74764_b("textures") ? new HashMap() : null;
                NBTTagCompound texturesTag = tag.func_74775_l("textures");
                if (texturesTag != null) {
                    if (!texturesTag.func_74764_b("normal")) {
                        throw new Exception("Missing 'normal' texture for suit set %SSName - part %PartName".replace("%SSName", set.getRegistryName().toString()).replace("%PartName", slot.func_188450_d()));
                    }
                    dataInfo.textures.put("normal", texturesTag.func_74779_i("normal"));
                    if (dataInfo.openable) {
                        if (texturesTag.func_74764_b("normal_open")) {
                            dataInfo.textures.put("normal_open", texturesTag.func_74779_i("normal_open"));
                        } else {
                            throw new Exception("Missing 'normal_open' texture for suit set %SSName - part %PartName".replace("%SSName", set.getRegistryName().toString()).replace("%PartName", slot.func_188450_d()));
                        }
                    }
                    if (dataInfo.glow) {
                        if (texturesTag.func_74764_b("glow")) {
                            dataInfo.textures.put("glow", texturesTag.func_74779_i("glow"));
                        } else {
                            throw new Exception("Missing 'glow' texture for suit set %SSName - part %PartName".replace("%SSName", set.getRegistryName().toString()).replace("%PartName", slot.func_188450_d()));
                        }
                    }
                    if (dataInfo.glow && dataInfo.openable) {
                        if (texturesTag.func_74764_b("glow_open")) {
                            dataInfo.textures.put("glow_open", texturesTag.func_74779_i("glow_open"));
                        } else {
                            throw new Exception("Missing 'glow_open' texture for suit set %SSName - part %PartName".replace("%SSName", set.getRegistryName().toString()).replace("%PartName", slot.func_188450_d()));
                        }
                    }
                }
                dataInfo.itemModelType = null;
                NBTTagCompound itemModelTag = tag.func_74775_l("item_texture");
                if (itemModelTag != null) {
                    if (itemModelTag.func_74764_b("model")) {
                        dataInfo.itemModelType = JsonSuitSet.JsonSuitSetItemModelType.MODEL;
                        dataInfo.itemModelLoc = itemModelTag.func_74779_i("model");
                    } else if (itemModelTag.func_74764_b("blockstate")) {
                        dataInfo.itemModelType = JsonSuitSet.JsonSuitSetItemModelType.BLOCKSTATE;
                        dataInfo.itemModelLoc = itemModelTag.func_74779_i("blockstate");
                    } else if (itemModelTag.func_74764_b("model") && itemModelTag.func_74764_b("blockstate")) {
                        throw new Exception("Cannot have both 'model' and 'blockstate' for 'item_texture', only one type is allowed for suit set %SSName - part %PartName".replace("%SSName", set.getRegistryName().toString()).replace("%PartName", slot.func_188450_d()));
                    }
                }
                ItemArmorNonSuitSet armor = new ItemArmorNonSuitSet((SuitSet)set, slot, dataInfo);
                e.getRegistry().register((IForgeRegistryEntry)armor);
                ARMOR_PARTS.add(armor);
            }
        }
        SUIT_SETS.clear();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRegisterModels(ModelRegistryEvent e) {
        for (ItemArmorNonSuitSet item : ARMOR_PARTS) {
            item.registerModel();
        }
        ARMOR_PARTS.clear();
    }

    private static boolean shouldMakePart(SuitSet set, EntityEquipmentSlot slot) {
        if (slot == EntityEquipmentSlot.HEAD && set.getHelmet() == null) {
            return true;
        }
        if (slot == EntityEquipmentSlot.LEGS && set.getLegs() == null) {
            return true;
        }
        return slot == EntityEquipmentSlot.FEET && set.getBoots() == null;
    }

    private static NBTTagCompound getPartTag(SuitSet set, EntityEquipmentSlot slot) {
        if (slot == EntityEquipmentSlot.HEAD) {
            return set.getData().func_74775_l("maskTag");
        }
        if (slot == EntityEquipmentSlot.LEGS) {
            return set.getData().func_74775_l("legsTag");
        }
        if (slot == EntityEquipmentSlot.FEET) {
            return set.getData().func_74775_l("bootsTag");
        }
        return null;
    }

    public LCUSuitSet(String name) {
        super(name);
        this.setRegistryName("spylcu", name);
    }

    public static class LCUDataInfo {
        public boolean openable;
        public boolean glow;
        public float armor_model_scale;
        public String translateName;
        public Map<String, String> textures;
        public JsonSuitSet.JsonSuitSetItemModelType itemModelType;
        public String itemModelLoc;
    }
}

