/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.gui.GuiConfigs;
import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.materials.MaterialListBase;
import fi.dy.masa.litematica.materials.MaterialListHudRenderer;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.TaskScheduler;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.schematic.projects.SchematicProjectsManager;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.selection.AreaSelectionSimple;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.tool.ToolModeData;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryCache;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class DataManager
implements IDirectoryCache {
    private static final DataManager INSTANCE = new DataManager();
    private static final Pattern PATTERN_ITEM_BASE = Pattern.compile("^(?<name>(?:[a-z0-9\\._-]+:)[a-z0-9\\._-]+)$");
    private static final Map<String, File> LAST_DIRECTORIES = new HashMap<String, File>();
    private static class_1799 toolItem = new class_1799((class_1935)class_1802.field_8600);
    private static GuiConfigs.ConfigGuiTab configGuiTab = GuiConfigs.ConfigGuiTab.GENERIC;
    private static boolean createPlacementOnLoad = true;
    private static boolean canSave;
    private static long clientTickStart;
    private final SelectionManager selectionManager = new SelectionManager();
    private final SchematicPlacementManager schematicPlacementManager = new SchematicPlacementManager();
    private final SchematicProjectsManager schematicProjectsManager = new SchematicProjectsManager();
    private LayerRange renderRange = new LayerRange((IRangeChangeListener)SchematicWorldRefresher.INSTANCE);
    private ToolMode operationMode = ToolMode.SCHEMATIC_PLACEMENT;
    private AreaSelectionSimple areaSimple = new AreaSelectionSimple(true);
    @Nullable
    private MaterialListBase materialList;

    private DataManager() {
    }

    private static DataManager getInstance() {
        return INSTANCE;
    }

    public static IDirectoryCache getDirectoryCache() {
        return INSTANCE;
    }

    public static void onClientTickStart() {
        clientTickStart = System.nanoTime();
    }

    public static long getClientTickStartTime() {
        return clientTickStart;
    }

    public static class_1799 getToolItem() {
        return toolItem;
    }

    public static boolean getCreatePlacementOnLoad() {
        return createPlacementOnLoad;
    }

    public static void setCreatePlacementOnLoad(boolean create) {
        createPlacementOnLoad = create;
    }

    public static GuiConfigs.ConfigGuiTab getConfigGuiTab() {
        return configGuiTab;
    }

    public static void setConfigGuiTab(GuiConfigs.ConfigGuiTab tab) {
        configGuiTab = tab;
    }

    public static SelectionManager getSelectionManager() {
        return DataManager.getInstance().selectionManager;
    }

    public static SchematicPlacementManager getSchematicPlacementManager() {
        return DataManager.getInstance().schematicPlacementManager;
    }

    public static SchematicProjectsManager getSchematicProjectsManager() {
        return DataManager.getInstance().schematicProjectsManager;
    }

    @Nullable
    public static MaterialListBase getMaterialList() {
        return DataManager.getInstance().materialList;
    }

    public static void setMaterialList(@Nullable MaterialListBase materialList) {
        MaterialListHudRenderer renderer;
        MaterialListBase old = DataManager.getInstance().materialList;
        if (old != null && (renderer = old.getHudRenderer()).getShouldRenderCustom()) {
            renderer.toggleShouldRender();
            InfoHud.getInstance().removeInfoHudRenderer(renderer, false);
        }
        DataManager.getInstance().materialList = materialList;
    }

    public static ToolMode getToolMode() {
        return DataManager.getInstance().operationMode;
    }

    public static void setToolMode(ToolMode mode) {
        DataManager.getInstance().operationMode = mode;
    }

    public static LayerRange getRenderLayerRange() {
        return DataManager.getInstance().renderRange;
    }

    public static AreaSelectionSimple getSimpleArea() {
        return DataManager.getInstance().areaSimple;
    }

    @Nullable
    public File getCurrentDirectoryForContext(String context) {
        return LAST_DIRECTORIES.get(context);
    }

    public void setCurrentDirectoryForContext(String context, File dir) {
        LAST_DIRECTORIES.put(context, dir);
    }

    public static void load() {
        DataManager.getInstance().loadPerDimensionData();
        File file = DataManager.getCurrentStorageFile(true);
        JsonElement element = JsonUtils.parseJsonFile((File)file);
        if (element != null && element.isJsonObject()) {
            LAST_DIRECTORIES.clear();
            JsonObject root = element.getAsJsonObject();
            if (JsonUtils.hasObject((JsonObject)root, (String)"last_directories")) {
                JsonObject obj = root.get("last_directories").getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    File dir;
                    String name = (String)entry.getKey();
                    JsonElement el = (JsonElement)entry.getValue();
                    if (!el.isJsonPrimitive() || !(dir = new File(el.getAsString())).exists() || !dir.isDirectory()) continue;
                    LAST_DIRECTORIES.put(name, dir);
                }
            }
            if (JsonUtils.hasString((JsonObject)root, (String)"config_gui_tab")) {
                try {
                    configGuiTab = GuiConfigs.ConfigGuiTab.valueOf(root.get("config_gui_tab").getAsString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (configGuiTab == null) {
                    configGuiTab = GuiConfigs.ConfigGuiTab.GENERIC;
                }
            }
            createPlacementOnLoad = JsonUtils.getBooleanOrDefault((JsonObject)root, (String)"create_placement_on_load", (boolean)true);
        }
        canSave = true;
    }

    public static void save() {
        DataManager.save(false);
        MaterialCache.getInstance().writeToFile();
    }

    public static void save(boolean forceSave) {
        if (!canSave && !forceSave) {
            return;
        }
        DataManager.getInstance().savePerDimensionData();
        JsonObject root = new JsonObject();
        JsonObject objDirs = new JsonObject();
        for (Map.Entry<String, File> entry : LAST_DIRECTORIES.entrySet()) {
            objDirs.add(entry.getKey(), (JsonElement)new JsonPrimitive(entry.getValue().getAbsolutePath()));
        }
        root.add("last_directories", (JsonElement)objDirs);
        root.add("create_placement_on_load", (JsonElement)new JsonPrimitive(Boolean.valueOf(createPlacementOnLoad)));
        root.add("config_gui_tab", (JsonElement)new JsonPrimitive(configGuiTab.name()));
        File file = DataManager.getCurrentStorageFile(true);
        JsonUtils.writeJsonToFile((JsonObject)root, (File)file);
        canSave = false;
    }

    public static void clear() {
        TaskScheduler.getInstanceClient().clearTasks();
        SchematicVerifier.clearActiveVerifiers();
        DataManager.getSchematicPlacementManager().clear();
        DataManager.getSchematicProjectsManager().clear();
        DataManager.getSelectionManager().clear();
        DataManager.setMaterialList(null);
        InfoHud.getInstance().reset();
    }

    private void savePerDimensionData() {
        this.schematicProjectsManager.saveCurrentProject();
        JsonObject root = this.toJson();
        File file = DataManager.getCurrentStorageFile(false);
        JsonUtils.writeJsonToFile((JsonObject)root, (File)file);
    }

    private void loadPerDimensionData() {
        this.selectionManager.clear();
        this.schematicPlacementManager.clear();
        this.schematicProjectsManager.clear();
        this.materialList = null;
        File file = DataManager.getCurrentStorageFile(false);
        JsonElement element = JsonUtils.parseJsonFile((File)file);
        if (element != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            this.fromJson(root);
        }
    }

    private void fromJson(JsonObject obj) {
        if (JsonUtils.hasObject((JsonObject)obj, (String)"selections")) {
            this.selectionManager.loadFromJson(obj.get("selections").getAsJsonObject());
        }
        if (JsonUtils.hasObject((JsonObject)obj, (String)"placements")) {
            this.schematicPlacementManager.loadFromJson(obj.get("placements").getAsJsonObject());
        }
        if (JsonUtils.hasObject((JsonObject)obj, (String)"schematic_projects_manager")) {
            this.schematicProjectsManager.loadFromJson(obj.get("schematic_projects_manager").getAsJsonObject());
        }
        if (JsonUtils.hasObject((JsonObject)obj, (String)"render_range")) {
            this.renderRange = LayerRange.createFromJson((JsonObject)JsonUtils.getNestedObject((JsonObject)obj, (String)"render_range", (boolean)false), (IRangeChangeListener)SchematicWorldRefresher.INSTANCE);
        }
        if (JsonUtils.hasString((JsonObject)obj, (String)"operation_mode")) {
            try {
                this.operationMode = ToolMode.valueOf(obj.get("operation_mode").getAsString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.operationMode == null) {
                this.operationMode = ToolMode.AREA_SELECTION;
            }
        }
        if (JsonUtils.hasObject((JsonObject)obj, (String)"area_simple")) {
            this.areaSimple = AreaSelectionSimple.fromJson(obj.get("area_simple").getAsJsonObject());
        }
        if (JsonUtils.hasObject((JsonObject)obj, (String)"tool_mode_data")) {
            this.toolModeDataFromJson(obj.get("tool_mode_data").getAsJsonObject());
        }
    }

    private JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("selections", (JsonElement)this.selectionManager.toJson());
        obj.add("placements", (JsonElement)this.schematicPlacementManager.toJson());
        obj.add("schematic_projects_manager", (JsonElement)this.schematicProjectsManager.toJson());
        obj.add("operation_mode", (JsonElement)new JsonPrimitive(this.operationMode.name()));
        obj.add("render_range", (JsonElement)this.renderRange.toJson());
        obj.add("area_simple", (JsonElement)this.areaSimple.toJson());
        obj.add("tool_mode_data", (JsonElement)this.toolModeDataToJson());
        return obj;
    }

    private JsonObject toolModeDataToJson() {
        JsonObject obj = new JsonObject();
        obj.add("delete", (JsonElement)ToolModeData.DELETE.toJson());
        return obj;
    }

    private void toolModeDataFromJson(JsonObject obj) {
        if (JsonUtils.hasObject((JsonObject)obj, (String)"delete")) {
            ToolModeData.DELETE.fromJson(obj.get("delete").getAsJsonObject());
        }
    }

    public static File getCurrentConfigDirectory() {
        return new File(FileUtils.getConfigDirectory(), "litematica");
    }

    public static File getSchematicsBaseDirectory() {
        File dir = FileUtils.getCanonicalFileIfPossible((File)new File(FileUtils.getMinecraftDirectory(), "schematics"));
        if (!dir.exists() && !dir.mkdirs()) {
            Litematica.logger.warn("Failed to create the schematic directory '{}'", (Object)dir.getAbsolutePath());
        }
        return dir;
    }

    public static File getAreaSelectionsBaseDirectory() {
        String name = StringUtils.getWorldOrServerName();
        File dir = Configs.Generic.AREAS_PER_WORLD.getBooleanValue() && name != null ? FileUtils.getCanonicalFileIfPossible((File)new File(new File(new File(DataManager.getCurrentConfigDirectory(), "area_selections_per_world"), name), "area_selections")) : FileUtils.getCanonicalFileIfPossible((File)new File(DataManager.getCurrentConfigDirectory(), "area_selections"));
        if (!dir.exists() && !dir.mkdirs()) {
            Litematica.logger.warn("Failed to create the area selections base directory '{}'", (Object)dir.getAbsolutePath());
        }
        return dir;
    }

    private static File getCurrentStorageFile(boolean globalData) {
        File dir = DataManager.getCurrentConfigDirectory();
        if (!dir.exists() && !dir.mkdirs()) {
            Litematica.logger.warn("Failed to create the config directory '{}'", (Object)dir.getAbsolutePath());
        }
        return new File(dir, StringUtils.getStorageFileName((boolean)globalData, (String)"litematica_", (String)".json", (String)"default"));
    }

    public static void setToolItem(String itemName) {
        if (itemName.isEmpty() || itemName.equals("empty")) {
            toolItem = class_1799.field_8037;
            return;
        }
        try {
            class_1792 item;
            Matcher matcher = PATTERN_ITEM_BASE.matcher(itemName);
            if (matcher.matches() && (item = (class_1792)class_2378.field_11142.method_10223(new class_2960(matcher.group("name")))) != null && item != class_1802.field_8162) {
                toolItem = new class_1799((class_1935)item);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        toolItem = new class_1799((class_1935)class_1802.field_8600);
        Configs.Generic.TOOL_ITEM.setValueFromString(class_2378.field_11142.method_10221((Object)class_1802.field_8600).toString());
    }
}

