/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.gui.widgets;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.GuiSchematicBrowserBase;
import fi.dy.masa.litematica.gui.Icons;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.SchematicMetadata;
import fi.dy.masa.malilib.gui.interfaces.IFileBrowserIconProvider;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1062;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WidgetSchematicBrowser
extends WidgetFileBrowserBase {
    protected static final FileFilter SCHEMATIC_FILTER = new FileFilterSchematics();
    protected final Map<File, SchematicMetadata> cachedMetadata = new HashMap<File, SchematicMetadata>();
    protected final Map<File, Pair<class_2960, class_1043>> cachedPreviewImages = new HashMap<File, Pair<class_2960, class_1043>>();
    protected final GuiSchematicBrowserBase parent;
    protected final int infoWidth;
    protected final int infoHeight;

    public WidgetSchematicBrowser(int x, int y, int width, int height, GuiSchematicBrowserBase parent, @Nullable ISelectionListener<WidgetFileBrowserBase.DirectoryEntry> selectionListener) {
        super(x, y, width, height, DataManager.getDirectoryCache(), parent.getBrowserContext(), parent.getDefaultDirectory(), selectionListener, (IFileBrowserIconProvider)Icons.FILE_ICON_LITEMATIC);
        this.title = StringUtils.translate((String)"litematica.gui.title.schematic_browser", (Object[])new Object[0]);
        this.infoWidth = 170;
        this.infoHeight = 290;
        this.parent = parent;
    }

    protected int getBrowserWidthForTotalWidth(int width) {
        return super.getBrowserWidthForTotalWidth(width) - this.infoWidth;
    }

    public void onClose() {
        super.onClose();
        this.clearPreviewImages();
    }

    protected File getRootDirectory() {
        return DataManager.getSchematicsBaseDirectory();
    }

    protected FileFilter getFileFilter() {
        return SCHEMATIC_FILTER;
    }

    protected void drawAdditionalContents(int mouseX, int mouseY) {
        this.drawSelectedSchematicInfo((WidgetFileBrowserBase.DirectoryEntry)this.getLastSelectedEntry());
    }

    protected void drawSelectedSchematicInfo(@Nullable WidgetFileBrowserBase.DirectoryEntry entry) {
        int x = this.posX + this.totalWidth - this.infoWidth;
        int y = this.posY;
        int height = Math.min(this.infoHeight, this.parent.getMaxInfoHeight());
        RenderUtils.drawOutlinedBox((int)x, (int)y, (int)this.infoWidth, (int)height, (int)-1610612736, (int)-6710887);
        if (entry == null) {
            return;
        }
        SchematicMetadata meta = this.getSchematicMetadata(entry);
        if (meta != null) {
            String tmp;
            class_2382 areaSize;
            int textColor = -1061109568;
            int valueColor = -1056964609;
            String str = StringUtils.translate((String)"litematica.gui.label.schematic_info.name", (Object[])new Object[0]);
            this.drawString(str, x += 3, y += 3, textColor);
            this.drawString(meta.getName(), x + 4, y += 12, valueColor);
            str = StringUtils.translate((String)"litematica.gui.label.schematic_info.schematic_author", (Object[])new Object[]{meta.getAuthor()});
            this.drawString(str, x, y += 12, textColor);
            String strDate = DATE_FORMAT.format(new Date(meta.getTimeCreated()));
            str = StringUtils.translate((String)"litematica.gui.label.schematic_info.time_created", (Object[])new Object[]{strDate});
            this.drawString(str, x, y += 12, textColor);
            y += 12;
            if (meta.hasBeenModified()) {
                strDate = DATE_FORMAT.format(new Date(meta.getTimeModified()));
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.time_modified", (Object[])new Object[]{strDate});
                this.drawString(str, x, y, textColor);
                y += 12;
            }
            str = StringUtils.translate((String)"litematica.gui.label.schematic_info.region_count", (Object[])new Object[]{meta.getRegionCount()});
            this.drawString(str, x, y, textColor);
            y += 12;
            if (this.parent.height >= 340) {
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.total_volume", (Object[])new Object[]{meta.getTotalVolume()});
                this.drawString(str, x, y, textColor);
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.total_blocks", (Object[])new Object[]{meta.getTotalBlocks()});
                this.drawString(str, x, y += 12, textColor);
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.enclosing_size", (Object[])new Object[0]);
                this.drawString(str, x, y += 12, textColor);
                areaSize = meta.getEnclosingSize();
                tmp = String.format("%d x %d x %d", areaSize.method_10263(), areaSize.method_10264(), areaSize.method_10260());
                this.drawString(tmp, x + 4, y += 12, valueColor);
                y += 12;
            } else {
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.total_blocks_and_volume", (Object[])new Object[]{meta.getTotalBlocks(), meta.getTotalVolume()});
                this.drawString(str, x, y, textColor);
                areaSize = meta.getEnclosingSize();
                tmp = String.format("%d x %d x %d", areaSize.method_10263(), areaSize.method_10264(), areaSize.method_10260());
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.enclosing_size_value", (Object[])new Object[]{tmp});
                this.drawString(str, x, y += 12, textColor);
                y += 12;
            }
            Pair<class_2960, class_1043> pair = this.cachedPreviewImages.get(entry.getFullPath());
            if (pair != null) {
                y += 14;
                int iconSize = ((class_1043)pair.getRight()).method_4525().method_4307();
                boolean needsScaling = height < this.infoHeight;
                RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (needsScaling) {
                    iconSize = height - y + this.posY - 6;
                }
                RenderUtils.drawOutlinedBox((int)(x + 4), (int)y, (int)iconSize, (int)iconSize, (int)-1610612736, (int)-6710887);
                this.bindTexture((class_2960)pair.getLeft());
                class_332.blit((int)(x + 4), (int)y, (float)0.0f, (float)0.0f, (int)iconSize, (int)iconSize, (int)iconSize, (int)iconSize);
            }
        }
    }

    public void clearSchematicMetadataCache() {
        this.clearPreviewImages();
        this.cachedMetadata.clear();
        this.cachedPreviewImages.clear();
    }

    @Nullable
    protected SchematicMetadata getSchematicMetadata(WidgetFileBrowserBase.DirectoryEntry entry) {
        File file = new File(entry.getDirectory(), entry.getName());
        SchematicMetadata meta = this.cachedMetadata.get(file);
        if (meta == null && !this.cachedMetadata.containsKey(file)) {
            LitematicaSchematic schematic;
            if (entry.getName().endsWith(".litematic") && (schematic = LitematicaSchematic.createFromFile(entry.getDirectory(), entry.getName())) != null) {
                meta = schematic.getMetadata();
                this.createPreviewImage(file, meta);
            }
            this.cachedMetadata.put(file, meta);
        }
        return meta;
    }

    private void clearPreviewImages() {
        for (Pair<class_2960, class_1043> pair : this.cachedPreviewImages.values()) {
            this.mc.method_1531().method_4615((class_2960)pair.getLeft());
        }
    }

    private void createPreviewImage(File file, SchematicMetadata meta) {
        int size;
        int[] previewImageData = meta.getPreviewImagePixelData();
        if (previewImageData != null && previewImageData.length > 0 && (size = (int)Math.sqrt(previewImageData.length)) * size == previewImageData.length) {
            try {
                class_1011 image = new class_1011(size, size, false);
                class_1043 tex = new class_1043(image);
                class_2960 rl = new class_2960("litematica", DigestUtils.sha1Hex((String)file.getAbsolutePath()));
                this.mc.method_1531().method_4616(rl, (class_1062)tex);
                int i = 0;
                for (int y = 0; y < size; ++y) {
                    for (int x = 0; x < size; ++x) {
                        int val = previewImageData[i++];
                        val = val & 0xFF00FF00 | (val & 0xFF0000) >> 16 | (val & 0xFF) << 16;
                        image.method_4305(x, y, val);
                    }
                }
                tex.method_4524();
                this.cachedPreviewImages.put(file, (Pair<class_2960, class_1043>)Pair.of((Object)rl, (Object)tex));
            }
            catch (Exception e) {
                Litematica.logger.warn("Failed to create a preview image", (Throwable)e);
            }
        }
    }

    public static class FileFilterSchematics
    implements FileFilter {
        @Override
        public boolean accept(File pathName) {
            String name = pathName.getName();
            return name.endsWith(".litematic") || name.endsWith(".schematic") || name.endsWith(".nbt");
        }
    }
}

