/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.gui.widgets;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.SchematicHolder;
import fi.dy.masa.litematica.gui.GuiSchematicSave;
import fi.dy.masa.litematica.gui.Icons;
import fi.dy.masa.litematica.gui.widgets.WidgetListLoadedSchematics;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntryBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_437;

public class WidgetSchematicEntry
extends WidgetListEntryBase<LitematicaSchematic> {
    private final WidgetListLoadedSchematics parent;
    private final LitematicaSchematic schematic;
    private final int typeIconX;
    private final int typeIconY;
    private final boolean isOdd;
    private final int buttonsStartX;

    public WidgetSchematicEntry(int x, int y, int width, int height, boolean isOdd, LitematicaSchematic schematic, int listIndex, WidgetListLoadedSchematics parent) {
        super(x, y, width, height, (Object)schematic, listIndex);
        this.parent = parent;
        this.schematic = schematic;
        this.isOdd = isOdd;
        int posX = x + width;
        String text = StringUtils.translate((String)"litematica.gui.button.unload", (Object[])new Object[0]);
        int len = this.getStringWidth(text) + 10;
        ButtonListener listener = new ButtonListener(ButtonListener.Type.UNLOAD, this);
        this.addButton((ButtonBase)new ButtonGeneric(posX -= len + 2, ++y, len, 20, text, new String[0]), listener);
        text = StringUtils.translate((String)"litematica.gui.button.save_to_file", (Object[])new Object[0]);
        len = this.getStringWidth(text) + 10;
        listener = new ButtonListener(ButtonListener.Type.SAVE_TO_FILE, this);
        this.addButton((ButtonBase)new ButtonGeneric(posX -= len + 2, y, len, 20, text, new String[0]), listener);
        text = StringUtils.translate((String)"litematica.gui.button.create_placement", (Object[])new Object[0]);
        len = this.getStringWidth(text) + 10;
        String tip = StringUtils.translate((String)"litematica.gui.label.schematic_placement.hoverinfo.hold_shift_to_create_as_disabled", (Object[])new Object[0]);
        listener = new ButtonListener(ButtonListener.Type.CREATE_PLACEMENT, this);
        this.addButton((ButtonBase)new ButtonGeneric(posX -= len + 2, y, len, 20, text, new String[]{tip}), listener);
        this.buttonsStartX = posX;
        this.typeIconX = this.x + 2;
        this.typeIconY = y + 4;
    }

    public void render(int mouseX, int mouseY, boolean selected) {
        String text;
        Icons icon;
        RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (selected || this.isMouseOver(mouseX, mouseY)) {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x70FFFFFF);
        } else if (this.isOdd) {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x20FFFFFF);
        } else {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x50FFFFFF);
        }
        String schematicName = this.schematic.getMetadata().getName();
        this.drawString(this.x + 20, this.y + 7, -1, schematicName);
        RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
        File schematicFile = this.schematic.getFile();
        String fileName = schematicFile != null ? schematicFile.getName() : null;
        this.parent.bindTexture(Icons.TEXTURE);
        if (fileName != null) {
            icon = Icons.SCHEMATIC_TYPE_FILE;
            text = fileName;
        } else {
            icon = Icons.SCHEMATIC_TYPE_MEMORY;
            text = StringUtils.translate((String)"litematica.gui.label.schematic_placement.in_memory", (Object[])new Object[0]);
        }
        icon.renderAt(this.typeIconX, this.typeIconY, this.zLevel, false, false);
        this.drawSubWidgets(mouseX, mouseY);
        if (GuiBase.isMouseOver((int)mouseX, (int)mouseY, (int)this.x, (int)this.y, (int)(this.buttonsStartX - 12), (int)this.height)) {
            RenderUtils.drawHoverText((int)mouseX, (int)mouseY, (List)ImmutableList.of((Object)text));
        }
        RenderUtils.disableItemLighting();
        GlStateManager.disableLighting();
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final Type type;
        private final WidgetSchematicEntry widget;

        public ButtonListener(Type type, WidgetSchematicEntry widget) {
            this.type = type;
            this.widget = widget;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == Type.CREATE_PLACEMENT) {
                class_2338 pos = new class_2338(((WidgetSchematicEntry)this.widget).mc.field_1724.method_19538());
                LitematicaSchematic entry = this.widget.schematic;
                String name = entry.getMetadata().getName();
                boolean enabled = !GuiBase.isShiftDown();
                SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
                SchematicPlacement placement = SchematicPlacement.createFor(entry, pos, name, enabled, enabled);
                manager.addSchematicPlacement(placement, true);
                manager.setSelectedSchematicPlacement(placement);
            } else if (this.type == Type.SAVE_TO_FILE) {
                LitematicaSchematic entry = this.widget.schematic;
                GuiSchematicSave gui = new GuiSchematicSave(entry);
                gui.setParent(GuiUtils.getCurrentScreen());
                GuiBase.openGui((class_437)gui);
            } else if (this.type == Type.UNLOAD) {
                SchematicHolder.getInstance().removeSchematic(this.widget.schematic);
                this.widget.parent.refreshEntries();
            }
        }

        public static enum Type {
            CREATE_PLACEMENT,
            SAVE_TO_FILE,
            UNLOAD;

        }
    }
}

