/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2362;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2488;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2771;

public class MaterialCache {
    private static final MaterialCache INSTANCE = new MaterialCache();
    protected final IdentityHashMap<class_2680, class_1799> itemsForStates = new IdentityHashMap();
    protected final WorldSchematic tempWorld = SchematicWorldHandler.createSchematicWorld();
    protected final class_2338 checkPos = new class_2338(8, 0, 8);
    protected boolean hasReadFromFile;
    protected boolean dirty;

    private MaterialCache() {
        WorldUtils.loadChunksSchematicWorld(this.tempWorld, this.checkPos, new class_2382(1, 1, 1));
    }

    public static MaterialCache getInstance() {
        if (!MaterialCache.INSTANCE.hasReadFromFile) {
            INSTANCE.readFromFile();
        }
        return INSTANCE;
    }

    public void clearCache() {
        this.itemsForStates.clear();
    }

    public class_1799 getItemForState(class_2680 state) {
        return this.getItemForState(state, (class_1937)this.tempWorld, this.checkPos);
    }

    public class_1799 getItemForState(class_2680 state, class_1937 world, class_2338 pos) {
        class_1799 stack = this.itemsForStates.get(state);
        if (stack == null) {
            stack = this.getItemForStateFromWorld(state, world, pos);
        }
        return stack;
    }

    protected class_1799 getItemForStateFromWorld(class_2680 state, class_1937 world, class_2338 pos) {
        class_1799 stack = this.getStateToItemOverride(state);
        if (stack == null) {
            world.method_8652(pos, state, 20);
            stack = state.method_11614().method_9574((class_1922)world, pos, state);
        }
        if (stack == null || stack.method_7960()) {
            stack = class_1799.field_8037;
        } else {
            this.overrideStackSize(state, stack);
        }
        this.itemsForStates.put(state, stack);
        this.dirty = true;
        return stack;
    }

    public boolean requiresMultipleItems(class_2680 state) {
        class_2248 block = state.method_11614();
        return block instanceof class_2362 && block != class_2246.field_10495;
    }

    public ImmutableList<class_1799> getItems(class_2680 state) {
        return this.getItems(state, (class_1937)this.tempWorld, this.checkPos);
    }

    public ImmutableList<class_1799> getItems(class_2680 state, class_1937 world, class_2338 pos) {
        class_2248 block = state.method_11614();
        if (block instanceof class_2362 && block != class_2246.field_10495) {
            return ImmutableList.of((Object)new class_1799((class_1935)class_2246.field_10495), (Object)block.method_9574((class_1922)world, pos, state));
        }
        return ImmutableList.of((Object)this.getItemForState(state, world, pos));
    }

    @Nullable
    protected class_1799 getStateToItemOverride(class_2680 state) {
        class_2248 block = state.method_11614();
        if (block == class_2246.field_10379 || block == class_2246.field_10379 || block == class_2246.field_10316 || block == class_2246.field_10027 || block == class_2246.field_10613) {
            return class_1799.field_8037;
        }
        if (block == class_2246.field_10362) {
            return new class_1799((class_1935)class_2246.field_10566);
        }
        if (block == class_2246.field_10580) {
            return new class_1799((class_1935)class_2246.field_10580);
        }
        if (block == class_2246.field_10240) {
            return new class_1799((class_1935)class_2246.field_10240);
        }
        if (block == class_2246.field_10164) {
            if ((Integer)state.method_11654((class_2769)class_2404.field_11278) == 0) {
                return new class_1799((class_1935)class_1802.field_8187);
            }
            return class_1799.field_8037;
        }
        if (block == class_2246.field_10382) {
            if ((Integer)state.method_11654((class_2769)class_2404.field_11278) == 0) {
                return new class_1799((class_1935)class_1802.field_8705);
            }
            return class_1799.field_8037;
        }
        if (block instanceof class_2323 && state.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12609) {
            return class_1799.field_8037;
        }
        if (block instanceof class_2244 && state.method_11654((class_2769)class_2244.field_9967) == class_2742.field_12560) {
            return class_1799.field_8037;
        }
        if (block instanceof class_2320 && state.method_11654((class_2769)class_2320.field_10929) == class_2756.field_12609) {
            return class_1799.field_8037;
        }
        return null;
    }

    protected void overrideStackSize(class_2680 state, class_1799 stack) {
        if (state.method_11614() instanceof class_2482 && state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12682) {
            stack.method_7939(2);
        } else if (state.method_11614() == class_2246.field_10477) {
            stack.method_7939(((Integer)state.method_11654((class_2769)class_2488.field_11518)).intValue());
        }
    }

    protected class_2487 writeToNBT() {
        class_2487 nbt = new class_2487();
        class_2499 list = new class_2499();
        for (Map.Entry<class_2680, class_1799> entry : this.itemsForStates.entrySet()) {
            class_2487 tag = new class_2487();
            class_2487 stateTag = class_2512.method_10686((class_2680)entry.getKey());
            tag.method_10566("Block", (class_2520)stateTag);
            tag.method_10566("Item", (class_2520)entry.getValue().method_7953(new class_2487()));
            list.add((Object)tag);
        }
        nbt.method_10566("MaterialCache", (class_2520)list);
        return nbt;
    }

    protected boolean readFromNBT(class_2487 nbt) {
        this.itemsForStates.clear();
        if (nbt.method_10573("MaterialCache", 9)) {
            class_2499 list = nbt.method_10554("MaterialCache", 10);
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                class_2680 state;
                class_2487 tag = list.method_10602(i);
                if (!tag.method_10573("Block", 10) || !tag.method_10573("Item", 10) || (state = class_2512.method_10681((class_2487)tag.method_10562("Block"))) == null) continue;
                class_1799 stack = class_1799.method_7915((class_2487)tag.method_10562("Item"));
                this.itemsForStates.put(state, stack);
            }
            return true;
        }
        return false;
    }

    protected File getCacheDir() {
        return new File(FileUtils.getConfigDirectory(), "litematica");
    }

    protected File getCacheFile() {
        return new File(this.getCacheDir(), "material_cache.nbt");
    }

    public boolean writeToFile() {
        if (!this.dirty) {
            return false;
        }
        File dir = this.getCacheDir();
        File file = this.getCacheFile();
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                Litematica.logger.warn("Failed to write the material list cache to file '{}'", (Object)file.getAbsolutePath());
                return false;
            }
            FileOutputStream os = new FileOutputStream(file);
            class_2507.method_10634((class_2487)this.writeToNBT(), (OutputStream)os);
            os.close();
            this.dirty = false;
            return true;
        }
        catch (Exception e) {
            Litematica.logger.warn("Failed to write the material list cache to file '{}'", (Object)file.getAbsolutePath(), (Object)e);
            return false;
        }
    }

    public void readFromFile() {
        File file = this.getCacheFile();
        if (!file.exists() || !file.canRead()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            class_2487 nbt = class_2507.method_10629((InputStream)is);
            is.close();
            if (nbt != null) {
                this.readFromNBT(nbt);
                this.hasReadFromFile = true;
                this.dirty = false;
            }
        }
        catch (Exception e) {
            Litematica.logger.warn("Failed to read the material list cache from file '{}'", (Object)file.getAbsolutePath(), (Object)e);
        }
    }
}

