/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.render.shader.ShaderProgram;
import javax.annotation.Nullable;
import net.minecraft.class_1059;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_856;
import net.minecraft.class_858;
import org.lwjgl.opengl.GL20;

public class LitematicaRenderer {
    private static final LitematicaRenderer INSTANCE = new LitematicaRenderer();
    private static final ShaderProgram SHADER_ALPHA = new ShaderProgram("litematica", null, "shaders/alpha.frag");
    private class_310 mc;
    private WorldRendererSchematic worldRenderer;
    private int frameCount;
    private long finishTimeNano;
    private boolean renderPiecewise;
    private boolean renderPiecewiseSchematic;
    private boolean renderPiecewiseBlocks;
    private boolean renderPiecewisePrepared;
    private boolean translucentSchematic;

    private LitematicaRenderer() {
    }

    public static LitematicaRenderer getInstance() {
        return INSTANCE;
    }

    public WorldRendererSchematic getWorldRenderer() {
        if (this.worldRenderer == null) {
            this.mc = class_310.method_1551();
            this.worldRenderer = new WorldRendererSchematic(this.mc);
        }
        return this.worldRenderer;
    }

    public void loadRenderers() {
        this.getWorldRenderer().loadRenderers();
    }

    public void onSchematicWorldChanged(@Nullable WorldSchematic worldClient) {
        this.getWorldRenderer().setWorldAndLoadRenderers(worldClient);
    }

    private void calculateFinishTime() {
        long fpsLimit = this.mc.field_1690.field_1909;
        long fpsMin = Math.min((long)class_310.method_1497(), fpsLimit);
        fpsMin = Math.max(fpsMin, 60L);
        this.finishTimeNano = Configs.Generic.RENDER_THREAD_NO_TIMEOUT.getBooleanValue() ? Long.MAX_VALUE : System.nanoTime() + Math.max(1000000000L / fpsMin / 2L, 0L);
    }

    public void renderSchematicWorld(float partialTicks) {
        if (!this.mc.field_1743) {
            this.mc.method_16011().method_15396("litematica_schematic_world_render");
            if (this.mc.method_1560() == null) {
                this.mc.method_1504((class_1297)this.mc.field_1724);
            }
            GlStateManager.pushMatrix();
            GlStateManager.enableDepthTest();
            this.calculateFinishTime();
            this.renderWorld(partialTicks, this.finishTimeNano);
            this.cleanup();
            GlStateManager.popMatrix();
            this.mc.method_16011().method_15407();
        }
    }

    private void renderWorld(float partialTicks, long finishTimeNano) {
        this.mc.method_16011().method_15396("culling");
        GlStateManager.shadeModel((int)7425);
        class_4184 camera = this.getCamera();
        class_858 visibleRegion = new class_858();
        visibleRegion.method_3700(camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350);
        this.mc.method_16011().method_15405("prepare_terrain");
        this.mc.method_1531().method_4618(class_1059.field_5275);
        RenderUtils.disableItemLighting();
        WorldRendererSchematic worldRenderer = this.getWorldRenderer();
        this.mc.method_16011().method_15405("terrain_setup");
        worldRenderer.setupTerrain(camera, (class_856)visibleRegion, this.frameCount++, this.mc.field_1724.method_7325());
        this.mc.method_16011().method_15405("update_chunks");
        worldRenderer.updateChunks(finishTimeNano);
        this.mc.method_16011().method_15405("terrain");
        GlStateManager.matrixMode((int)5888);
        GlStateManager.disableAlphaTest();
        if (Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue()) {
            GlStateManager.pushMatrix();
            if (Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
                GlStateManager.enablePolygonOffset();
                GlStateManager.polygonOffset((float)-0.2f, (float)-0.4f);
            }
            this.startShaderIfEnabled();
            RenderUtils.setupBlend();
            worldRenderer.renderBlockLayer(class_1921.field_9178, camera);
            worldRenderer.renderBlockLayer(class_1921.field_9175, camera);
            this.mc.method_1531().method_4619(class_1059.field_5275).method_4626(false, false);
            worldRenderer.renderBlockLayer(class_1921.field_9174, camera);
            this.mc.method_1531().method_4619(class_1059.field_5275).method_4627();
            if (Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
                GlStateManager.polygonOffset((float)0.0f, (float)0.0f);
                GlStateManager.disablePolygonOffset();
            }
            GlStateManager.disableBlend();
            GlStateManager.shadeModel((int)7424);
            GlStateManager.alphaFunc((int)516, (float)0.01f);
            GlStateManager.matrixMode((int)5888);
            GlStateManager.popMatrix();
            this.mc.method_16011().method_15405("entities");
            GlStateManager.pushMatrix();
            RenderUtils.enableItemLighting();
            RenderUtils.setupBlend();
            worldRenderer.renderEntities(camera, (class_856)visibleRegion, partialTicks);
            GlStateManager.disableFog();
            GlStateManager.disableBlend();
            RenderUtils.disableItemLighting();
            GlStateManager.matrixMode((int)5888);
            GlStateManager.popMatrix();
            GlStateManager.enableCull();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            this.mc.method_1531().method_4618(class_1059.field_5275);
            GlStateManager.shadeModel((int)7425);
            this.mc.method_16011().method_15405("translucent");
            GlStateManager.depthMask((boolean)false);
            GlStateManager.pushMatrix();
            RenderUtils.setupBlend();
            worldRenderer.renderBlockLayer(class_1921.field_9179, camera);
            GlStateManager.popMatrix();
            this.disableShader();
        }
        this.mc.method_16011().method_15405("overlay");
        this.renderSchematicOverlay();
        GlStateManager.enableAlphaTest();
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.shadeModel((int)7424);
        GlStateManager.enableCull();
        this.mc.method_16011().method_15407();
    }

    public void renderSchematicOverlay() {
        boolean invert = Hotkeys.INVERT_OVERLAY_RENDER_STATE.getKeybind().isKeybindHeld();
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() != invert) {
            boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
            float lineWidth = (float)(renderThrough ? Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH_THROUGH.getDoubleValue() : Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH.getDoubleValue());
            GlStateManager.pushMatrix();
            GlStateManager.disableTexture();
            GlStateManager.disableCull();
            GlStateManager.alphaFunc((int)516, (float)0.001f);
            GlStateManager.enablePolygonOffset();
            GlStateManager.polygonOffset((float)-0.4f, (float)-0.8f);
            GlStateManager.lineWidth((float)lineWidth);
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)240.0f, (float)240.0f);
            if (renderThrough) {
                GlStateManager.disableDepthTest();
            }
            this.getWorldRenderer().renderBlockOverlays();
            GlStateManager.enableDepthTest();
            GlStateManager.polygonOffset((float)0.0f, (float)0.0f);
            GlStateManager.disablePolygonOffset();
            GlStateManager.enableTexture();
            GlStateManager.popMatrix();
        }
    }

    public void startShaderIfEnabled() {
        boolean bl = this.translucentSchematic = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue() && GLX.usePostProcess;
        if (this.translucentSchematic) {
            float alpha = (float)Configs.Visuals.GHOST_BLOCK_ALPHA.getDoubleValue();
            GL20.glUseProgram((int)SHADER_ALPHA.getProgram());
            GL20.glUniform1f((int)GL20.glGetUniformLocation((int)SHADER_ALPHA.getProgram(), (CharSequence)"alpha_multiplier"), (float)alpha);
        }
    }

    public void disableShader() {
        if (this.translucentSchematic) {
            GL20.glUseProgram((int)0);
        }
    }

    public void piecewisePrepareAndUpdate(class_856 visibleRegion) {
        this.renderPiecewise = Configs.Generic.BETTER_RENDER_ORDER.getBooleanValue() && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && this.mc.method_1560() != null;
        this.renderPiecewisePrepared = false;
        this.renderPiecewiseBlocks = false;
        if (this.renderPiecewise && visibleRegion != null) {
            boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
            this.renderPiecewiseSchematic = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() != invert;
            this.renderPiecewiseBlocks = this.renderPiecewiseSchematic && Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue();
            this.mc.method_16011().method_15396("litematica_culling");
            this.calculateFinishTime();
            WorldRendererSchematic worldRenderer = this.getWorldRenderer();
            this.mc.method_16011().method_15405("litematica_terrain_setup");
            worldRenderer.setupTerrain(this.getCamera(), visibleRegion, this.frameCount++, this.mc.field_1724.method_7325());
            this.mc.method_16011().method_15405("litematica_update_chunks");
            worldRenderer.updateChunks(this.finishTimeNano);
            this.mc.method_16011().method_15407();
            this.renderPiecewisePrepared = true;
        }
    }

    public void piecewiseRenderSolid(boolean renderColliding, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_blocks_solid");
            if (renderColliding) {
                GlStateManager.enablePolygonOffset();
                GlStateManager.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.startShaderIfEnabled();
            this.getWorldRenderer().renderBlockLayer(class_1921.field_9178, this.getCamera());
            this.disableShader();
            if (renderColliding) {
                GlStateManager.polygonOffset((float)0.0f, (float)0.0f);
                GlStateManager.disablePolygonOffset();
            }
            this.mc.method_16011().method_15407();
        }
    }

    public void piecewiseRenderCutoutMipped(boolean renderColliding, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_blocks_cutout_mipped");
            if (renderColliding) {
                GlStateManager.enablePolygonOffset();
                GlStateManager.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.startShaderIfEnabled();
            this.getWorldRenderer().renderBlockLayer(class_1921.field_9175, this.getCamera());
            this.disableShader();
            if (renderColliding) {
                GlStateManager.polygonOffset((float)0.0f, (float)0.0f);
                GlStateManager.disablePolygonOffset();
            }
            this.mc.method_16011().method_15407();
        }
    }

    public void piecewiseRenderCutout(boolean renderColliding, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_blocks_cutout");
            if (renderColliding) {
                GlStateManager.enablePolygonOffset();
                GlStateManager.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.startShaderIfEnabled();
            this.getWorldRenderer().renderBlockLayer(class_1921.field_9174, this.getCamera());
            this.disableShader();
            if (renderColliding) {
                GlStateManager.polygonOffset((float)0.0f, (float)0.0f);
                GlStateManager.disablePolygonOffset();
            }
            this.mc.method_16011().method_15407();
        }
    }

    public void piecewiseRenderTranslucent(boolean renderColliding, float partialTicks) {
        if (this.renderPiecewisePrepared) {
            if (this.renderPiecewiseBlocks) {
                this.mc.method_16011().method_15396("litematica_translucent");
                if (renderColliding) {
                    GlStateManager.enablePolygonOffset();
                    GlStateManager.polygonOffset((float)-0.3f, (float)-0.6f);
                }
                this.startShaderIfEnabled();
                this.getWorldRenderer().renderBlockLayer(class_1921.field_9179, this.getCamera());
                this.disableShader();
                if (renderColliding) {
                    GlStateManager.polygonOffset((float)0.0f, (float)0.0f);
                    GlStateManager.disablePolygonOffset();
                }
                this.mc.method_16011().method_15407();
            }
            if (this.renderPiecewiseSchematic) {
                this.mc.method_16011().method_15396("litematica_overlay");
                this.renderSchematicOverlay();
                this.mc.method_16011().method_15407();
            }
            this.cleanup();
        }
    }

    public void piecewiseRenderEntities(class_856 visibleRegion, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_entities");
            RenderUtils.setupBlend();
            this.startShaderIfEnabled();
            this.getWorldRenderer().renderEntities(this.getCamera(), visibleRegion, partialTicks);
            this.disableShader();
            GlStateManager.disableBlend();
            this.mc.method_16011().method_15407();
        }
    }

    private class_4184 getCamera() {
        return this.mc.field_1773.method_19418();
    }

    private void cleanup() {
        this.renderPiecewise = false;
        this.renderPiecewisePrepared = false;
        this.renderPiecewiseBlocks = false;
    }

    static {
        int program = SHADER_ALPHA.getProgram();
        GL20.glUseProgram((int)program);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)program, (CharSequence)"texture"), (int)0);
        GL20.glUseProgram((int)0);
    }
}

