/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_777;
import net.minecraft.class_778;

public class BlockModelRendererSchematic
extends class_778 {
    private final class_324 blockColors;
    private final Random random = new Random();

    public BlockModelRendererSchematic(class_324 blockColorsIn) {
        super(blockColorsIn);
        this.blockColors = blockColorsIn;
    }

    public boolean renderModel(class_1920 worldIn, class_1087 modelIn, class_2680 stateIn, class_2338 posIn, class_287 buffer, long rand) {
        boolean ao = class_310.method_1588() && stateIn.method_11630() == 0 && modelIn.method_4708();
        try {
            if (ao) {
                return this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, buffer, this.random, rand);
            }
            return this.renderModelFlat(worldIn, modelIn, stateIn, posIn, buffer, this.random, rand);
        }
        catch (Throwable throwable) {
            class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Tesselating block model");
            class_129 crashreportcategory = crashreport.method_562("Block model being tesselated");
            class_129.method_586((class_129)crashreportcategory, (class_2338)posIn, (class_2680)stateIn);
            crashreportcategory.method_578("Using AO", (Object)ao);
            throw new class_148(crashreport);
        }
    }

    public boolean renderModelSmooth(class_1920 worldIn, class_1087 modelIn, class_2680 stateIn, class_2338 posIn, class_287 buffer, Random random, long seedIn) {
        boolean renderedSomething = false;
        float[] quadBounds = new float[class_2350.values().length * 2];
        BitSet bitset = new BitSet(3);
        AmbientOcclusionFace aoFace = new AmbientOcclusionFace();
        for (class_2350 side : class_2350.values()) {
            random.setSeed(seedIn);
            List quads = modelIn.method_4707(stateIn, side, random);
            if (quads.isEmpty() || !this.shouldRenderModelSide(worldIn, stateIn, posIn, side)) continue;
            this.renderQuadsSmooth(worldIn, stateIn, posIn, buffer, quads, quadBounds, bitset, aoFace);
            renderedSomething = true;
        }
        random.setSeed(seedIn);
        List quads = modelIn.method_4707(stateIn, (class_2350)null, random);
        if (!quads.isEmpty()) {
            this.renderQuadsSmooth(worldIn, stateIn, posIn, buffer, quads, quadBounds, bitset, aoFace);
            renderedSomething = true;
        }
        return renderedSomething;
    }

    public boolean renderModelFlat(class_1920 worldIn, class_1087 modelIn, class_2680 stateIn, class_2338 posIn, class_287 buffer, Random random, long seedIn) {
        boolean renderedSomething = false;
        BitSet bitset = new BitSet(3);
        for (class_2350 side : class_2350.values()) {
            random.setSeed(seedIn);
            List quads = modelIn.method_4707(stateIn, side, random);
            if (quads.isEmpty() || !this.shouldRenderModelSide(worldIn, stateIn, posIn, side)) continue;
            int lightMapCoords = stateIn.method_11632(worldIn, posIn.method_10093(side));
            this.renderQuadsFlat(worldIn, stateIn, posIn, lightMapCoords, false, buffer, quads, bitset);
            renderedSomething = true;
        }
        random.setSeed(seedIn);
        List quads = modelIn.method_4707(stateIn, null, random);
        if (!quads.isEmpty()) {
            this.renderQuadsFlat(worldIn, stateIn, posIn, -1, true, buffer, quads, bitset);
            renderedSomething = true;
        }
        return renderedSomething;
    }

    private boolean shouldRenderModelSide(class_1920 worldIn, class_2680 stateIn, class_2338 posIn, class_2350 side) {
        return DataManager.getRenderLayerRange().isPositionAtRenderEdgeOnSide(posIn, side) || Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue() && Configs.Visuals.RENDER_TRANSLUCENT_INNER_SIDES.getBooleanValue() || class_2248.method_9607((class_2680)stateIn, (class_1922)worldIn, (class_2338)posIn, (class_2350)side);
    }

    private void renderQuadsSmooth(class_1920 world, class_2680 state, class_2338 pos, class_287 buffer, List<class_777> list, float[] quadBounds, BitSet bitSet, AmbientOcclusionFace aoFace) {
        class_243 vec3d = state.method_11599((class_1922)world, pos);
        double x = (double)pos.method_10263() + vec3d.field_1352;
        double y = (double)pos.method_10264() + vec3d.field_1351;
        double z = (double)pos.method_10260() + vec3d.field_1350;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            class_777 bakedquad = list.get(i);
            this.fillQuadBounds(world, state, pos, bakedquad.method_3357(), bakedquad.method_3358(), quadBounds, bitSet);
            aoFace.updateVertexBrightness(world, state, pos, bakedquad.method_3358(), quadBounds, bitSet);
            buffer.method_1333(bakedquad.method_3357());
            buffer.method_1339(aoFace.vertexBrightness[0], aoFace.vertexBrightness[1], aoFace.vertexBrightness[2], aoFace.vertexBrightness[3]);
            if (bakedquad.method_3360()) {
                int k = this.blockColors.method_1697(state, world, pos, bakedquad.method_3359());
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                buffer.method_1317(aoFace.vertexColorMultiplier[0] * f, aoFace.vertexColorMultiplier[0] * f1, aoFace.vertexColorMultiplier[0] * f2, 4);
                buffer.method_1317(aoFace.vertexColorMultiplier[1] * f, aoFace.vertexColorMultiplier[1] * f1, aoFace.vertexColorMultiplier[1] * f2, 3);
                buffer.method_1317(aoFace.vertexColorMultiplier[2] * f, aoFace.vertexColorMultiplier[2] * f1, aoFace.vertexColorMultiplier[2] * f2, 2);
                buffer.method_1317(aoFace.vertexColorMultiplier[3] * f, aoFace.vertexColorMultiplier[3] * f1, aoFace.vertexColorMultiplier[3] * f2, 1);
            } else {
                buffer.method_1317(aoFace.vertexColorMultiplier[0], aoFace.vertexColorMultiplier[0], aoFace.vertexColorMultiplier[0], 4);
                buffer.method_1317(aoFace.vertexColorMultiplier[1], aoFace.vertexColorMultiplier[1], aoFace.vertexColorMultiplier[1], 3);
                buffer.method_1317(aoFace.vertexColorMultiplier[2], aoFace.vertexColorMultiplier[2], aoFace.vertexColorMultiplier[2], 2);
                buffer.method_1317(aoFace.vertexColorMultiplier[3], aoFace.vertexColorMultiplier[3], aoFace.vertexColorMultiplier[3], 1);
            }
            buffer.method_1322(x, y, z);
        }
    }

    private void renderQuadsFlat(class_1920 world, class_2680 state, class_2338 pos, int brightnessIn, boolean ownBrightness, class_287 buffer, List<class_777> list, BitSet bitSet) {
        class_243 vec3d = state.method_11599((class_1922)world, pos);
        double d0 = (double)pos.method_10263() + vec3d.field_1352;
        double d1 = (double)pos.method_10264() + vec3d.field_1351;
        double d2 = (double)pos.method_10260() + vec3d.field_1350;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            class_777 bakedquad = list.get(i);
            if (ownBrightness) {
                this.fillQuadBounds(world, state, pos, bakedquad.method_3357(), bakedquad.method_3358(), null, bitSet);
                class_2338 blockpos = bitSet.get(0) ? pos.method_10093(bakedquad.method_3358()) : pos;
                brightnessIn = state.method_11632(world, blockpos);
            }
            buffer.method_1333(bakedquad.method_3357());
            buffer.method_1339(brightnessIn, brightnessIn, brightnessIn, brightnessIn);
            if (bakedquad.method_3360()) {
                int k = this.blockColors.method_1697(state, world, pos, bakedquad.method_3359());
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                buffer.method_1317(f, f1, f2, 4);
                buffer.method_1317(f, f1, f2, 3);
                buffer.method_1317(f, f1, f2, 2);
                buffer.method_1317(f, f1, f2, 1);
            }
            buffer.method_1322(d0, d1, d2);
        }
    }

    private void fillQuadBounds(class_1920 world, class_2680 stateIn, class_2338 pos, int[] vertexData, class_2350 face, @Nullable float[] quadBounds, BitSet boundsFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertexData[i * 7]);
            float f7 = Float.intBitsToFloat(vertexData[i * 7 + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i * 7 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[class_2350.field_11039.method_10146()] = f;
            quadBounds[class_2350.field_11034.method_10146()] = f3;
            quadBounds[class_2350.field_11033.method_10146()] = f1;
            quadBounds[class_2350.field_11036.method_10146()] = f4;
            quadBounds[class_2350.field_11043.method_10146()] = f2;
            quadBounds[class_2350.field_11035.method_10146()] = f5;
            int j = class_2350.values().length;
            quadBounds[class_2350.field_11039.method_10146() + j] = 1.0f - f;
            quadBounds[class_2350.field_11034.method_10146() + j] = 1.0f - f3;
            quadBounds[class_2350.field_11033.method_10146() + j] = 1.0f - f1;
            quadBounds[class_2350.field_11036.method_10146() + j] = 1.0f - f4;
            quadBounds[class_2350.field_11043.method_10146() + j] = 1.0f - f2;
            quadBounds[class_2350.field_11035.method_10146() + j] = 1.0f - f5;
        }
        switch (face) {
            case field_11033: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f1 < 1.0E-4f || class_2248.method_9614((class_265)stateIn.method_11628((class_1922)world, pos))) && f1 == f4);
                break;
            }
            case field_11036: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f4 > 0.9999f || class_2248.method_9614((class_265)stateIn.method_11628((class_1922)world, pos))) && f1 == f4);
                break;
            }
            case field_11043: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f2 < 1.0E-4f || class_2248.method_9614((class_265)stateIn.method_11628((class_1922)world, pos))) && f2 == f5);
                break;
            }
            case field_11035: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f5 > 0.9999f || class_2248.method_9614((class_265)stateIn.method_11628((class_1922)world, pos))) && f2 == f5);
                break;
            }
            case field_11039: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f < 1.0E-4f || class_2248.method_9614((class_265)stateIn.method_11628((class_1922)world, pos))) && f == f3);
                break;
            }
            case field_11034: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f3 > 0.9999f || class_2248.method_9614((class_265)stateIn.method_11628((class_1922)world, pos))) && f == f3);
            }
        }
    }

    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int vert0;
        private final int vert1;
        private final int vert2;
        private final int vert3;
        private static final VertexTranslations[] VALUES;

        private VertexTranslations(int p_i46234_3_, int p_i46234_4_, int p_i46234_5_, int p_i46234_6_) {
            this.vert0 = p_i46234_3_;
            this.vert1 = p_i46234_4_;
            this.vert2 = p_i46234_5_;
            this.vert3 = p_i46234_6_;
        }

        public static VertexTranslations getVertexTranslations(class_2350 p_178184_0_) {
            return VALUES[p_178184_0_.method_10146()];
        }

        static {
            VALUES = new VertexTranslations[6];
            VertexTranslations.VALUES[class_2350.field_11033.method_10146()] = DOWN;
            VertexTranslations.VALUES[class_2350.field_11036.method_10146()] = UP;
            VertexTranslations.VALUES[class_2350.field_11043.method_10146()] = NORTH;
            VertexTranslations.VALUES[class_2350.field_11035.method_10146()] = SOUTH;
            VertexTranslations.VALUES[class_2350.field_11039.method_10146()] = WEST;
            VertexTranslations.VALUES[class_2350.field_11034.method_10146()] = EAST;
        }
    }

    public static enum Orientation {
        DOWN(class_2350.field_11033, false),
        UP(class_2350.field_11036, false),
        NORTH(class_2350.field_11043, false),
        SOUTH(class_2350.field_11035, false),
        WEST(class_2350.field_11039, false),
        EAST(class_2350.field_11034, false),
        FLIP_DOWN(class_2350.field_11033, true),
        FLIP_UP(class_2350.field_11036, true),
        FLIP_NORTH(class_2350.field_11043, true),
        FLIP_SOUTH(class_2350.field_11035, true),
        FLIP_WEST(class_2350.field_11039, true),
        FLIP_EAST(class_2350.field_11034, true);

        private final int shape;

        private Orientation(class_2350 p_i46233_3_, boolean p_i46233_4_) {
            this.shape = p_i46233_3_.method_10146() + (p_i46233_4_ ? class_2350.values().length : 0);
        }
    }

    public static enum EnumNeighborInfo {
        DOWN(new class_2350[]{class_2350.field_11039, class_2350.field_11034, class_2350.field_11043, class_2350.field_11035}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new class_2350[]{class_2350.field_11034, class_2350.field_11039, class_2350.field_11043, class_2350.field_11035}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new class_2350[]{class_2350.field_11036, class_2350.field_11033, class_2350.field_11034, class_2350.field_11039}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new class_2350[]{class_2350.field_11039, class_2350.field_11034, class_2350.field_11033, class_2350.field_11036}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new class_2350[]{class_2350.field_11036, class_2350.field_11033, class_2350.field_11043, class_2350.field_11035}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        private final boolean doNonCubicWeight;
        private final Orientation[] vert0Weights;
        private final Orientation[] vert1Weights;
        private final Orientation[] vert2Weights;
        private final Orientation[] vert3Weights;
        private static final EnumNeighborInfo[] VALUES;

        private EnumNeighborInfo(class_2350[] p_i46236_3_, float p_i46236_4_, boolean p_i46236_5_, Orientation[] p_i46236_6_, Orientation[] p_i46236_7_, Orientation[] p_i46236_8_, Orientation[] p_i46236_9_) {
            this.doNonCubicWeight = p_i46236_5_;
            this.vert0Weights = p_i46236_6_;
            this.vert1Weights = p_i46236_7_;
            this.vert2Weights = p_i46236_8_;
            this.vert3Weights = p_i46236_9_;
        }

        public static EnumNeighborInfo getNeighbourInfo(class_2350 p_178273_0_) {
            return VALUES[p_178273_0_.method_10146()];
        }

        static {
            VALUES = new EnumNeighborInfo[6];
            EnumNeighborInfo.VALUES[class_2350.field_11033.method_10146()] = DOWN;
            EnumNeighborInfo.VALUES[class_2350.field_11036.method_10146()] = UP;
            EnumNeighborInfo.VALUES[class_2350.field_11043.method_10146()] = NORTH;
            EnumNeighborInfo.VALUES[class_2350.field_11035.method_10146()] = SOUTH;
            EnumNeighborInfo.VALUES[class_2350.field_11039.method_10146()] = WEST;
            EnumNeighborInfo.VALUES[class_2350.field_11034.method_10146()] = EAST;
        }
    }

    class AmbientOcclusionFace {
        private final float[] vertexColorMultiplier = new float[4];
        private final int[] vertexBrightness = new int[4];

        AmbientOcclusionFace() {
        }

        public void updateVertexBrightness(class_1920 worldIn, class_2680 state, class_2338 centerPos, class_2350 direction, float[] faceShape, BitSet shapeState) {
            EnumNeighborInfo neighborInfo = EnumNeighborInfo.getNeighbourInfo(direction);
            VertexTranslations vertexTranslations = VertexTranslations.getVertexTranslations(direction);
            float f8 = 1.0f;
            float f7 = 1.0f;
            float f6 = 1.0f;
            float f5 = 1.0f;
            float f4 = 1.0f;
            float f3 = 1.0f;
            float f2 = 1.0f;
            float f1 = 1.0f;
            float f = 1.0f;
            int l1 = 0xF000F0;
            int k1 = 0xF000F0;
            int j1 = 0xF000F0;
            int i3 = 0xF000F0;
            int i1 = 0xF000F0;
            int l = 0xF000F0;
            int k = 0xF000F0;
            int j = 0xF000F0;
            int i = 0xF000F0;
            if (shapeState.get(1) && neighborInfo.doNonCubicWeight) {
                float f29 = (f3 + f + f5 + f8) * 0.25f;
                float f30 = (f2 + f + f4 + f8) * 0.25f;
                float f31 = (f2 + f1 + f6 + f8) * 0.25f;
                float f32 = (f3 + f1 + f7 + f8) * 0.25f;
                float f13 = faceShape[neighborInfo.vert0Weights[0].shape] * faceShape[neighborInfo.vert0Weights[1].shape];
                float f14 = faceShape[neighborInfo.vert0Weights[2].shape] * faceShape[neighborInfo.vert0Weights[3].shape];
                float f15 = faceShape[neighborInfo.vert0Weights[4].shape] * faceShape[neighborInfo.vert0Weights[5].shape];
                float f16 = faceShape[neighborInfo.vert0Weights[6].shape] * faceShape[neighborInfo.vert0Weights[7].shape];
                float f17 = faceShape[neighborInfo.vert1Weights[0].shape] * faceShape[neighborInfo.vert1Weights[1].shape];
                float f18 = faceShape[neighborInfo.vert1Weights[2].shape] * faceShape[neighborInfo.vert1Weights[3].shape];
                float f19 = faceShape[neighborInfo.vert1Weights[4].shape] * faceShape[neighborInfo.vert1Weights[5].shape];
                float f20 = faceShape[neighborInfo.vert1Weights[6].shape] * faceShape[neighborInfo.vert1Weights[7].shape];
                float f21 = faceShape[neighborInfo.vert2Weights[0].shape] * faceShape[neighborInfo.vert2Weights[1].shape];
                float f22 = faceShape[neighborInfo.vert2Weights[2].shape] * faceShape[neighborInfo.vert2Weights[3].shape];
                float f23 = faceShape[neighborInfo.vert2Weights[4].shape] * faceShape[neighborInfo.vert2Weights[5].shape];
                float f24 = faceShape[neighborInfo.vert2Weights[6].shape] * faceShape[neighborInfo.vert2Weights[7].shape];
                float f25 = faceShape[neighborInfo.vert3Weights[0].shape] * faceShape[neighborInfo.vert3Weights[1].shape];
                float f26 = faceShape[neighborInfo.vert3Weights[2].shape] * faceShape[neighborInfo.vert3Weights[3].shape];
                float f27 = faceShape[neighborInfo.vert3Weights[4].shape] * faceShape[neighborInfo.vert3Weights[5].shape];
                float f28 = faceShape[neighborInfo.vert3Weights[6].shape] * faceShape[neighborInfo.vert3Weights[7].shape];
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert0] = f29 * f13 + f30 * f14 + f31 * f15 + f32 * f16;
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert1] = f29 * f17 + f30 * f18 + f31 * f19 + f32 * f20;
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert2] = f29 * f21 + f30 * f22 + f31 * f23 + f32 * f24;
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert3] = f29 * f25 + f30 * f26 + f31 * f27 + f32 * f28;
                int i2 = this.getAoBrightness(l, i, j1, i3);
                int j2 = this.getAoBrightness(k, i, i1, i3);
                int k2 = this.getAoBrightness(k, j, k1, i3);
                int l2 = this.getAoBrightness(l, j, l1, i3);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert0] = this.getVertexBrightness(i2, j2, k2, l2, f13, f14, f15, f16);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert1] = this.getVertexBrightness(i2, j2, k2, l2, f17, f18, f19, f20);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert2] = this.getVertexBrightness(i2, j2, k2, l2, f21, f22, f23, f24);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert3] = this.getVertexBrightness(i2, j2, k2, l2, f25, f26, f27, f28);
            } else {
                float f9 = (f3 + f + f5 + f8) * 0.25f;
                float f10 = (f2 + f + f4 + f8) * 0.25f;
                float f11 = (f2 + f1 + f6 + f8) * 0.25f;
                float f12 = (f3 + f1 + f7 + f8) * 0.25f;
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert0] = this.getAoBrightness(l, i, j1, i3);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert1] = this.getAoBrightness(k, i, i1, i3);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert2] = this.getAoBrightness(k, j, k1, i3);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert3] = this.getAoBrightness(l, j, l1, i3);
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert0] = f9;
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert1] = f10;
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert2] = f11;
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert3] = f12;
            }
        }

        private int getAoBrightness(int br1, int br2, int br3, int br4) {
            if (br1 == 0) {
                br1 = br4;
            }
            if (br2 == 0) {
                br2 = br4;
            }
            if (br3 == 0) {
                br3 = br4;
            }
            return br1 + br2 + br3 + br4 >> 2 & 0xFF00FF;
        }

        private int getVertexBrightness(int p_178203_1_, int p_178203_2_, int p_178203_3_, int p_178203_4_, float p_178203_5_, float p_178203_6_, float p_178203_7_, float p_178203_8_) {
            int i = (int)((float)(p_178203_1_ >> 16 & 0xFF) * p_178203_5_ + (float)(p_178203_2_ >> 16 & 0xFF) * p_178203_6_ + (float)(p_178203_3_ >> 16 & 0xFF) * p_178203_7_ + (float)(p_178203_4_ >> 16 & 0xFF) * p_178203_8_) & 0xFF;
            int j = (int)((float)(p_178203_1_ & 0xFF) * p_178203_5_ + (float)(p_178203_2_ & 0xFF) * p_178203_6_ + (float)(p_178203_3_ & 0xFF) * p_178203_7_ + (float)(p_178203_4_ & 0xFF) * p_178203_8_) & 0xFF;
            return i << 16 | j;
        }
    }
}

