/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.render.schematic.BufferBuilderCache;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRenderTaskSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;
import net.minecraft.class_128;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_310;
import org.apache.logging.log4j.Logger;

public class ChunkRenderWorkerLitematica
implements Runnable {
    private static final Logger LOGGER = Litematica.logger;
    private final ChunkRenderDispatcherLitematica chunkRenderDispatcher;
    private final BufferBuilderCache bufferCache;
    private boolean shouldRun = true;

    public ChunkRenderWorkerLitematica(ChunkRenderDispatcherLitematica chunkRenderDispatcherIn) {
        this(chunkRenderDispatcherIn, null);
    }

    public ChunkRenderWorkerLitematica(ChunkRenderDispatcherLitematica chunkRenderDispatcherIn, @Nullable BufferBuilderCache bufferCache) {
        this.chunkRenderDispatcher = chunkRenderDispatcherIn;
        this.bufferCache = bufferCache;
    }

    @Override
    public void run() {
        while (this.shouldRun) {
            try {
                this.processTask(this.chunkRenderDispatcher.getNextChunkUpdate());
            }
            catch (InterruptedException e) {
                LOGGER.debug("Stopping chunk worker due to interrupt");
                return;
            }
            catch (Throwable throwable) {
                class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Batching chunks");
                class_310.method_1551().method_1494(class_310.method_1551().method_1587(crashreport));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTask(final ChunkRenderTaskSchematic generator) throws InterruptedException {
        generator.getLock().lock();
        try {
            if (generator.getStatus() != ChunkRenderTaskSchematic.Status.PENDING) {
                if (!generator.isFinished()) {
                    LOGGER.warn("Chunk render task was {} when I expected it to be pending; ignoring task", (Object)generator.getStatus());
                }
                return;
            }
            generator.setStatus(ChunkRenderTaskSchematic.Status.COMPILING);
        }
        finally {
            generator.getLock().unlock();
        }
        class_1297 entity = class_310.method_1551().method_1560();
        if (entity == null) {
            generator.finish();
        } else {
            generator.setRegionRenderCacheBuilder(this.getRegionRenderCacheBuilder());
            ChunkRenderTaskSchematic.Type generatorType = generator.getType();
            float x = (float)entity.field_5987;
            float y = (float)entity.field_6010 + entity.method_5751();
            float z = (float)entity.field_6035;
            if (generatorType == ChunkRenderTaskSchematic.Type.REBUILD_CHUNK) {
                generator.getRenderChunk().rebuildChunk(x, y, z, generator);
            } else if (generatorType == ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY) {
                generator.getRenderChunk().resortTransparency(x, y, z, generator);
            }
            generator.getLock().lock();
            try {
                if (generator.getStatus() != ChunkRenderTaskSchematic.Status.COMPILING) {
                    if (!generator.isFinished()) {
                        LOGGER.warn("Chunk render task was {} when I expected it to be compiling; aborting task", (Object)generator.getStatus());
                    }
                    this.freeRenderBuilder(generator);
                    return;
                }
                generator.setStatus(ChunkRenderTaskSchematic.Status.UPLOADING);
            }
            finally {
                generator.getLock().unlock();
            }
            final ChunkRenderDataSchematic chunkRenderData = generator.getChunkRenderData();
            ArrayList futuresList = Lists.newArrayList();
            BufferBuilderCache buffers = generator.getBufferCache();
            ChunkRendererSchematicVbo renderChunk = generator.getRenderChunk();
            if (generatorType == ChunkRenderTaskSchematic.Type.REBUILD_CHUNK) {
                class_287 buffer;
                for (class_1921 class_19212 : class_1921.values()) {
                    if (chunkRenderData.isBlockLayerEmpty(class_19212)) continue;
                    buffer = buffers.getBlockBufferByLayer(class_19212);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkBlocks(class_19212, buffer, renderChunk, chunkRenderData, generator.getDistanceSq()));
                }
                for (ChunkRendererSchematicVbo.OverlayRenderType overlayRenderType : ChunkRendererSchematicVbo.OverlayRenderType.values()) {
                    if (chunkRenderData.isOverlayTypeEmpty(overlayRenderType)) continue;
                    buffer = buffers.getOverlayBuffer(overlayRenderType);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkOverlay(overlayRenderType, buffer, renderChunk, chunkRenderData, generator.getDistanceSq()));
                }
            } else if (generatorType == ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY) {
                class_287 class_2872 = buffers.getBlockBufferByLayer(class_1921.field_9179);
                futuresList.add(this.chunkRenderDispatcher.uploadChunkBlocks(class_1921.field_9179, class_2872, renderChunk, chunkRenderData, generator.getDistanceSq()));
                if (!chunkRenderData.isOverlayTypeEmpty(ChunkRendererSchematicVbo.OverlayRenderType.QUAD)) {
                    class_287 class_2873 = buffers.getOverlayBuffer(ChunkRendererSchematicVbo.OverlayRenderType.QUAD);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkOverlay(ChunkRendererSchematicVbo.OverlayRenderType.QUAD, class_2873, renderChunk, chunkRenderData, generator.getDistanceSq()));
                }
            }
            final ListenableFuture listenableFuture = Futures.allAsList((Iterable)futuresList);
            generator.addFinishRunnable(new Runnable(){

                @Override
                public void run() {
                    listenableFuture.cancel(false);
                }
            });
            Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<List<Object>>(){

                public void onSuccess(@Nullable List<Object> list) {
                    block6: {
                        ChunkRenderWorkerLitematica.this.freeRenderBuilder(generator);
                        generator.getLock().lock();
                        try {
                            if (generator.getStatus() == ChunkRenderTaskSchematic.Status.UPLOADING) {
                                generator.setStatus(ChunkRenderTaskSchematic.Status.DONE);
                                break block6;
                            }
                            if (!generator.isFinished()) {
                                LOGGER.warn("Chunk render task was {} when I expected it to be uploading; aborting task", (Object)generator.getStatus());
                            }
                        }
                        finally {
                            generator.getLock().unlock();
                        }
                        return;
                    }
                    generator.getRenderChunk().setChunkRenderData(chunkRenderData);
                }

                public void onFailure(Throwable throwable) {
                    ChunkRenderWorkerLitematica.this.freeRenderBuilder(generator);
                    if (!(throwable instanceof CancellationException) && !(throwable instanceof InterruptedException)) {
                        class_310.method_1551().method_1494(class_128.method_560((Throwable)throwable, (String)"Rendering Litematica chunk"));
                    }
                }
            });
        }
    }

    private BufferBuilderCache getRegionRenderCacheBuilder() throws InterruptedException {
        return this.bufferCache != null ? this.bufferCache : this.chunkRenderDispatcher.allocateRenderBuilder();
    }

    private void freeRenderBuilder(ChunkRenderTaskSchematic generator) {
        if (this.bufferCache == null) {
            this.chunkRenderDispatcher.freeRenderBuilder(generator.getBufferCache());
        }
    }

    public void notifyToStop() {
        this.shouldRun = false;
    }
}

