/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.schematic.BlockModelRendererSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRendererListSchematicBase;
import fi.dy.masa.litematica.render.schematic.ChunkRendererListSchematicDisplaylist;
import fi.dy.masa.litematica.render.schematic.ChunkRendererListSchematicVbo;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import fi.dy.masa.litematica.render.schematic.IChunkRendererFactory;
import fi.dy.masa.litematica.render.schematic.RenderChunkFactoryList;
import fi.dy.masa.litematica.render.schematic.RenderChunkFactoryVbo;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_296;
import net.minecraft.class_310;
import net.minecraft.class_3509;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4184;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_856;
import net.minecraft.class_898;

public class WorldRendererSchematic {
    private final class_310 mc;
    private final class_898 entityRenderDispatcher;
    private final class_776 blockRenderManager;
    private final BlockModelRendererSchematic blockModelRenderer;
    private final Set<class_2586> blockEntities = new HashSet<class_2586>();
    private final List<ChunkRendererSchematicVbo> renderInfos = new ArrayList<ChunkRendererSchematicVbo>(1024);
    private Set<ChunkRendererSchematicVbo> chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
    private WorldSchematic world;
    private ChunkRenderDispatcherSchematic chunkRendererDispatcher;
    private double lastCameraChunkUpdateX = Double.MIN_VALUE;
    private double lastCameraChunkUpdateY = Double.MIN_VALUE;
    private double lastCameraChunkUpdateZ = Double.MIN_VALUE;
    private int cameraChunkX = Integer.MIN_VALUE;
    private int cameraChunkY = Integer.MIN_VALUE;
    private int cameraChunkZ = Integer.MIN_VALUE;
    private double lastViewEntityX = Double.MIN_VALUE;
    private double lastViewEntityY = Double.MIN_VALUE;
    private double lastViewEntityZ = Double.MIN_VALUE;
    private float lastViewEntityPitch = Float.MIN_VALUE;
    private float lastViewEntityYaw = Float.MIN_VALUE;
    private ChunkRenderDispatcherLitematica renderDispatcher;
    private ChunkRendererListSchematicBase renderContainer;
    private IChunkRendererFactory renderChunkFactory;
    private int renderDistanceChunks = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    private boolean vboEnabled;
    private double prevRenderSortX;
    private double prevRenderSortY;
    private double prevRenderSortZ;
    private boolean displayListEntitiesDirty = true;

    public WorldRendererSchematic(class_310 mc) {
        this.mc = mc;
        this.entityRenderDispatcher = mc.method_1561();
        this.vboEnabled = GLX.useVbo();
        if (this.vboEnabled) {
            this.renderContainer = new ChunkRendererListSchematicVbo();
            this.renderChunkFactory = new RenderChunkFactoryVbo();
        } else {
            this.renderContainer = new ChunkRendererListSchematicDisplaylist();
            this.renderChunkFactory = new RenderChunkFactoryList();
        }
        this.blockRenderManager = class_310.method_1551().method_1541();
        this.blockModelRenderer = new BlockModelRendererSchematic(mc.method_1505());
    }

    public void markNeedsUpdate() {
        this.displayListEntitiesDirty = true;
    }

    public String getDebugInfoRenders() {
        int rcTotal = this.chunkRendererDispatcher != null ? this.chunkRendererDispatcher.renderers.length : 0;
        int rcRendered = this.chunkRendererDispatcher != null ? this.getRenderedChunks() : 0;
        return String.format("C: %d/%d %sD: %d, L: %d, %s", rcRendered, rcTotal, this.mc.field_1730 ? "(s) " : "", this.renderDistanceChunks, 0, this.renderDispatcher == null ? "null" : this.renderDispatcher.getDebugInfo());
    }

    public String getDebugInfoEntities() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ", B: " + this.countEntitiesHidden;
    }

    protected int getRenderedChunks() {
        int count = 0;
        for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
            ChunkRenderDataSchematic data = chunkRenderer.chunkRenderData;
            if (data == ChunkRenderDataSchematic.EMPTY || data.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public void setWorldAndLoadRenderers(@Nullable WorldSchematic worldSchematic) {
        this.lastCameraChunkUpdateX = Double.MIN_VALUE;
        this.lastCameraChunkUpdateY = Double.MIN_VALUE;
        this.lastCameraChunkUpdateZ = Double.MIN_VALUE;
        this.cameraChunkX = Integer.MIN_VALUE;
        this.cameraChunkY = Integer.MIN_VALUE;
        this.cameraChunkZ = Integer.MIN_VALUE;
        this.world = worldSchematic;
        if (worldSchematic != null) {
            this.loadRenderers();
        } else {
            this.chunksToUpdate.clear();
            this.renderInfos.clear();
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
                this.chunkRendererDispatcher = null;
            }
            if (this.renderDispatcher != null) {
                this.renderDispatcher.stopWorkerThreads();
            }
            this.renderDispatcher = null;
            this.blockEntities.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRenderers() {
        if (this.world != null) {
            if (this.renderDispatcher == null) {
                this.renderDispatcher = new ChunkRenderDispatcherLitematica();
            }
            this.displayListEntitiesDirty = true;
            this.renderDistanceChunks = this.mc.field_1690.field_1870;
            boolean vboEnabledPrevious = this.vboEnabled;
            this.vboEnabled = GLX.useVbo();
            if (!this.vboEnabled && vboEnabledPrevious) {
                this.renderContainer = new ChunkRendererListSchematicDisplaylist();
                this.renderChunkFactory = new RenderChunkFactoryList();
            } else if (this.vboEnabled && !vboEnabledPrevious) {
                this.renderContainer = new ChunkRendererListSchematicVbo();
                this.renderChunkFactory = new RenderChunkFactoryVbo();
            }
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
            }
            this.stopChunkUpdates();
            Set<class_2586> set = this.blockEntities;
            synchronized (set) {
                this.blockEntities.clear();
            }
            this.chunkRendererDispatcher = new ChunkRenderDispatcherSchematic(this.world, this.renderDistanceChunks, this, this.renderChunkFactory);
            class_1297 entity = this.mc.method_1560();
            if (entity != null) {
                this.chunkRendererDispatcher.updateCameraPosition(entity.field_5987, entity.field_6035);
            }
            this.renderEntitiesStartupCounter = 2;
        }
    }

    protected void stopChunkUpdates() {
        this.chunksToUpdate.clear();
        this.renderDispatcher.stopChunkUpdates();
    }

    public void setupTerrain(class_4184 camera, class_856 visibleRegion, int frameCount, boolean playerSpectator) {
        Set<ChunkRendererSchematicVbo> set;
        class_1297 entity;
        this.world.method_16107().method_15396("setup_terrain");
        if (this.chunkRendererDispatcher == null || this.mc.field_1690.field_1870 != this.renderDistanceChunks) {
            this.loadRenderers();
        }
        if ((entity = this.mc.method_1560()) == null) {
            entity = this.mc.field_1724;
        }
        this.world.method_16107().method_15396("camera");
        double entityX = entity.field_5987;
        double entityY = entity.field_6010;
        double entityZ = entity.field_6035;
        double diffX = entityX - this.lastCameraChunkUpdateX;
        double diffY = entityY - this.lastCameraChunkUpdateY;
        double diffZ = entityZ - this.lastCameraChunkUpdateZ;
        if (this.cameraChunkX != entity.field_6024 || this.cameraChunkY != entity.field_5959 || this.cameraChunkZ != entity.field_5980 || diffX * diffX + diffY * diffY + diffZ * diffZ > 16.0) {
            this.lastCameraChunkUpdateX = entityX;
            this.lastCameraChunkUpdateY = entityY;
            this.lastCameraChunkUpdateZ = entityZ;
            this.cameraChunkX = entity.field_6024;
            this.cameraChunkY = entity.field_5959;
            this.cameraChunkZ = entity.field_5980;
            this.chunkRendererDispatcher.updateCameraPosition(entityX, entityZ);
        }
        this.world.method_16107().method_15405("renderlist_camera");
        double cameraX = camera.method_19326().field_1352;
        double cameraY = camera.method_19326().field_1351;
        double cameraZ = camera.method_19326().field_1350;
        this.renderContainer.setCameraPosition(cameraX, cameraY, cameraZ);
        this.world.method_16107().method_15405("culling");
        class_2338 viewPos = new class_2338(cameraX, cameraY + (double)entity.method_5751(), cameraZ);
        int centerChunkX = viewPos.method_10263() >> 4;
        int centerChunkZ = viewPos.method_10260() >> 4;
        int renderDistance = this.mc.field_1690.field_1870;
        SubChunkPos viewSubChunk = new SubChunkPos(centerChunkX, viewPos.method_10264() >> 4, centerChunkZ);
        class_2338 viewPosSubChunk = new class_2338(viewSubChunk.method_10263() << 4, viewSubChunk.method_10264() << 4, viewSubChunk.method_10260() << 4);
        this.displayListEntitiesDirty = this.displayListEntitiesDirty || !this.chunksToUpdate.isEmpty() || entityX != this.lastViewEntityX || entityY != this.lastViewEntityY || entityZ != this.lastViewEntityZ || entity.field_5965 != this.lastViewEntityPitch || entity.field_6031 != this.lastViewEntityYaw;
        this.lastViewEntityX = cameraX;
        this.lastViewEntityY = cameraY;
        this.lastViewEntityZ = cameraZ;
        this.lastViewEntityPitch = camera.method_19329();
        this.lastViewEntityYaw = camera.method_19330();
        this.world.method_16107().method_15405("update");
        if (this.displayListEntitiesDirty) {
            this.world.method_16107().method_15396("fetch");
            this.displayListEntitiesDirty = false;
            this.renderInfos.clear();
            class_1297.method_5840((double)class_3532.method_15350((double)((double)renderDistance / 8.0), (double)1.0, (double)2.5));
            set = DataManager.getSchematicPlacementManager().getAllTouchedSubChunks();
            ArrayList<ChunkRendererSchematicVbo> positions = new ArrayList<ChunkRendererSchematicVbo>(set.size());
            positions.addAll(set);
            Collections.sort(positions, new SubChunkPos.DistanceComparator(viewSubChunk));
            this.world.method_16107().method_15405("iteration");
            for (int i = 0; i < positions.size(); ++i) {
                class_2338 subChunkCornerPos;
                ChunkRendererSchematicVbo chunkRenderer;
                SubChunkPos subChunk = (SubChunkPos)positions.get(i);
                if (Math.abs(subChunk.method_10263() - centerChunkX) > renderDistance || Math.abs(subChunk.method_10260() - centerChunkZ) > renderDistance || !this.world.getChunkProvider().method_12123(subChunk.method_10263(), subChunk.method_10260()) || (chunkRenderer = this.chunkRendererDispatcher.getChunkRenderer(subChunkCornerPos = new class_2338(subChunk.method_10263() << 4, subChunk.method_10264() << 4, subChunk.method_10260() << 4))) == null || !visibleRegion.method_3699(chunkRenderer.getBoundingBox())) continue;
                if (chunkRenderer.needsUpdate() && subChunkCornerPos.equals((Object)viewPosSubChunk)) {
                    chunkRenderer.setNeedsUpdate(true);
                }
                this.renderInfos.add(chunkRenderer);
            }
            this.world.method_16107().method_15407();
        }
        this.world.method_16107().method_15405("rebuild_near");
        set = this.chunksToUpdate;
        this.chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
        for (ChunkRendererSchematicVbo chunkRendererTmp : this.renderInfos) {
            boolean isNear;
            if (!chunkRendererTmp.needsUpdate() && !set.contains(chunkRendererTmp)) continue;
            this.displayListEntitiesDirty = true;
            class_2338 pos = chunkRendererTmp.getPosition().method_10069(8, 8, 8);
            boolean bl = isNear = pos.method_10262((class_2382)viewPos) < 1024.0;
            if (!chunkRendererTmp.needsImmediateUpdate() && !isNear) {
                this.chunksToUpdate.add(chunkRendererTmp);
                continue;
            }
            this.world.method_16107().method_15396("build_near");
            this.renderDispatcher.updateChunkNow(chunkRendererTmp);
            chunkRendererTmp.clearNeedsUpdate();
            this.world.method_16107().method_15407();
        }
        this.chunksToUpdate.addAll(set);
        this.world.method_16107().method_15407();
        this.world.method_16107().method_15407();
    }

    public void updateChunks(long finishTimeNano) {
        this.displayListEntitiesDirty |= this.renderDispatcher.runChunkUploads(finishTimeNano);
        if (!this.chunksToUpdate.isEmpty()) {
            ChunkRendererSchematicVbo renderChunk;
            boolean flag;
            Iterator<ChunkRendererSchematicVbo> iterator = this.chunksToUpdate.iterator();
            while (iterator.hasNext() && (flag = (renderChunk = iterator.next()).needsImmediateUpdate() ? this.renderDispatcher.updateChunkNow(renderChunk) : this.renderDispatcher.updateChunkLater(renderChunk))) {
                renderChunk.clearNeedsUpdate();
                iterator.remove();
                long i = finishTimeNano - System.nanoTime();
                if (i >= 0L) continue;
                break;
            }
        }
    }

    public int renderBlockLayer(class_1921 blockLayerIn, class_4184 camera) {
        this.world.method_16107().method_15396("render_block_layer_" + blockLayerIn);
        RenderUtils.disableItemLighting();
        if (blockLayerIn == class_1921.field_9179) {
            this.world.method_16107().method_15396("translucent_sort");
            class_243 pos = camera.method_19326();
            double diffX = pos.field_1352 - this.prevRenderSortX;
            double diffY = pos.field_1351 - this.prevRenderSortY;
            double diffZ = pos.field_1350 - this.prevRenderSortZ;
            if (diffX * diffX + diffY * diffY + diffZ * diffZ > 1.0) {
                this.prevRenderSortX = pos.field_1352;
                this.prevRenderSortY = pos.field_1351;
                this.prevRenderSortZ = pos.field_1350;
                int i = 0;
                for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                    if (!chunkRenderer.getChunkRenderData().isBlockLayerStarted(blockLayerIn) && (chunkRenderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !chunkRenderer.hasOverlay()) || i++ >= 15) continue;
                    this.renderDispatcher.updateTransparencyLater(chunkRenderer);
                }
            }
            this.world.method_16107().method_15407();
        }
        this.world.method_16107().method_15396("filter_empty");
        boolean reverse = blockLayerIn == class_1921.field_9179;
        int startIndex = reverse ? this.renderInfos.size() - 1 : 0;
        int stopIndex = reverse ? -1 : this.renderInfos.size();
        int increment = reverse ? -1 : 1;
        int count = 0;
        for (int i = startIndex; i != stopIndex; i += increment) {
            ChunkRendererSchematicVbo renderchunk = this.renderInfos.get(i);
            if (renderchunk.getChunkRenderData().isBlockLayerEmpty(blockLayerIn)) continue;
            ++count;
            this.renderContainer.addChunkRenderer(renderchunk);
        }
        this.world.method_16107().method_15405("render");
        this.renderBlockLayer(blockLayerIn);
        this.world.method_16107().method_15407();
        this.world.method_16107().method_15407();
        return count;
    }

    private void renderBlockLayer(class_1921 layer) {
        this.mc.field_1773.method_3180();
        if (GLX.useVbo()) {
            GlStateManager.enableClientState((int)32884);
            GLX.glClientActiveTexture((int)GLX.GL_TEXTURE0);
            GlStateManager.enableClientState((int)32888);
            GLX.glClientActiveTexture((int)GLX.GL_TEXTURE1);
            GlStateManager.enableClientState((int)32888);
            GLX.glClientActiveTexture((int)GLX.GL_TEXTURE0);
            GlStateManager.enableClientState((int)32886);
        }
        this.renderContainer.renderChunkLayer(layer);
        if (GLX.useVbo()) {
            for (class_296 element : class_290.field_1582.method_1357()) {
                class_296.class_298 type = element.method_1382();
                int index = element.method_1385();
                switch (type) {
                    case field_1633: {
                        GlStateManager.disableClientState((int)32884);
                        break;
                    }
                    case field_1636: {
                        GLX.glClientActiveTexture((int)(GLX.GL_TEXTURE0 + index));
                        GlStateManager.disableClientState((int)32888);
                        GLX.glClientActiveTexture((int)GLX.GL_TEXTURE0);
                        break;
                    }
                    case field_1632: {
                        GlStateManager.disableClientState((int)32886);
                        GlStateManager.clearCurrentColor();
                    }
                }
            }
        }
        this.mc.field_1773.method_3187();
    }

    public void renderBlockOverlays() {
        this.renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType.OUTLINE);
        this.renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType.QUAD);
    }

    private void renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType type) {
        this.world.method_16107().method_15396("overlay_" + type.name());
        this.world.method_16107().method_15396("filter_empty");
        for (int i = this.renderInfos.size() - 1; i >= 0; --i) {
            ChunkRenderDataSchematic compiledChunk;
            ChunkRendererSchematicVbo chunkRenderer = this.renderInfos.get(i);
            if (chunkRenderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !chunkRenderer.hasOverlay() || (compiledChunk = chunkRenderer.getChunkRenderData()).isOverlayTypeEmpty(type)) continue;
            this.renderContainer.addOverlayChunk(chunkRenderer);
        }
        this.world.method_16107().method_15405("render");
        this.renderBlockOverlayBuffers(type);
        this.world.method_16107().method_15407();
        this.world.method_16107().method_15407();
    }

    private void renderBlockOverlayBuffers(ChunkRendererSchematicVbo.OverlayRenderType type) {
        this.mc.field_1773.method_3180();
        if (GLX.useVbo()) {
            GlStateManager.enableClientState((int)32884);
            GlStateManager.enableClientState((int)32886);
        }
        this.renderContainer.renderBlockOverlays(type);
        if (GLX.useVbo()) {
            for (class_296 element : class_290.field_1576.method_1357()) {
                class_296.class_298 usage = element.method_1382();
                switch (usage) {
                    case field_1633: {
                        GlStateManager.disableClientState((int)32884);
                        break;
                    }
                    case field_1636: {
                        GLX.glClientActiveTexture((int)(GLX.GL_TEXTURE0 + element.method_1385()));
                        GlStateManager.disableClientState((int)32888);
                        GLX.glClientActiveTexture((int)GLX.GL_TEXTURE0);
                        break;
                    }
                    case field_1632: {
                        GlStateManager.disableClientState((int)32886);
                        GlStateManager.clearCurrentColor();
                    }
                }
            }
        }
        this.mc.field_1773.method_3187();
    }

    public boolean renderBlock(class_1920 world, class_2680 state, class_2338 pos, class_287 bufferBuilderIn) {
        try {
            class_2464 renderType = state.method_11610();
            if (renderType == class_2464.field_11455) {
                return false;
            }
            switch (renderType) {
                case field_11458: {
                    return this.blockModelRenderer.renderModel(world, this.getModelForState(state), state, pos, bufferBuilderIn, state.method_11617(pos));
                }
                case field_11456: {
                    return false;
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Tesselating block in world");
            class_129 crashreportcategory = crashreport.method_562("Block being tesselated");
            class_129.method_586((class_129)crashreportcategory, (class_2338)pos, (class_2680)state);
            throw new class_148(crashreport);
        }
    }

    public boolean renderFluid(class_1920 world, class_3610 state, class_2338 pos, class_287 bufferBuilderIn) {
        return this.blockRenderManager.method_3352(pos, world, bufferBuilderIn, state);
    }

    public class_1087 getModelForState(class_2680 state) {
        return this.blockRenderManager.method_3349(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderEntities(class_4184 camera, class_856 visibleRegion, float partialTicks) {
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
        } else {
            this.world.method_16107().method_15396("prepare");
            double cameraX = camera.method_19326().field_1352;
            double cameraY = camera.method_19326().field_1351;
            double cameraZ = camera.method_19326().field_1350;
            class_824.field_4346.method_3549((class_1937)this.world, this.mc.method_1531(), this.mc.field_1772, camera, this.mc.field_1765);
            this.entityRenderDispatcher.method_3941((class_1937)this.world, this.mc.field_1772, camera, this.mc.field_1692, this.mc.field_1690);
            this.countEntitiesTotal = 0;
            this.countEntitiesRendered = 0;
            this.countEntitiesHidden = 0;
            class_824.field_4343 = cameraX;
            class_824.field_4341 = cameraY;
            class_824.field_4340 = cameraZ;
            this.entityRenderDispatcher.method_3952(cameraX, cameraY, cameraZ);
            this.mc.field_1773.method_3180();
            this.countEntitiesTotal = this.world.method_18120();
            this.world.method_16107().method_15405("regular_entities");
            ArrayList entitiesMultipass = Lists.newArrayList();
            LayerRange layerRange = DataManager.getRenderLayerRange();
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                class_2338 pos = chunkRenderer.getPosition();
                class_2818 chunk = (class_2818)this.world.method_16955(pos);
                class_3509 list = chunk.method_12215()[pos.method_10264() >> 4];
                if (list.isEmpty()) continue;
                for (class_1297 entityTmp : list) {
                    boolean shouldRender;
                    if (!layerRange.isPositionWithinRange((int)entityTmp.field_5987, (int)entityTmp.field_6010, (int)entityTmp.field_6035) || !(shouldRender = this.entityRenderDispatcher.method_3950(entityTmp, visibleRegion, cameraX, cameraY, cameraZ))) continue;
                    ++this.countEntitiesRendered;
                    this.entityRenderDispatcher.method_3946(entityTmp, 0.0f, false);
                    if (!this.entityRenderDispatcher.method_3942(entityTmp)) continue;
                    entitiesMultipass.add(entityTmp);
                }
            }
            if (!entitiesMultipass.isEmpty()) {
                for (class_1297 entityTmp : entitiesMultipass) {
                    this.entityRenderDispatcher.method_3947(entityTmp, partialTicks);
                }
            }
            this.world.method_16107().method_15405("block_entities");
            RenderUtils.enableItemLighting();
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                ChunkRenderDataSchematic data = chunkRenderer.getChunkRenderData();
                List<class_2586> tiles = data.getBlockEntities();
                if (tiles.isEmpty()) continue;
                class_2338 pos = chunkRenderer.getPosition();
                ChunkSchematic chunk = this.world.getChunkProvider().getChunk(pos.method_10263() >> 4, pos.method_10260() >> 4);
                if (chunk == null || !(data instanceof ChunkRenderDataSchematic) || data.getTimeBuilt() < chunk.getTimeCreated()) continue;
                for (class_2586 te : tiles) {
                    try {
                        class_824.field_4346.method_3555(te, partialTicks, -1);
                    }
                    catch (Exception exception) {}
                }
            }
            Set<class_2586> set = this.blockEntities;
            synchronized (set) {
                for (class_2586 te : this.blockEntities) {
                    try {
                        class_824.field_4346.method_3555(te, partialTicks, -1);
                    }
                    catch (Exception exception) {}
                }
            }
            this.mc.field_1773.method_3187();
            this.world.method_16107().method_15407();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlockEntities(Collection<class_2586> toRemove, Collection<class_2586> toAdd) {
        Set<class_2586> set = this.blockEntities;
        synchronized (set) {
            this.blockEntities.removeAll(toRemove);
            this.blockEntities.addAll(toAdd);
        }
    }

    public void scheduleChunkRenders(int chunkX, int chunkY, int chunkZ) {
        this.chunkRendererDispatcher.scheduleChunkRender(chunkX, chunkY, chunkZ, false);
    }
}

