/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextFieldInteger;
import fi.dy.masa.malilib.gui.MaLiLibIcons;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.widgets.WidgetCheckBox;
import fi.dy.masa.malilib.util.LayerMode;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2350;

public abstract class GuiRenderLayerEditBase
extends GuiBase {
    protected GuiTextFieldGeneric textField1;
    protected GuiTextFieldGeneric textField2;
    protected int nextY;

    protected abstract LayerRange getLayerRange();

    protected IGuiIcon getValueAdjustButtonIcon() {
        return MaLiLibIcons.BTN_PLUSMINUS_16;
    }

    protected void createLayerEditControls(int x, int y, LayerRange layerRange) {
        x += this.createLayerConfigButton(x, y, ButtonListenerLayerEdit.Type.MODE, layerRange);
        this.createLayerConfigButton(x, y, ButtonListenerLayerEdit.Type.AXIS, layerRange);
        this.nextY = this.createTextFields(10, y += 26, 60, layerRange);
    }

    protected int createLayerConfigButton(int x, int y, ButtonListenerLayerEdit.Type type, LayerRange layerRange) {
        if (type == ButtonListenerLayerEdit.Type.MODE || layerRange.getLayerMode() != LayerMode.ALL) {
            ButtonListenerLayerEdit listener = new ButtonListenerLayerEdit(type, layerRange, this);
            ButtonGeneric button = new ButtonGeneric(x, y, -1, 20, type.getDisplayName(layerRange), new String[0]);
            this.addButton(button, listener);
            return button.getWidth() + 2;
        }
        return 0;
    }

    protected int createHotkeyCheckBoxes(int x, int y, LayerRange layerRange) {
        return y;
    }

    protected int createTextFields(int x, int y, int width, LayerRange layerRange) {
        LayerMode layerMode = layerRange.getLayerMode();
        if (layerMode == LayerMode.ALL) {
            return y;
        }
        if (layerMode == LayerMode.LAYER_RANGE) {
            String labelMin = StringUtils.translate("malilib.gui.label.render_layers.layer_min", new Object[0]) + ":";
            String labelMax = StringUtils.translate("malilib.gui.label.render_layers.layer_max", new Object[0]) + ":";
            int w1 = this.getStringWidth(labelMin);
            int w2 = this.getStringWidth(labelMax);
            this.addLabel(x, y, w1, 20, 0xFFFFFF, labelMax);
            this.addLabel(x, y + 23, w2, 20, 0xFFFFFF, labelMin);
            x += Math.max(w1, w2) + 10;
        } else {
            String label = StringUtils.translate("malilib.gui.label.render_layers.layer", new Object[0]) + ":";
            int w = this.getStringWidth(label);
            this.addLabel(x, y, w, 20, 0xFFFFFF, label);
            x += w + 10;
        }
        IGuiIcon valueAdjustIcon = this.getValueAdjustButtonIcon();
        if (layerMode == LayerMode.LAYER_RANGE) {
            this.textField2 = new GuiTextFieldInteger(x, y, width, 20, this.textRenderer);
            this.addTextField(this.textField2, new TextFieldListener(layerMode, layerRange, true));
            this.createHotkeyCheckBoxes(x + width + 24, y, layerRange);
            this.createValueAdjustButton(x + width + 3, y, true, layerRange, valueAdjustIcon);
            y += 23;
        } else {
            this.textField2 = null;
        }
        this.textField1 = new GuiTextFieldInteger(x, y, width, 20, this.textRenderer);
        this.addTextField(this.textField1, new TextFieldListener(layerMode, layerRange, false));
        this.createValueAdjustButton(x + width + 3, y, false, layerRange, valueAdjustIcon);
        this.updateTextFieldValues(layerRange);
        this.createLayerConfigButton(x - 1, y += 23, ButtonListenerLayerEdit.Type.SET_HERE, layerRange);
        return y + 22;
    }

    protected void updateTextFieldValues(LayerRange layerRange) {
        if (this.textField1 != null) {
            this.textField1.method_1852(String.valueOf(layerRange.getCurrentLayerValue(false)));
        }
        if (this.textField2 != null) {
            this.textField2.method_1852(String.valueOf(layerRange.getCurrentLayerValue(true)));
        }
    }

    protected void createValueAdjustButton(int x, int y, boolean isSecondValue, LayerRange layerRange, IGuiIcon icon) {
        LayerMode layerMode = layerRange.getLayerMode();
        ButtonListenerChangeValue listener = new ButtonListenerChangeValue(layerMode, layerRange, isSecondValue, this);
        ButtonGeneric button = new ButtonGeneric(x, y + 2, icon, new String[0]);
        this.addButton(button, listener);
    }

    public static class RangeHotkeyListener
    implements ISelectionListener<WidgetCheckBox> {
        protected final LayerRange layerRange;
        protected final boolean isMax;

        public RangeHotkeyListener(LayerRange layerRange, boolean isMax) {
            this.layerRange = layerRange;
            this.isMax = isMax;
        }

        @Override
        public void onSelectionChange(WidgetCheckBox entry) {
            if (this.isMax) {
                this.layerRange.toggleHotkeyMoveRangeMax();
            } else {
                this.layerRange.toggleHotkeyMoveRangeMin();
            }
        }
    }

    protected static class TextFieldListener
    implements ITextFieldListener<GuiTextFieldGeneric> {
        protected final LayerRange layerRange;
        protected final LayerMode mode;
        protected final boolean isSecondLimit;

        protected TextFieldListener(LayerMode mode, LayerRange layerRange, boolean isSecondLimit) {
            this.mode = mode;
            this.layerRange = layerRange;
            this.isSecondLimit = isSecondLimit;
        }

        @Override
        public boolean onTextChange(GuiTextFieldGeneric textField) {
            int value = 0;
            try {
                value = Integer.parseInt(textField.method_1882());
            }
            catch (NumberFormatException e) {
                return false;
            }
            switch (this.mode) {
                case ALL_ABOVE: {
                    this.layerRange.setLayerAbove(value);
                    break;
                }
                case ALL_BELOW: {
                    this.layerRange.setLayerBelow(value);
                    break;
                }
                case SINGLE_LAYER: {
                    this.layerRange.setLayerSingle(value);
                    break;
                }
                case LAYER_RANGE: {
                    if (this.isSecondLimit) {
                        this.layerRange.setLayerRangeMax(value);
                        break;
                    }
                    this.layerRange.setLayerRangeMin(value);
                    break;
                }
            }
            return true;
        }
    }

    protected static class ButtonListenerChangeValue
    implements IButtonActionListener {
        protected final GuiRenderLayerEditBase parent;
        protected final LayerRange layerRange;
        protected final LayerMode mode;
        protected final boolean isSecondLimit;

        protected ButtonListenerChangeValue(LayerMode mode, LayerRange layerRange, boolean isSecondLimit, GuiRenderLayerEditBase parent) {
            this.mode = mode;
            this.layerRange = layerRange;
            this.isSecondLimit = isSecondLimit;
            this.parent = parent;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            int change;
            int n = change = mouseButton == 1 ? -1 : 1;
            if (GuiBase.isShiftDown()) {
                change *= 16;
            }
            if (GuiBase.isCtrlDown()) {
                change *= 64;
            }
            if (this.mode == LayerMode.LAYER_RANGE) {
                if (this.isSecondLimit) {
                    this.layerRange.setLayerRangeMax(this.layerRange.getLayerRangeMax() + change);
                } else {
                    this.layerRange.setLayerRangeMin(this.layerRange.getLayerRangeMin() + change);
                }
            } else {
                this.layerRange.moveLayer(change);
            }
            this.parent.updateTextFieldValues(this.layerRange);
        }
    }

    protected static class ButtonListenerLayerEdit
    implements IButtonActionListener {
        protected final GuiRenderLayerEditBase parent;
        protected final LayerRange layerRange;
        protected final Type type;

        public ButtonListenerLayerEdit(Type type, LayerRange layerRange, GuiRenderLayerEditBase parent) {
            this.type = type;
            this.layerRange = layerRange;
            this.parent = parent;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == Type.MODE) {
                this.layerRange.setLayerMode((LayerMode)this.layerRange.getLayerMode().cycle(mouseButton == 0));
            } else if (this.type == Type.AXIS) {
                class_2350.class_2351 axis = this.layerRange.getAxis();
                int next = mouseButton == 0 ? (axis.ordinal() + 1) % 3 : (axis.ordinal() == 0 ? 2 : axis.ordinal() - 1);
                axis = class_2350.class_2351.values()[next % 3];
                this.layerRange.setAxis(axis);
            } else if (this.type == Type.SET_HERE) {
                this.layerRange.setToPosition((class_1297)this.parent.mc.field_1724);
            }
            this.parent.initGui();
        }

        public static enum Type {
            MODE("malilib.gui.button.render_layers_gui.layers"),
            AXIS("malilib.gui.button.render_layers_gui.axis"),
            SET_HERE("malilib.gui.button.render_layers_gui.set_here");

            private final String translationKey;

            private Type(String translationKey) {
                this.translationKey = translationKey;
            }

            public String getDisplayName(LayerRange layerRange) {
                if (this == SET_HERE) {
                    return StringUtils.translate(this.translationKey, new Object[0]);
                }
                String valueStr = this == MODE ? layerRange.getLayerMode().getDisplayName() : layerRange.getAxis().name();
                return StringUtils.translate(this.translationKey, valueStr);
            }
        }
    }
}

