/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.materials.MaterialListBase;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.materials.MaterialListSorter;
import fi.dy.masa.litematica.materials.MaterialListUtils;
import fi.dy.masa.litematica.render.infohud.IInfoHudRenderer;
import fi.dy.masa.litematica.render.infohud.RenderPhase;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_327;

public class MaterialListHudRenderer
implements IInfoHudRenderer {
    protected final MaterialListBase materialList;
    protected final MaterialListSorter sorter;
    protected boolean shouldRender;
    protected long lastUpdateTime;

    public MaterialListHudRenderer(MaterialListBase materialList) {
        this.materialList = materialList;
        this.sorter = new MaterialListSorter(materialList);
    }

    @Override
    public boolean getShouldRenderText(RenderPhase phase) {
        return false;
    }

    @Override
    public boolean getShouldRenderCustom() {
        return this.shouldRender;
    }

    @Override
    public boolean shouldRenderInGuis() {
        return Configs.Generic.RENDER_MATERIALS_IN_GUI.getBooleanValue();
    }

    public void toggleShouldRender() {
        this.shouldRender = !this.shouldRender;
    }

    @Override
    public List<String> getText(RenderPhase phase) {
        return Collections.emptyList();
    }

    @Override
    public int render(int xOffset, int yOffset, HudAlignment alignment) {
        int i;
        List<MaterialListEntry> list;
        class_310 mc = class_310.method_1551();
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime > 2000L) {
            MaterialListUtils.updateAvailableCounts(this.materialList.getMaterialsAll(), (class_1657)mc.field_1724);
            list = this.materialList.getMaterialsMissingOnly(true);
            Collections.sort(list, this.sorter);
            this.lastUpdateTime = currentTime;
        } else {
            list = this.materialList.getMaterialsMissingOnly(false);
        }
        if (list.size() == 0) {
            return 0;
        }
        class_327 font = mc.field_1772;
        double scale = Configs.InfoOverlays.MATERIAL_LIST_HUD_SCALE.getDoubleValue();
        int maxLines = Configs.InfoOverlays.MATERIAL_LIST_HUD_MAX_LINES.getIntegerValue();
        int bgMargin = 2;
        int lineHeight = 16;
        int contentHeight = Math.min(list.size(), maxLines) * lineHeight + bgMargin + 10;
        int maxTextLength = 0;
        int maxCountLength = 0;
        int posX = xOffset + bgMargin;
        int posY = yOffset + bgMargin;
        int bgColor = -1610612736;
        int textColor = -1;
        boolean useBackground = true;
        boolean useShadow = false;
        int size = Math.min(list.size(), maxLines);
        if (scale == 0.0) {
            return 0;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            MaterialListEntry entry = list.get(i2);
            maxTextLength = Math.max(maxTextLength, font.method_1727(entry.getStack().method_7964().getString()));
            int multiplier = this.materialList.getMultiplier();
            int count = multiplier == 1 ? entry.getCountMissing() - entry.getCountAvailable() : entry.getCountTotal();
            String strCount = GuiBase.TXT_RED + this.getFormattedCountString(count *= multiplier, entry.getStack().method_7914()) + GuiBase.TXT_RST;
            maxCountLength = Math.max(maxCountLength, font.method_1727(strCount));
        }
        int maxLineLength = maxTextLength + maxCountLength + 30;
        switch (alignment) {
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                posX = (int)((double)GuiUtils.getScaledWindowWidth() / scale - (double)maxLineLength - (double)xOffset - (double)bgMargin);
                break;
            }
            case CENTER: {
                posX = (int)((double)GuiUtils.getScaledWindowWidth() / scale / 2.0 - (double)(maxLineLength / 2) - (double)xOffset);
                break;
            }
        }
        if (scale != 1.0 && scale != 0.0) {
            yOffset = (int)((double)yOffset / scale);
        }
        posY = RenderUtils.getHudPosY((int)posY, (int)yOffset, (int)contentHeight, (double)scale, (HudAlignment)alignment);
        posY += RenderUtils.getHudOffsetForPotions((HudAlignment)alignment, (double)scale, (class_1657)mc.field_1724);
        if (scale != 1.0) {
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        }
        if (useBackground) {
            RenderUtils.drawRect((int)(posX - bgMargin), (int)(posY - bgMargin), (int)(maxLineLength + bgMargin * 2), (int)(contentHeight + bgMargin), (int)bgColor);
        }
        String title = GuiBase.TXT_BOLD + StringUtils.translate((String)"litematica.gui.button.material_list", (Object[])new Object[0]) + GuiBase.TXT_RST;
        if (useShadow) {
            font.method_1720(title, (float)(posX + 2), (float)(posY + 2), textColor);
        } else {
            font.method_1729(title, (float)(posX + 2), (float)(posY + 2), textColor);
        }
        int itemCountTextColor = Configs.Colors.MATERIAL_LIST_HUD_ITEM_COUNTS.getIntegerValue();
        int x = posX + 18;
        int y = (posY += 12) + 4;
        for (i = 0; i < size; ++i) {
            MaterialListEntry entry = list.get(i);
            String text = entry.getStack().method_7964().getString();
            int multiplier = this.materialList.getMultiplier();
            int count = multiplier == 1 ? entry.getCountMissing() - entry.getCountAvailable() : entry.getCountTotal();
            String strCount = this.getFormattedCountString(count *= multiplier, entry.getStack().method_7914());
            int cntLen = font.method_1727(strCount);
            int cntPosX = posX + maxLineLength - cntLen - 2;
            if (useShadow) {
                font.method_1720(text, (float)x, (float)y, textColor);
                font.method_1720(strCount, (float)cntPosX, (float)y, itemCountTextColor);
            } else {
                font.method_1729(text, (float)x, (float)y, textColor);
                font.method_1729(strCount, (float)cntPosX, (float)y, itemCountTextColor);
            }
            y += lineHeight;
        }
        x = posX;
        y = posY;
        RenderSystem.enableRescaleNormal();
        RenderUtils.setupBlend();
        RenderUtils.enableDiffuseLightingGui3D();
        for (i = 0; i < size; ++i) {
            mc.method_1480().method_4026((class_1309)mc.field_1724, list.get(i).getStack(), x, y);
            y += lineHeight;
        }
        RenderUtils.disableDiffuseLighting();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableBlend();
        if (scale != 1.0) {
            RenderSystem.popMatrix();
        }
        return contentHeight + 4;
    }

    protected String getFormattedCountString(int count, int maxStackSize) {
        int stacks = count / maxStackSize;
        int remainder = count % maxStackSize;
        double boxCount = (double)count / (27.0 * (double)maxStackSize);
        if (count > maxStackSize) {
            if (boxCount >= 1.0) {
                return String.format("%d (%.2f %s)", count, boxCount, StringUtils.translate((String)"litematica.gui.label.material_list.abbr.shulker_box", (Object[])new Object[0]));
            }
            if (remainder > 0) {
                return String.format("%d (%d x %d + %d)", count, stacks, maxStackSize, remainder);
            }
            return String.format("%d (%d x %d)", count, stacks, maxStackSize);
        }
        return String.format("%d", count);
    }
}

