/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.ItemType;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public class MaterialListUtils {
    public static List<MaterialListEntry> createMaterialListFor(LitematicaSchematic schematic) {
        return MaterialListUtils.createMaterialListFor(schematic, schematic.getAreas().keySet());
    }

    public static List<MaterialListEntry> createMaterialListFor(LitematicaSchematic schematic, Collection<String> subRegions) {
        Object2IntOpenHashMap countsTotal = new Object2IntOpenHashMap();
        for (String regionName : subRegions) {
            LitematicaBlockStateContainer container = schematic.getSubRegionContainer(regionName);
            if (container == null) continue;
            class_2382 size = container.getSize();
            int sizeX = size.method_10263();
            int sizeY = size.method_10264();
            int sizeZ = size.method_10260();
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int x = 0; x < sizeX; ++x) {
                        class_2680 state = container.get(x, y, z);
                        countsTotal.addTo((Object)state, 1);
                    }
                }
            }
        }
        class_310 mc = class_310.method_1551();
        return MaterialListUtils.getMaterialList((Object2IntOpenHashMap<class_2680>)countsTotal, (Object2IntOpenHashMap<class_2680>)countsTotal, (Object2IntOpenHashMap<class_2680>)new Object2IntOpenHashMap(), (class_1657)mc.field_1724);
    }

    public static List<MaterialListEntry> getMaterialList(Object2IntOpenHashMap<class_2680> countsTotal, Object2IntOpenHashMap<class_2680> countsMissing, Object2IntOpenHashMap<class_2680> countsMismatch, class_1657 player) {
        ArrayList<MaterialListEntry> list = new ArrayList<MaterialListEntry>();
        if (!countsTotal.isEmpty()) {
            MaterialCache cache = MaterialCache.getInstance();
            Object2IntOpenHashMap itemTypesTotal = new Object2IntOpenHashMap();
            Object2IntOpenHashMap itemTypesMissing = new Object2IntOpenHashMap();
            Object2IntOpenHashMap itemTypesMismatch = new Object2IntOpenHashMap();
            MaterialListUtils.convertStatesToStacks(countsTotal, (Object2IntOpenHashMap<ItemType>)itemTypesTotal, cache);
            MaterialListUtils.convertStatesToStacks(countsMissing, (Object2IntOpenHashMap<ItemType>)itemTypesMissing, cache);
            MaterialListUtils.convertStatesToStacks(countsMismatch, (Object2IntOpenHashMap<ItemType>)itemTypesMismatch, cache);
            Object2IntOpenHashMap playerInvItems = InventoryUtils.getInventoryItemCounts((class_1263)player.field_7514);
            for (ItemType type : itemTypesTotal.keySet()) {
                list.add(new MaterialListEntry(type.getStack().method_7972(), itemTypesTotal.getInt((Object)type), itemTypesMissing.getInt((Object)type), itemTypesMismatch.getInt((Object)type), playerInvItems.getInt((Object)type)));
            }
        }
        return list;
    }

    private static void convertStatesToStacks(Object2IntOpenHashMap<class_2680> blockStatesIn, Object2IntOpenHashMap<ItemType> itemTypesOut, MaterialCache cache) {
        for (class_2680 state : blockStatesIn.keySet()) {
            if (cache.requiresMultipleItems(state)) {
                for (class_1799 stack : cache.getItems(state)) {
                    ItemType type = new ItemType(stack, false, true);
                    itemTypesOut.addTo((Object)type, blockStatesIn.getInt((Object)state) * stack.method_7947());
                }
                continue;
            }
            class_1799 stack = cache.getRequiredBuildItemForState(state);
            if (stack.method_7960()) continue;
            ItemType type = new ItemType(stack, false, true);
            itemTypesOut.addTo((Object)type, blockStatesIn.getInt((Object)state) * stack.method_7947());
        }
    }

    public static void updateAvailableCounts(List<MaterialListEntry> list, class_1657 player) {
        Object2IntOpenHashMap playerInvItems = InventoryUtils.getInventoryItemCounts((class_1263)player.field_7514);
        for (MaterialListEntry entry : list) {
            ItemType type = new ItemType(entry.getStack(), false, true);
            int countAvailable = playerInvItems.getInt((Object)type);
            entry.setCountAvailable(countAvailable);
        }
    }
}

