/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.schematic.BlockModelRendererSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import fi.dy.masa.litematica.render.schematic.IChunkRendererFactory;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3509;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_898;

public class WorldRendererSchematic {
    private final class_310 mc;
    private final class_898 entityRenderDispatcher;
    private final class_776 blockRenderManager;
    private final BlockModelRendererSchematic blockModelRenderer;
    private final Set<class_2586> blockEntities = new HashSet<class_2586>();
    private final List<ChunkRendererSchematicVbo> renderInfos = new ArrayList<ChunkRendererSchematicVbo>(1024);
    private final class_293 vertexFormat = class_290.field_1590;
    private final class_4599 bufferBuilders;
    private Set<ChunkRendererSchematicVbo> chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
    private WorldSchematic world;
    private ChunkRenderDispatcherSchematic chunkRendererDispatcher;
    private double lastCameraChunkUpdateX = Double.MIN_VALUE;
    private double lastCameraChunkUpdateY = Double.MIN_VALUE;
    private double lastCameraChunkUpdateZ = Double.MIN_VALUE;
    private int cameraChunkX = Integer.MIN_VALUE;
    private int cameraChunkY = Integer.MIN_VALUE;
    private int cameraChunkZ = Integer.MIN_VALUE;
    private double lastCameraX = Double.MIN_VALUE;
    private double lastCameraY = Double.MIN_VALUE;
    private double lastCameraZ = Double.MIN_VALUE;
    private float lastCameraPitch = Float.MIN_VALUE;
    private float lastCameraYaw = Float.MIN_VALUE;
    private ChunkRenderDispatcherLitematica renderDispatcher;
    private final IChunkRendererFactory renderChunkFactory;
    private int renderDistanceChunks = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    private double lastTranslucentSortX;
    private double lastTranslucentSortY;
    private double lastTranslucentSortZ;
    private boolean displayListEntitiesDirty = true;

    public WorldRendererSchematic(class_310 mc) {
        this.mc = mc;
        this.entityRenderDispatcher = mc.method_1561();
        this.bufferBuilders = mc.method_22940();
        this.renderChunkFactory = ChunkRendererSchematicVbo::new;
        this.blockRenderManager = class_310.method_1551().method_1541();
        this.blockModelRenderer = new BlockModelRendererSchematic(mc.method_1505());
    }

    public void markNeedsUpdate() {
        this.displayListEntitiesDirty = true;
    }

    public String getDebugInfoRenders() {
        int rcTotal = this.chunkRendererDispatcher != null ? this.chunkRendererDispatcher.renderers.length : 0;
        int rcRendered = this.chunkRendererDispatcher != null ? this.getRenderedChunks() : 0;
        return String.format("C: %d/%d %sD: %d, L: %d, %s", rcRendered, rcTotal, this.mc.field_1730 ? "(s) " : "", this.renderDistanceChunks, 0, this.renderDispatcher == null ? "null" : this.renderDispatcher.getDebugInfo());
    }

    public String getDebugInfoEntities() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ", B: " + this.countEntitiesHidden;
    }

    protected int getRenderedChunks() {
        int count = 0;
        for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
            ChunkRenderDataSchematic data = chunkRenderer.chunkRenderData;
            if (data == ChunkRenderDataSchematic.EMPTY || data.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public void setWorldAndLoadRenderers(@Nullable WorldSchematic worldSchematic) {
        this.lastCameraChunkUpdateX = Double.MIN_VALUE;
        this.lastCameraChunkUpdateY = Double.MIN_VALUE;
        this.lastCameraChunkUpdateZ = Double.MIN_VALUE;
        this.cameraChunkX = Integer.MIN_VALUE;
        this.cameraChunkY = Integer.MIN_VALUE;
        this.cameraChunkZ = Integer.MIN_VALUE;
        this.world = worldSchematic;
        if (worldSchematic != null) {
            this.loadRenderers();
        } else {
            this.chunksToUpdate.clear();
            this.renderInfos.clear();
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
                this.chunkRendererDispatcher = null;
            }
            if (this.renderDispatcher != null) {
                this.renderDispatcher.stopWorkerThreads();
            }
            this.renderDispatcher = null;
            this.blockEntities.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRenderers() {
        if (this.world != null) {
            if (this.renderDispatcher == null) {
                this.renderDispatcher = new ChunkRenderDispatcherLitematica();
            }
            this.displayListEntitiesDirty = true;
            this.renderDistanceChunks = this.mc.field_1690.field_1870;
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
            }
            this.stopChunkUpdates();
            Set<class_2586> set = this.blockEntities;
            synchronized (set) {
                this.blockEntities.clear();
            }
            this.chunkRendererDispatcher = new ChunkRenderDispatcherSchematic(this.world, this.renderDistanceChunks, this, this.renderChunkFactory);
            class_1297 entity = this.mc.method_1560();
            if (entity != null) {
                this.chunkRendererDispatcher.updateCameraPosition(entity.method_23317(), entity.method_23321());
            }
            this.renderEntitiesStartupCounter = 2;
        }
    }

    protected void stopChunkUpdates() {
        this.chunksToUpdate.clear();
        this.renderDispatcher.stopChunkUpdates();
    }

    public void setupTerrain(class_4184 camera, class_4604 frustum, int frameCount, boolean playerSpectator) {
        Set<ChunkRendererSchematicVbo> set;
        class_1297 entity;
        this.world.method_16107().method_15396("setup_terrain");
        if (this.chunkRendererDispatcher == null || this.mc.field_1690.field_1870 != this.renderDistanceChunks) {
            this.loadRenderers();
        }
        if ((entity = this.mc.method_1560()) == null) {
            entity = this.mc.field_1724;
        }
        this.world.method_16107().method_15396("camera");
        double entityX = entity.method_23317();
        double entityY = entity.method_23318();
        double entityZ = entity.method_23321();
        double diffX = entityX - this.lastCameraChunkUpdateX;
        double diffY = entityY - this.lastCameraChunkUpdateY;
        double diffZ = entityZ - this.lastCameraChunkUpdateZ;
        if (this.cameraChunkX != entity.field_6024 || this.cameraChunkY != entity.field_5959 || this.cameraChunkZ != entity.field_5980 || diffX * diffX + diffY * diffY + diffZ * diffZ > 16.0) {
            this.lastCameraChunkUpdateX = entityX;
            this.lastCameraChunkUpdateY = entityY;
            this.lastCameraChunkUpdateZ = entityZ;
            this.cameraChunkX = entity.field_6024;
            this.cameraChunkY = entity.field_5959;
            this.cameraChunkZ = entity.field_5980;
            this.chunkRendererDispatcher.updateCameraPosition(entityX, entityZ);
        }
        this.world.method_16107().method_15405("renderlist_camera");
        class_243 cameraPos = camera.method_19326();
        double cameraX = cameraPos.field_1352;
        double cameraY = cameraPos.field_1351;
        double cameraZ = cameraPos.field_1350;
        this.renderDispatcher.setCameraPosition(cameraPos);
        this.world.method_16107().method_15405("culling");
        class_2338 viewPos = new class_2338(cameraX, cameraY + (double)entity.method_5751(), cameraZ);
        int centerChunkX = viewPos.method_10263() >> 4;
        int centerChunkZ = viewPos.method_10260() >> 4;
        int renderDistance = this.mc.field_1690.field_1870;
        SubChunkPos viewSubChunk = new SubChunkPos(centerChunkX, viewPos.method_10264() >> 4, centerChunkZ);
        class_2338 viewPosSubChunk = new class_2338(viewSubChunk.method_10263() << 4, viewSubChunk.method_10264() << 4, viewSubChunk.method_10260() << 4);
        this.displayListEntitiesDirty = this.displayListEntitiesDirty || !this.chunksToUpdate.isEmpty() || entityX != this.lastCameraX || entityY != this.lastCameraY || entityZ != this.lastCameraZ || entity.field_5965 != this.lastCameraPitch || entity.field_6031 != this.lastCameraYaw;
        this.lastCameraX = cameraX;
        this.lastCameraY = cameraY;
        this.lastCameraZ = cameraZ;
        this.lastCameraPitch = camera.method_19329();
        this.lastCameraYaw = camera.method_19330();
        this.world.method_16107().method_15405("update");
        if (this.displayListEntitiesDirty) {
            this.world.method_16107().method_15396("fetch");
            this.displayListEntitiesDirty = false;
            this.renderInfos.clear();
            class_1297.method_5840((double)class_3532.method_15350((double)((double)renderDistance / 8.0), (double)1.0, (double)2.5));
            set = DataManager.getSchematicPlacementManager().getAllTouchedSubChunks();
            ArrayList<ChunkRendererSchematicVbo> positions = new ArrayList<ChunkRendererSchematicVbo>(set.size());
            positions.addAll(set);
            Collections.sort(positions, new SubChunkPos.DistanceComparator(viewSubChunk));
            this.world.method_16107().method_15405("iteration");
            for (int i = 0; i < positions.size(); ++i) {
                class_2338 subChunkCornerPos;
                ChunkRendererSchematicVbo chunkRenderer;
                SubChunkPos subChunk = (SubChunkPos)positions.get(i);
                if (Math.abs(subChunk.method_10263() - centerChunkX) > renderDistance || Math.abs(subChunk.method_10260() - centerChunkZ) > renderDistance || !this.world.getChunkProvider().method_12123(subChunk.method_10263(), subChunk.method_10260()) || (chunkRenderer = this.chunkRendererDispatcher.getChunkRenderer(subChunkCornerPos = new class_2338(subChunk.method_10263() << 4, subChunk.method_10264() << 4, subChunk.method_10260() << 4))) == null || !frustum.method_23093(chunkRenderer.getBoundingBox())) continue;
                if (chunkRenderer.needsUpdate() && subChunkCornerPos.equals((Object)viewPosSubChunk)) {
                    chunkRenderer.setNeedsUpdate(true);
                }
                this.renderInfos.add(chunkRenderer);
            }
            this.world.method_16107().method_15407();
        }
        this.world.method_16107().method_15405("rebuild_near");
        set = this.chunksToUpdate;
        this.chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
        for (ChunkRendererSchematicVbo chunkRendererTmp : this.renderInfos) {
            boolean isNear;
            if (!chunkRendererTmp.needsUpdate() && !set.contains(chunkRendererTmp)) continue;
            this.displayListEntitiesDirty = true;
            class_2338 pos = chunkRendererTmp.getOrigin().method_10069(8, 8, 8);
            boolean bl = isNear = pos.method_10262((class_2382)viewPos) < 1024.0;
            if (!chunkRendererTmp.needsImmediateUpdate() && !isNear) {
                this.chunksToUpdate.add(chunkRendererTmp);
                continue;
            }
            this.world.method_16107().method_15396("build_near");
            this.renderDispatcher.updateChunkNow(chunkRendererTmp);
            chunkRendererTmp.clearNeedsUpdate();
            this.world.method_16107().method_15407();
        }
        this.chunksToUpdate.addAll(set);
        this.world.method_16107().method_15407();
        this.world.method_16107().method_15407();
    }

    public void updateChunks(long finishTimeNano) {
        this.displayListEntitiesDirty |= this.renderDispatcher.runChunkUploads(finishTimeNano);
        if (!this.chunksToUpdate.isEmpty()) {
            ChunkRendererSchematicVbo renderChunk;
            boolean flag;
            Iterator<ChunkRendererSchematicVbo> iterator = this.chunksToUpdate.iterator();
            while (iterator.hasNext() && (flag = (renderChunk = iterator.next()).needsImmediateUpdate() ? this.renderDispatcher.updateChunkNow(renderChunk) : this.renderDispatcher.updateChunkLater(renderChunk))) {
                renderChunk.clearNeedsUpdate();
                iterator.remove();
                long i = finishTimeNano - System.nanoTime();
                if (i >= 0L) continue;
                break;
            }
        }
    }

    public int renderBlockLayer(class_1921 renderLayer, class_4587 matrices, class_4184 camera) {
        this.world.method_16107().method_15396("render_block_layer_" + renderLayer.toString());
        boolean isTranslucent = renderLayer == class_1921.method_23583();
        renderLayer.method_23516();
        class_243 cameraPos = camera.method_19326();
        double x = cameraPos.field_1352;
        double y = cameraPos.field_1351;
        double z = cameraPos.field_1350;
        if (isTranslucent) {
            this.world.method_16107().method_15396("translucent_sort");
            double diffX = x - this.lastTranslucentSortX;
            double diffY = y - this.lastTranslucentSortY;
            double diffZ = z - this.lastTranslucentSortZ;
            if (diffX * diffX + diffY * diffY + diffZ * diffZ > 1.0) {
                this.lastTranslucentSortX = x;
                this.lastTranslucentSortY = y;
                this.lastTranslucentSortZ = z;
                int i = 0;
                for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                    if (!chunkRenderer.getChunkRenderData().isBlockLayerStarted(renderLayer) && (chunkRenderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !chunkRenderer.hasOverlay()) || i++ >= 15) continue;
                    this.renderDispatcher.updateTransparencyLater(chunkRenderer);
                }
            }
            this.world.method_16107().method_15407();
        }
        this.world.method_16107().method_15396("filter_empty");
        this.world.method_16107().method_15405("render");
        boolean reverse = isTranslucent;
        int startIndex = reverse ? this.renderInfos.size() - 1 : 0;
        int stopIndex = reverse ? -1 : this.renderInfos.size();
        int increment = reverse ? -1 : 1;
        int count = 0;
        for (int i = startIndex; i != stopIndex; i += increment) {
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            if (renderer.getChunkRenderData().isBlockLayerEmpty(renderLayer)) continue;
            class_2338 chunkOrigin = renderer.getOrigin();
            class_291 buffer = renderer.getBlocksVertexBufferByLayer(renderLayer);
            matrices.method_22903();
            matrices.method_22904((double)chunkOrigin.method_10263() - x, (double)chunkOrigin.method_10264() - y, (double)chunkOrigin.method_10260() - z);
            buffer.method_1353();
            this.vertexFormat.method_22649(0L);
            buffer.method_1351(matrices.method_23760().method_23761(), 7);
            matrices.method_22909();
            ++count;
        }
        class_291.method_1354();
        RenderSystem.clearCurrentColor();
        this.vertexFormat.method_22651();
        renderLayer.method_23518();
        this.world.method_16107().method_15407();
        this.world.method_16107().method_15407();
        return count;
    }

    public void renderBlockOverlays(class_4587 matrices, class_4184 camera) {
        this.renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType.OUTLINE, matrices, camera);
        this.renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType.QUAD, matrices, camera);
    }

    private void renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType type, class_4587 matrices, class_4184 camera) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_243 cameraPos = camera.method_19326();
        double x = cameraPos.field_1352;
        double y = cameraPos.field_1351;
        double z = cameraPos.field_1350;
        this.world.method_16107().method_15396("overlay_" + type.name());
        this.world.method_16107().method_15405("render");
        for (int i = this.renderInfos.size() - 1; i >= 0; --i) {
            ChunkRenderDataSchematic compiledChunk;
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            if (renderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !renderer.hasOverlay() || (compiledChunk = renderer.getChunkRenderData()).isOverlayTypeEmpty(type)) continue;
            class_2338 chunkOrigin = renderer.getOrigin();
            class_291 buffer = renderer.getOverlayVertexBuffer(type);
            matrices.method_22903();
            matrices.method_22904((double)chunkOrigin.method_10263() - x, (double)chunkOrigin.method_10264() - y, (double)chunkOrigin.method_10260() - z);
            buffer.method_1353();
            class_290.field_1576.method_22649(0L);
            buffer.method_1351(matrices.method_23760().method_23761(), type.getGlMode());
            matrices.method_22909();
        }
        class_291.method_1354();
        RenderSystem.clearCurrentColor();
        class_290.field_1576.method_22651();
        RenderSystem.disableBlend();
        this.world.method_16107().method_15407();
    }

    public boolean renderBlock(class_1920 world, class_2680 state, class_2338 pos, class_4587 matrices, class_287 bufferBuilderIn) {
        try {
            class_2464 renderType = state.method_11610();
            if (renderType == class_2464.field_11455) {
                return false;
            }
            switch (renderType) {
                case field_11458: {
                    return this.blockModelRenderer.renderModel(world, this.getModelForState(state), state, pos, matrices, (class_4588)bufferBuilderIn, state.method_11617(pos));
                }
                case field_11456: {
                    return false;
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Tesselating block in world");
            class_129 crashreportcategory = crashreport.method_562("Block being tesselated");
            class_129.method_586((class_129)crashreportcategory, (class_2338)pos, (class_2680)state);
            throw new class_148(crashreport);
        }
    }

    public boolean renderFluid(class_1920 world, class_3610 state, class_2338 pos, class_287 bufferBuilderIn) {
        return this.blockRenderManager.method_3352(pos, world, (class_4588)bufferBuilderIn, state);
    }

    public class_1087 getModelForState(class_2680 state) {
        if (state.method_11610() == class_2464.field_11456) {
            return this.blockRenderManager.method_3351().method_3333().method_4744();
        }
        return this.blockRenderManager.method_3349(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderEntities(class_4184 camera, class_4604 frustum, class_4587 matrices, float partialTicks) {
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
        } else {
            this.world.method_16107().method_15396("prepare");
            double cameraX = camera.method_19326().field_1352;
            double cameraY = camera.method_19326().field_1351;
            double cameraZ = camera.method_19326().field_1350;
            class_824.field_4346.method_3549((class_1937)this.world, this.mc.method_1531(), this.mc.field_1772, camera, this.mc.field_1765);
            this.entityRenderDispatcher.method_3941((class_1937)this.world, camera, this.mc.field_1692);
            this.countEntitiesTotal = 0;
            this.countEntitiesRendered = 0;
            this.countEntitiesHidden = 0;
            this.countEntitiesTotal = this.world.method_18120();
            this.world.method_16107().method_15405("regular_entities");
            class_4597.class_4598 entityVertexConsumers = this.bufferBuilders.method_23000();
            class_308.method_1452((class_1159)matrices.method_23760().method_23761());
            LayerRange layerRange = DataManager.getRenderLayerRange();
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                class_2338 pos = chunkRenderer.getOrigin();
                class_2818 chunk = this.world.method_8497(pos.method_10263() >> 4, pos.method_10260() >> 4);
                class_3509 list = chunk.method_12215()[pos.method_10264() >> 4];
                if (list.isEmpty()) continue;
                for (class_1297 entityTmp : list) {
                    boolean shouldRender;
                    if (!layerRange.isPositionWithinRange((int)entityTmp.method_23317(), (int)entityTmp.method_23318(), (int)entityTmp.method_23321()) || !(shouldRender = this.entityRenderDispatcher.method_3950(entityTmp, frustum, cameraX, cameraY, cameraZ))) continue;
                    double x = entityTmp.method_23317() - cameraX;
                    double y = entityTmp.method_23318() - cameraY;
                    double z = entityTmp.method_23321() - cameraZ;
                    this.entityRenderDispatcher.method_3954(entityTmp, x, y, z, entityTmp.field_6031, partialTicks, matrices, (class_4597)entityVertexConsumers, this.entityRenderDispatcher.method_23839(entityTmp, partialTicks));
                    ++this.countEntitiesRendered;
                }
            }
            this.world.method_16107().method_15405("block_entities");
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                ChunkRenderDataSchematic data = chunkRenderer.getChunkRenderData();
                List<class_2586> tiles = data.getBlockEntities();
                if (tiles.isEmpty()) continue;
                class_2338 chunkOrigin = chunkRenderer.getOrigin();
                ChunkSchematic chunk = this.world.getChunkProvider().getChunk(chunkOrigin.method_10263() >> 4, chunkOrigin.method_10260() >> 4);
                if (chunk == null || !(data instanceof ChunkRenderDataSchematic) || data.getTimeBuilt() < chunk.getTimeCreated()) continue;
                for (class_2586 te : tiles) {
                    try {
                        class_2338 pos = te.method_11016();
                        matrices.method_22903();
                        matrices.method_22904((double)pos.method_10263() - cameraX, (double)pos.method_10264() - cameraY, (double)pos.method_10260() - cameraZ);
                        class_824.field_4346.method_3555(te, partialTicks, matrices, (class_4597)entityVertexConsumers);
                        matrices.method_22909();
                    }
                    catch (Exception exception) {}
                }
            }
            Set<class_2586> set = this.blockEntities;
            synchronized (set) {
                for (class_2586 te : this.blockEntities) {
                    try {
                        class_2338 pos = te.method_11016();
                        matrices.method_22903();
                        matrices.method_22904((double)pos.method_10263() - cameraX, (double)pos.method_10264() - cameraY, (double)pos.method_10260() - cameraZ);
                        class_824.field_4346.method_3555(te, partialTicks, matrices, (class_4597)entityVertexConsumers);
                        matrices.method_22909();
                    }
                    catch (Exception exception) {}
                }
            }
            this.world.method_16107().method_15407();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlockEntities(Collection<class_2586> toRemove, Collection<class_2586> toAdd) {
        Set<class_2586> set = this.blockEntities;
        synchronized (set) {
            this.blockEntities.removeAll(toRemove);
            this.blockEntities.addAll(toAdd);
        }
    }

    public void scheduleChunkRenders(int chunkX, int chunkY, int chunkZ) {
        this.chunkRendererDispatcher.scheduleChunkRender(chunkX, chunkY, chunkZ, false);
    }
}

