/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.ChunkProviderSchematic;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1940;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_631;
import net.minecraft.class_634;
import net.minecraft.class_638;

public class WorldSchematic
extends class_638 {
    private final class_310 mc = class_310.method_1551();
    private final WorldRendererSchematic worldRenderer = LitematicaRenderer.getInstance().getWorldRenderer();
    private ChunkProviderSchematic chunkProviderSchematic = new ChunkProviderSchematic(this);
    private int nextEntityId;

    public WorldSchematic(class_634 netHandler, class_1940 settings, class_2874 dimType, class_3695 profilerIn) {
        super(netHandler, settings, dimType, 1, profilerIn, null);
    }

    public ChunkProviderSchematic getChunkProvider() {
        return this.chunkProviderSchematic;
    }

    public class_631 method_2935() {
        return this.getChunkProvider();
    }

    public class_2818 method_8500(class_2338 pos) {
        return this.method_8497(pos.method_10263() >> 4, pos.method_10260() >> 4);
    }

    public class_2818 method_8497(int chunkX, int chunkZ) {
        return this.chunkProviderSchematic.getChunk(chunkX, chunkZ);
    }

    public class_2791 method_8402(int chunkX, int chunkZ, class_2806 status, boolean required) {
        return this.method_8497(chunkX, chunkZ);
    }

    public boolean method_8652(class_2338 pos, class_2680 newState, int flags) {
        if (pos.method_10264() < 0 || pos.method_10264() >= 256) {
            return false;
        }
        return this.method_8497(pos.method_10263() >> 4, pos.method_10260() >> 4).method_12010(pos, newState, false) != null;
    }

    public boolean method_8649(class_1297 entityIn) {
        return this.spawnEntityBase(entityIn);
    }

    private boolean spawnEntityBase(class_1297 entityIn) {
        int cz;
        int cx = class_3532.method_15357((double)(entityIn.method_23317() / 16.0));
        if (!this.chunkProviderSchematic.method_12123(cx, cz = class_3532.method_15357((double)(entityIn.method_23321() / 16.0)))) {
            return false;
        }
        entityIn.method_5838(this.nextEntityId++);
        super.method_2942(entityIn.method_5628(), entityIn);
        return true;
    }

    public void unloadBlockEntities(Collection<class_2586> blockEntities) {
        Set remove = Collections.newSetFromMap(new IdentityHashMap());
        remove.addAll(blockEntities);
        this.field_9246.removeAll(remove);
        this.field_9231.removeAll(remove);
    }

    public long method_8510() {
        return this.mc.field_1687 != null ? this.mc.field_1687.method_8510() : 0L;
    }

    public void method_16109(class_2338 pos, class_2680 stateOld, class_2680 stateNew) {
        this.method_18113(pos.method_10263() >> 4, pos.method_10264() >> 4, pos.method_10260() >> 4);
    }

    public void method_18113(int chunkX, int chunkY, int chunkZ) {
        if (chunkY >= 0 && chunkY < 16) {
            this.worldRenderer.scheduleChunkRenders(chunkX, chunkY, chunkZ);
        }
    }

    public void scheduleChunkRenders(int chunkX, int chunkZ) {
        for (int chunkY = 0; chunkY < 16; ++chunkY) {
            this.worldRenderer.scheduleChunkRenders(chunkX, chunkY, chunkZ);
        }
    }

    public void scheduleChunkRenders(int minBlockX, int minBlockY, int minBlockZ, int maxBlockX, int maxBlockY, int maxBlockZ) {
        int minChunkX = Math.min(minBlockX, maxBlockX) >> 4;
        int minChunkY = class_3532.method_15340((int)(Math.min(minBlockY, maxBlockY) >> 4), (int)0, (int)15);
        int minChunkZ = Math.min(minBlockZ, maxBlockZ) >> 4;
        int maxChunkX = Math.max(minBlockX, maxBlockX) >> 4;
        int maxChunkY = class_3532.method_15340((int)(Math.max(minBlockY, maxBlockY) >> 4), (int)0, (int)15);
        int maxChunkZ = Math.max(minBlockZ, maxBlockZ) >> 4;
        for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
            for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
                for (int cy = minChunkY; cy <= maxChunkY; ++cy) {
                    this.worldRenderer.scheduleChunkRenders(cx, cy, cz);
                }
            }
        }
    }

    public int method_8314(class_1944 type, class_2338 pos) {
        return 15;
    }

    public int method_22335(class_2338 pos, int defaultValue) {
        return 15;
    }

    public void method_8413(class_2338 blockPos_1, class_2680 blockState_1, class_2680 blockState_2, int int_1) {
    }

    public void method_8474(int int_1, class_2338 blockPos_1, int int_2) {
    }

    public void method_8444(@Nullable class_1657 playerEntity_1, int int_1, class_2338 blockPos_1, int int_2) {
    }

    public void method_8406(class_2394 particleParameters_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void method_8466(class_2394 particleParameters_1, boolean boolean_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void method_8494(class_2394 particleParameters_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void method_17452(class_2394 particleParameters_1, boolean boolean_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void method_2947(class_2338 pos, class_3414 soundIn, class_3419 category, float volume, float pitch, boolean distanceDelay) {
    }

    public void method_8486(double x, double y, double z, class_3414 soundIn, class_3419 category, float volume, float pitch, boolean distanceDelay) {
    }

    public void method_8396(class_1657 player, class_2338 pos, class_3414 soundIn, class_3419 category, float volume, float pitch) {
    }

    public void method_8465(class_1657 player, double x, double y, double z, class_3414 soundIn, class_3419 category, float volume, float pitch) {
    }
}

