/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.blocks;

import com.tomboshoven.minecraft.magicmirror.ModMagicMirror;
import com.tomboshoven.minecraft.magicmirror.blocks.modifiers.MagicMirrorModifier;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.TileEntityMagicMirrorBase;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.TileEntityMagicMirrorCore;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.TileEntityMagicMirrorPart;
import com.tomboshoven.minecraft.magicmirror.packets.Network;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockMagicMirror
extends BlockHorizontal {
    public static final PropertyBool COMPLETE = PropertyBool.func_177716_a((String)"complete");
    public static final PropertyEnum<EnumPartType> PART = PropertyEnum.func_177709_a((String)"part", EnumPartType.class);
    private static final AxisAlignedBB[] BOUNDING_BOX = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125), new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0)};
    @SidedProxy(clientSide="com.tomboshoven.minecraft.magicmirror.blocks.BlockMagicMirror$MessageHandlerAttachModifierClient", serverSide="com.tomboshoven.minecraft.magicmirror.blocks.BlockMagicMirror$MessageHandlerAttachModifierServer")
    public static IMessageHandler<MessageAttachModifier, IMessage> messageHandlerAttachModifier;

    BlockMagicMirror() {
        super(new Material(MapColor.field_151670_w));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)COMPLETE, (Comparable)Boolean.FALSE).func_177226_a(PART, (Comparable)((Object)EnumPartType.BOTTOM)));
        this.func_149711_c(0.8f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    private static void attachModifier(World worldIn, BlockPos pos, ItemStack heldItem, MagicMirrorModifier modifier) {
        modifier.apply((IBlockAccess)worldIn, pos, heldItem);
        if (worldIn.field_72995_K) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187719_p, SoundCategory.BLOCKS, 0.6f, 0.6f, true);
        } else {
            MessageAttachModifier mirrorMessage = new MessageAttachModifier(pos, heldItem, modifier);
            Network.sendToAllTracking(mirrorMessage, worldIn, pos);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        IBlockState blockBelow = worldIn.func_180495_p(pos.func_177977_b());
        IBlockState blockAbove = worldIn.func_180495_p(pos.func_177984_a());
        if (blockBelow.func_177230_c() == this && !((Boolean)blockBelow.func_177229_b((IProperty)COMPLETE)).booleanValue() && blockBelow.func_177229_b((IProperty)field_185512_D) == state.func_177229_b((IProperty)field_185512_D)) {
            worldIn.func_175656_a(pos.func_177977_b(), blockBelow.func_177226_a((IProperty)COMPLETE, (Comparable)Boolean.valueOf(true)).func_177226_a(PART, (Comparable)((Object)EnumPartType.BOTTOM)));
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)COMPLETE, (Comparable)Boolean.valueOf(true)).func_177226_a(PART, (Comparable)((Object)EnumPartType.TOP)));
        } else if (blockAbove.func_177230_c() == this && !((Boolean)blockAbove.func_177229_b((IProperty)COMPLETE)).booleanValue() && blockAbove.func_177229_b((IProperty)field_185512_D) == state.func_177229_b((IProperty)field_185512_D)) {
            worldIn.func_175656_a(pos.func_177984_a(), blockAbove.func_177226_a((IProperty)COMPLETE, (Comparable)Boolean.valueOf(true)).func_177226_a(PART, (Comparable)((Object)EnumPartType.TOP)));
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)COMPLETE, (Comparable)Boolean.valueOf(true)).func_177226_a(PART, (Comparable)((Object)EnumPartType.BOTTOM)));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (((Boolean)state.func_177229_b((IProperty)COMPLETE)).booleanValue() && (state.func_177229_b(PART) == EnumPartType.TOP && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != this || state.func_177229_b(PART) == EnumPartType.BOTTOM && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this)) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)COMPLETE, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, COMPLETE, PART});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b() | ((Boolean)state.func_177229_b((IProperty)COMPLETE) != false ? 1 : 0) << 2 | ((EnumPartType)((Object)state.func_177229_b(PART))).getValue() << 3;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)COMPLETE, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a(PART, (Comparable)((Object)((meta & 8) == 0 ? EnumPartType.BOTTOM : EnumPartType.TOP)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d() == face ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX[((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b()];
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)COMPLETE);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        if (state.func_177229_b(PART) == EnumPartType.BOTTOM) {
            return new TileEntityMagicMirrorCore();
        }
        return new TileEntityMagicMirrorPart();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177229_b((IProperty)field_185512_D) == facing) {
            if (!worldIn.field_72995_K) {
                TileEntity tileEntity;
                ItemStack heldItem = playerIn.func_184586_b(hand);
                if (!heldItem.func_190926_b()) {
                    for (MagicMirrorModifier modifier : MagicMirrorModifier.getModifiers()) {
                        if (!modifier.canModify(worldIn, pos, heldItem)) continue;
                        BlockMagicMirror.attachModifier(worldIn, pos, heldItem, modifier);
                        return true;
                    }
                }
                if ((tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityMagicMirrorBase && ((TileEntityMagicMirrorBase)tileEntity).tryActivate(playerIn, hand)) {
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileEntity;
        if (((Boolean)state.func_177229_b((IProperty)COMPLETE)).booleanValue() && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityMagicMirrorBase) {
            ((TileEntityMagicMirrorBase)tileEntity).removeModifiers(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.SERVER)
    public static class MessageHandlerAttachModifierServer
    implements IMessageHandler<MessageAttachModifier, IMessage> {
        @Nullable
        public IMessage onMessage(MessageAttachModifier message, MessageContext ctx) {
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class MessageHandlerAttachModifierClient
    implements IMessageHandler<MessageAttachModifier, IMessage> {
        @Nullable
        public IMessage onMessage(MessageAttachModifier message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            TileEntity te = world.func_175625_s(message.mirrorPos);
            if (te instanceof TileEntityMagicMirrorBase) {
                MagicMirrorModifier modifier = MagicMirrorModifier.getModifier(message.modifierName);
                if (modifier == null) {
                    ModMagicMirror.logger.error("Received a request to add modifier \"{}\" which does not exist.", (Object)message.modifierName);
                    return null;
                }
                BlockMagicMirror.attachModifier((World)world, message.mirrorPos, message.usedItemStack, modifier);
            }
            return null;
        }
    }

    public static class MessageAttachModifier
    implements IMessage {
        BlockPos mirrorPos;
        ItemStack usedItemStack;
        String modifierName;

        public MessageAttachModifier() {
        }

        MessageAttachModifier(BlockPos mirrorPos, ItemStack usedItemStack, MagicMirrorModifier modifier) {
            this.mirrorPos = mirrorPos;
            this.usedItemStack = usedItemStack;
            this.modifierName = modifier.getName();
        }

        public void fromBytes(ByteBuf buf) {
            this.mirrorPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.usedItemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.modifierName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.mirrorPos.func_177958_n());
            buf.writeInt(this.mirrorPos.func_177956_o());
            buf.writeInt(this.mirrorPos.func_177952_p());
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.usedItemStack);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modifierName);
        }
    }

    public static enum EnumPartType implements IStringSerializable
    {
        TOP("top", 0),
        BOTTOM("bottom", 1);

        private final String name;
        private final int value;

        private EnumPartType(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String func_176610_l() {
            return this.name;
        }

        int getValue() {
            return this.value;
        }
    }
}

