/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.blocks.tileentities;

import com.tomboshoven.minecraft.magicmirror.blocks.BlockMagicMirror;
import com.tomboshoven.minecraft.magicmirror.blocks.Blocks;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.TileEntityMagicMirrorCore;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers.MagicMirrorTileEntityModifier;
import com.tomboshoven.minecraft.magicmirror.reflection.Reflection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class TileEntityMagicMirrorBase
extends TileEntity {
    private EnumFacing facing = EnumFacing.NORTH;
    private BlockMagicMirror.EnumPartType part = BlockMagicMirror.EnumPartType.TOP;
    private boolean complete;

    public void onLoad() {
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() == Blocks.blockMagicMirror) {
            this.facing = (EnumFacing)blockState.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            this.part = (BlockMagicMirror.EnumPartType)((Object)blockState.func_177229_b(BlockMagicMirror.PART));
            this.complete = (Boolean)blockState.func_177229_b((IProperty)BlockMagicMirror.COMPLETE);
        }
    }

    @Nullable
    protected abstract TileEntityMagicMirrorCore getCore();

    @Nullable
    public Reflection getReflection() {
        TileEntityMagicMirrorCore core = this.getCore();
        if (core != null) {
            return core.getReflection();
        }
        return null;
    }

    public List<MagicMirrorTileEntityModifier> getModifiers() {
        TileEntityMagicMirrorCore core = this.getCore();
        if (core != null) {
            return core.getModifiers();
        }
        return Collections.emptyList();
    }

    public void addModifier(MagicMirrorTileEntityModifier modifier) {
        TileEntityMagicMirrorCore core = this.getCore();
        if (core != null) {
            core.addModifier(modifier);
        }
    }

    public void removeModifiers(World worldIn, BlockPos pos) {
        TileEntityMagicMirrorCore core = this.getCore();
        if (core != null) {
            core.removeModifiers(worldIn, pos);
        }
    }

    public boolean tryActivate(EntityPlayer playerIn, EnumHand hand) {
        TileEntityMagicMirrorCore core = this.getCore();
        if (core != null) {
            return core.tryActivate(playerIn, hand);
        }
        return false;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public BlockMagicMirror.EnumPartType getPart() {
        return this.part;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

