/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.blocks.tileentities;

import com.google.common.collect.Lists;
import com.tomboshoven.minecraft.magicmirror.blocks.modifiers.MagicMirrorModifier;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.TileEntityMagicMirrorBase;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers.MagicMirrorTileEntityModifier;
import com.tomboshoven.minecraft.magicmirror.reflection.Reflection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TileEntityMagicMirrorCore
extends TileEntityMagicMirrorBase
implements ITickable {
    private static final int REFLECTION_UPDATE_INTERVAL = 10;
    @SidedProxy(clientSide="com.tomboshoven.minecraft.magicmirror.reflection.ReflectionClient$ReflectionFactory", serverSide="com.tomboshoven.minecraft.magicmirror.reflection.Reflection$ReflectionFactory")
    private static Reflection.ReflectionFactory reflectionFactory;
    private final List<MagicMirrorTileEntityModifier> modifiers = Lists.newArrayList();
    private Reflection reflection;
    private int reflectionUpdateCounter = 10;

    private static List<EntityPlayer> findReflectablePlayers(World world, BlockPos ownPosition) {
        AxisAlignedBB scanBB = new AxisAlignedBB(ownPosition.func_177982_a(-10, -4, -10), ownPosition.func_177982_a(10, 4, 10));
        List playerEntities = world.func_72872_a(EntityPlayer.class, scanBB);
        return playerEntities.stream().filter(player -> !(player instanceof FakePlayer)).collect(Collectors.toList());
    }

    @Nullable
    private static EntityPlayer findPlayerToReflect(World world, BlockPos ownPosition) {
        List<EntityPlayer> players = TileEntityMagicMirrorCore.findReflectablePlayers(world, ownPosition);
        if (players.isEmpty()) {
            return null;
        }
        return Collections.min(players, Comparator.comparingDouble(player -> player.func_180425_c().func_177951_i((Vec3i)ownPosition)));
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.reflection = this.func_145831_w().field_72995_K ? reflectionFactory.createClient() : reflectionFactory.createServer();
        this.reflection.setFacing(this.getFacing().func_185119_l());
    }

    @Override
    @Nullable
    protected TileEntityMagicMirrorCore getCore() {
        return this;
    }

    private void updateReflection() {
        World world = this.func_145831_w();
        EntityPlayer playerToReflect = TileEntityMagicMirrorCore.findPlayerToReflect(world, this.func_174877_v());
        if (playerToReflect == null) {
            this.reflection.stopReflecting();
        } else {
            this.reflection.setReflectedEntity((Entity)playerToReflect);
        }
    }

    public void func_73660_a() {
        if (this.reflectionUpdateCounter++ == 10) {
            this.reflectionUpdateCounter = 0;
            this.updateReflection();
        }
        this.reflection.forceRerender();
        this.modifiers.forEach(MagicMirrorTileEntityModifier::coolDown);
    }

    public void onChunkUnload() {
        this.reflection.stopReflecting();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.reflection.stopReflecting();
        this.reflectionUpdateCounter = 10;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return this.writeInternal(super.func_189515_b(compound));
    }

    private NBTTagCompound writeInternal(NBTTagCompound compound) {
        NBTTagList modifierList = new NBTTagList();
        for (MagicMirrorTileEntityModifier modifier : this.modifiers) {
            NBTTagCompound modifierCompound = new NBTTagCompound();
            modifierCompound.func_74778_a("name", modifier.getName());
            modifierList.func_74742_a((NBTBase)modifier.writeToNBT(modifierCompound));
        }
        compound.func_74782_a("modifiers", (NBTBase)modifierList);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList modifiers = compound.func_150295_c("modifiers", 10);
        for (NBTBase modifierCompound : modifiers) {
            String name;
            MagicMirrorModifier modifier;
            if (!(modifierCompound instanceof NBTTagCompound) || (modifier = MagicMirrorModifier.getModifier(name = ((NBTTagCompound)modifierCompound).func_74779_i("name"))) == null) continue;
            modifier.apply((TileEntityMagicMirrorBase)this, (NBTTagCompound)modifierCompound);
        }
    }

    @Override
    @Nullable
    public Reflection getReflection() {
        return this.reflection;
    }

    @Override
    public List<MagicMirrorTileEntityModifier> getModifiers() {
        return Collections.unmodifiableList(this.modifiers);
    }

    @Override
    public boolean tryActivate(EntityPlayer playerIn, EnumHand hand) {
        return this.modifiers.stream().anyMatch(modifier -> modifier.tryPlayerActivate(this, playerIn, hand));
    }

    @Override
    public void addModifier(MagicMirrorTileEntityModifier modifier) {
        this.modifiers.add(modifier);
        modifier.activate(this);
        this.func_70296_d();
    }

    @Override
    public void removeModifiers(World worldIn, BlockPos pos) {
        for (MagicMirrorTileEntityModifier modifier : this.modifiers) {
            modifier.deactivate(this);
            modifier.remove(worldIn, pos);
        }
        this.modifiers.clear();
    }

    public NBTTagCompound func_189517_E_() {
        return this.writeInternal(super.func_189517_E_());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

