/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers;

import com.tomboshoven.minecraft.magicmirror.ModMagicMirror;
import com.tomboshoven.minecraft.magicmirror.blocks.modifiers.MagicMirrorModifier;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.TileEntityMagicMirrorBase;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers.MagicMirrorTileEntityModifier;
import com.tomboshoven.minecraft.magicmirror.packets.Network;
import com.tomboshoven.minecraft.magicmirror.reflection.Reflection;
import com.tomboshoven.minecraft.magicmirror.reflection.modifiers.ReflectionModifierArmor;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MagicMirrorTileEntityModifierArmor
extends MagicMirrorTileEntityModifier {
    private static final int COOLDOWN_TICKS = 20;
    private static final int SWAP_PARTICLE_COUNT = 64;
    @SidedProxy(clientSide="com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers.MagicMirrorTileEntityModifierArmor$MessageHandlerSwapMirrorClient", serverSide="com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers.MagicMirrorTileEntityModifierArmor$MessageHandlerSwapMirrorServer")
    public static IMessageHandler<MessageSwapMirror, IMessage> messageHandlerSwapMirror;
    @SidedProxy(clientSide="com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers.MagicMirrorTileEntityModifierArmor$MessageHandlerSwapPlayerClient", serverSide="com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers.MagicMirrorTileEntityModifierArmor$MessageHandlerSwapPlayerServer")
    public static IMessageHandler<MessageSwapPlayer, IMessage> messageHandlerSwapPlayer;
    @SidedProxy(serverSide="com.tomboshoven.minecraft.magicmirror.reflection.modifiers.ReflectionModifierArmor$Factory", clientSide="com.tomboshoven.minecraft.magicmirror.reflection.modifiers.ReflectionModifierArmorClient$Factory")
    private static ReflectionModifierArmor.Factory reflectionModifierFactory;
    private final ReplacementArmor replacementArmor = new ReplacementArmor();
    @Nullable
    private ReflectionModifierArmor reflectionModifier;

    public MagicMirrorTileEntityModifierArmor(MagicMirrorModifier modifier) {
        super(modifier);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return this.replacementArmor.writeToNBT(super.writeToNBT(nbt));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.replacementArmor.readFromNBT(nbt);
    }

    @Override
    public void remove(World world, BlockPos pos) {
        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack((Item)Items.field_179565_cj));
        this.replacementArmor.spawn(world, pos);
    }

    @Override
    public void activate(TileEntityMagicMirrorBase tileEntity) {
        Reflection reflection = tileEntity.getReflection();
        if (reflection != null) {
            this.reflectionModifier = tileEntity.func_145831_w().field_72995_K ? reflectionModifierFactory.createClient(this.replacementArmor) : reflectionModifierFactory.createServer(this.replacementArmor);
            reflection.addModifier(this.reflectionModifier);
        }
    }

    @Override
    public void deactivate(TileEntityMagicMirrorBase tileEntity) {
        Reflection reflection;
        if (this.reflectionModifier != null && (reflection = tileEntity.getReflection()) != null) {
            reflection.removeModifier(this.reflectionModifier);
        }
    }

    @Override
    public boolean tryPlayerActivate(TileEntityMagicMirrorBase tileEntity, EntityPlayer playerIn, EnumHand hand) {
        if (this.coolingDown()) {
            return false;
        }
        if (!(playerIn instanceof EntityPlayerMP)) {
            return false;
        }
        BlockPos pos = tileEntity.func_174877_v();
        MessageSwapMirror mirrorMessage = new MessageSwapMirror(tileEntity, playerIn);
        Network.sendToAllTracking(mirrorMessage, tileEntity.func_145831_w(), pos);
        MessageSwapPlayer playerMessage = new MessageSwapPlayer(this, playerIn);
        Network.sendTo(playerMessage, (EntityPlayerMP)playerIn);
        Network.sendToAllTracking(playerMessage, playerIn);
        this.replacementArmor.swap(playerIn);
        ModMagicMirror.logger.debug("Swapped inventory of mirror");
        this.setCooldown(20);
        tileEntity.func_70296_d();
        return true;
    }

    private ReplacementArmor getReplacementArmor() {
        return this.replacementArmor;
    }

    @SideOnly(value=Side.SERVER)
    public static class MessageHandlerSwapPlayerServer
    implements IMessageHandler<MessageSwapPlayer, IMessage> {
        @Nullable
        public IMessage onMessage(MessageSwapPlayer message, MessageContext ctx) {
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class MessageHandlerSwapPlayerClient
    implements IMessageHandler<MessageSwapPlayer, IMessage> {
        @Nullable
        public IMessage onMessage(MessageSwapPlayer message, MessageContext ctx) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (entity instanceof EntityPlayer) {
                message.armor.swap((EntityPlayer)entity);
                entity.func_184185_a(SoundEvents.field_187534_aX, 0.8f, 0.4f);
                Random random = new Random();
                for (int i = 0; i < 64; ++i) {
                    entity.func_130014_f_().func_175688_a(EnumParticleTypes.PORTAL, entity.field_70165_t + random.nextGaussian() / 4.0, entity.field_70163_u + 2.0 * random.nextDouble(), entity.field_70161_v + random.nextGaussian() / 4.0, random.nextGaussian() / 2.0, random.nextDouble(), random.nextGaussian() / 2.0, new int[0]);
                }
            }
            return null;
        }
    }

    @SideOnly(value=Side.SERVER)
    public static class MessageHandlerSwapMirrorServer
    implements IMessageHandler<MessageSwapMirror, IMessage> {
        @Nullable
        public IMessage onMessage(MessageSwapMirror message, MessageContext ctx) {
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class MessageHandlerSwapMirrorClient
    implements IMessageHandler<MessageSwapMirror, IMessage> {
        @Nullable
        public IMessage onMessage(MessageSwapMirror message, MessageContext ctx) {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.mirrorPos);
            if (te instanceof TileEntityMagicMirrorBase) {
                ((TileEntityMagicMirrorBase)te).getModifiers().stream().filter(modifier -> modifier instanceof MagicMirrorTileEntityModifierArmor).findFirst().ifPresent(modifier -> message.armor.swap((MagicMirrorTileEntityModifierArmor)modifier));
            }
            return null;
        }
    }

    public static class MessageSwapPlayer
    extends MessageSwap {
        int entityId;

        public MessageSwapPlayer() {
        }

        MessageSwapPlayer(MagicMirrorTileEntityModifierArmor armorModifier, EntityPlayer player) {
            super((Iterable<ItemStack>)armorModifier.getReplacementArmor().replacementInventory);
            this.entityId = player.func_145782_y();
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            super.fromBytes(buf);
            this.entityId = buf.readInt();
        }

        @Override
        public void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            buf.writeInt(this.entityId);
        }
    }

    public static class MessageSwapMirror
    extends MessageSwap {
        BlockPos mirrorPos;

        public MessageSwapMirror() {
        }

        MessageSwapMirror(TileEntityMagicMirrorBase magicMirrorBase, EntityPlayer player) {
            super(player.func_184193_aE());
            this.mirrorPos = magicMirrorBase.func_174877_v();
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            super.fromBytes(buf);
            this.mirrorPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        }

        @Override
        public void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            buf.writeInt(this.mirrorPos.func_177958_n());
            buf.writeInt(this.mirrorPos.func_177956_o());
            buf.writeInt(this.mirrorPos.func_177952_p());
        }
    }

    static class MessageSwap
    implements IMessage {
        final ReplacementArmor armor;

        MessageSwap() {
            this.armor = new ReplacementArmor();
        }

        MessageSwap(Iterable<ItemStack> armor) {
            this.armor = new ReplacementArmor(armor);
        }

        public void fromBytes(ByteBuf buf) {
            for (int i = 0; i < 4; ++i) {
                this.armor.set(i, ByteBufUtils.readItemStack((ByteBuf)buf));
            }
        }

        public void toBytes(ByteBuf buf) {
            for (ItemStack stack : this.armor.replacementInventory) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
            }
        }
    }

    public static class ReplacementArmor {
        private final NonNullList<ItemStack> replacementInventory;

        ReplacementArmor() {
            this.replacementInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        }

        ReplacementArmor(Iterable<ItemStack> armor) {
            this.replacementInventory = NonNullList.func_191196_a();
            armor.forEach(arg_0 -> this.replacementInventory.add(arg_0));
        }

        void set(int i, ItemStack stack) {
            this.replacementInventory.set(i, (Object)stack);
        }

        public void swap(NonNullList<ItemStack> inventory) {
            if (inventory != null) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack replacement = (ItemStack)this.replacementInventory.get(i);
                    this.replacementInventory.set(i, inventory.get(i));
                    inventory.set(i, (Object)replacement);
                }
            }
        }

        void swap(EntityPlayer player) {
            for (int i = 0; i < 4; ++i) {
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-2, i + 36, (ItemStack)this.replacementInventory.get(i)));
                }
                ItemStack replacement = (ItemStack)this.replacementInventory.get(i);
                this.replacementInventory.set(i, player.field_71071_by.field_70460_b.get(i));
                player.field_71071_by.field_70460_b.set(i, (Object)replacement);
            }
        }

        NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            ItemStackHelper.func_191281_a((NBTTagCompound)nbt, this.replacementInventory, (boolean)true);
            return nbt;
        }

        void readFromNBT(NBTTagCompound nbt) {
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.replacementInventory);
        }

        void spawn(World world, BlockPos pos) {
            for (ItemStack itemStack : this.replacementInventory) {
                if (itemStack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack);
                itemStack.func_190920_e(0);
            }
        }

        void swap(MagicMirrorTileEntityModifierArmor modifier) {
            ModMagicMirror.logger.info("Swapping with mirror");
            this.swap(((MagicMirrorTileEntityModifierArmor)modifier).getReplacementArmor().replacementInventory);
        }
    }
}

