/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.reflection;

import com.google.common.collect.Lists;
import com.tomboshoven.minecraft.magicmirror.ModMagicMirror;
import com.tomboshoven.minecraft.magicmirror.reflection.modifiers.ReflectionModifier;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.Entity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Reflection {
    static int activeReflectionsClient = 0;
    final List<ReflectionModifier> modifiers = Lists.newArrayList();
    @Nullable
    private Entity reflectedEntity;

    public static int getActiveReflectionsClient() {
        return activeReflectionsClient;
    }

    public void stopReflecting() {
        if (this.reflectedEntity != null) {
            ModMagicMirror.logger.debug("No longer reflecting {}", (Object)this.reflectedEntity.func_70005_c_());
            this.cleanUpFrameBuffer();
            this.cleanUpRenderer();
            this.reflectedEntity = null;
            this.decrementActiveReflections();
        }
    }

    void incrementActiveClientReflections() {
    }

    void decrementActiveReflections() {
    }

    void buildFrameBuffer() {
    }

    void cleanUpFrameBuffer() {
    }

    void rebuildRenderer() {
    }

    void cleanUpRenderer() {
    }

    @Nullable
    public Entity getReflectedEntity() {
        return this.reflectedEntity;
    }

    public void setReflectedEntity(Entity reflectedEntity) {
        if (this.reflectedEntity != reflectedEntity) {
            ModMagicMirror.logger.debug("Reflecting {}", (Object)reflectedEntity.func_70005_c_());
            if (this.reflectedEntity == null) {
                this.buildFrameBuffer();
                this.incrementActiveClientReflections();
            }
            this.reflectedEntity = reflectedEntity;
            this.rebuildRenderer();
        }
    }

    public void addModifier(ReflectionModifier modifier) {
        this.modifiers.add(modifier);
        this.rebuildRenderer();
    }

    public void removeModifier(ReflectionModifier modifier) {
        this.modifiers.remove(modifier);
        this.rebuildRenderer();
    }

    public void setFacing(float facing) {
    }

    public void render(float partialTicks) {
    }

    public void forceRerender() {
    }

    public void bind() {
    }

    public static class ReflectionFactory {
        public Reflection createServer() {
            return new Reflection();
        }

        public Reflection createClient() {
            return new Reflection();
        }
    }
}

