/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.reflection;

import com.tomboshoven.minecraft.magicmirror.reflection.Reflection;
import com.tomboshoven.minecraft.magicmirror.reflection.modifiers.ReflectionModifier;
import com.tomboshoven.minecraft.magicmirror.reflection.renderers.ReflectionRenderer;
import com.tomboshoven.minecraft.magicmirror.reflection.renderers.ReflectionRendererBase;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class ReflectionClient
extends Reflection {
    @Nullable
    private ReflectionRendererBase reflectionRenderer;
    private float facing;
    @Nullable
    private Framebuffer frameBuffer;
    private float lastRenderPartialTicks = -1.0f;

    @Override
    void incrementActiveClientReflections() {
        ++activeReflectionsClient;
    }

    @Override
    void decrementActiveReflections() {
        --activeReflectionsClient;
    }

    @Override
    void buildFrameBuffer() {
        super.buildFrameBuffer();
        this.frameBuffer = new Framebuffer(64, 128, true);
        this.frameBuffer.func_147609_e();
    }

    @Override
    void cleanUpFrameBuffer() {
        super.cleanUpFrameBuffer();
        if (this.frameBuffer != null) {
            this.frameBuffer.func_147608_a();
            this.frameBuffer = null;
        }
    }

    @Override
    void rebuildRenderer() {
        super.rebuildRenderer();
        Entity reflectedEntity = this.getReflectedEntity();
        if (reflectedEntity != null) {
            this.reflectionRenderer = new ReflectionRenderer(reflectedEntity);
            for (ReflectionModifier modifier : this.modifiers) {
                this.reflectionRenderer = modifier.apply(this.reflectionRenderer);
            }
        }
    }

    @Override
    void cleanUpRenderer() {
        this.reflectionRenderer = null;
    }

    @Override
    public void setFacing(float facing) {
        this.facing = facing;
    }

    @Override
    public void render(float partialTicks) {
        super.render(partialTicks);
        if (this.lastRenderPartialTicks >= partialTicks) {
            return;
        }
        this.lastRenderPartialTicks = partialTicks;
        if (this.frameBuffer != null && this.reflectionRenderer != null) {
            this.frameBuffer.func_147614_f();
            this.frameBuffer.func_147610_a(true);
            this.reflectionRenderer.render(this.facing, partialTicks);
            this.frameBuffer.func_147609_e();
        }
    }

    @Override
    public void forceRerender() {
        super.forceRerender();
        this.lastRenderPartialTicks = -1.0f;
    }

    @Override
    public void bind() {
        super.bind();
        if (this.frameBuffer == null) {
            throw new RuntimeException("No active reflection");
        }
        this.frameBuffer.func_147612_c();
    }

    @SideOnly(value=Side.CLIENT)
    public static class ReflectionFactory
    extends Reflection.ReflectionFactory {
        @Override
        public Reflection createClient() {
            return new ReflectionClient();
        }
    }
}

