/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.reflection.renderers.modifiers;

import com.tomboshoven.minecraft.magicmirror.reflection.renderers.ReflectionRendererBase;
import com.tomboshoven.minecraft.magicmirror.reflection.renderers.modifiers.ReflectionRendererModifier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ReflectionRendererModifierCreature
extends ReflectionRendererModifier {
    private final Render<? extends Entity> replacementRenderer = new RenderOffModelPlayer(Minecraft.func_71410_x().func_175598_ae(), new ModelSkeletonPlayer(), new ResourceLocation("textures/entity/skeleton/skeleton.png"));

    public ReflectionRendererModifierCreature(ReflectionRendererBase baseRenderer) {
        super(baseRenderer);
    }

    @Override
    public void render(float facing, float partialTicks) {
        Render originalRenderer = this.getRenderer();
        this.setRenderer((Render)this.replacementRenderer);
        super.render(facing, partialTicks);
        this.setRenderer(originalRenderer);
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class ModelSkeletonPlayer
    extends ModelBiped {
        ModelSkeletonPlayer() {
            super(0.0f, 0.0f, 64, 32);
            this.field_178723_h = new ModelRenderer((ModelBase)this, 40, 16);
            this.field_178723_h.func_78790_a(-1.0f, -2.0f, -1.0f, 2, 12, 2, 0.0f);
            this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.field_178724_i = new ModelRenderer((ModelBase)this, 40, 16);
            this.field_178724_i.field_78809_i = true;
            this.field_178724_i.func_78790_a(-1.0f, -2.0f, -1.0f, 2, 12, 2, 0.0f);
            this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
            this.field_178721_j = new ModelRenderer((ModelBase)this, 0, 16);
            this.field_178721_j.func_78790_a(-1.0f, 0.0f, -1.0f, 2, 12, 2, 0.0f);
            this.field_178721_j.func_78793_a(-2.0f, 12.0f, 0.0f);
            this.field_178722_k = new ModelRenderer((ModelBase)this, 0, 16);
            this.field_178722_k.field_78809_i = true;
            this.field_178722_k.func_78790_a(-1.0f, 0.0f, -1.0f, 2, 12, 2, 0.0f);
            this.field_178722_k.func_78793_a(2.0f, 12.0f, 0.0f);
        }
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class RenderOffModelPlayer
    extends RenderLivingBase<AbstractClientPlayer> {
        private final ResourceLocation textureLocation;

        RenderOffModelPlayer(RenderManager renderManager, ModelBiped model, ResourceLocation textureLocation) {
            super(renderManager, (ModelBase)model, 0.0f);
            this.func_177094_a((LayerRenderer)new LayerCustomHead(model.field_78116_c));
            this.func_177094_a((LayerRenderer)new LayerElytra((RenderLivingBase)this));
            this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
            this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
            this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
            this.textureLocation = textureLocation;
        }

        public void doRender(AbstractClientPlayer entity, double x, double y, double z, float entityYaw, float partialTicks) {
            this.setArmPoses(entity);
            super.func_76986_a((EntityLivingBase)entity, x, y, z, entityYaw, partialTicks);
        }

        private void setArmPoses(AbstractClientPlayer entity) {
            ModelBiped model = (ModelBiped)this.func_177087_b();
            model.field_78117_n = entity.func_70093_af();
            ItemStack[] handItems = new ItemStack[]{entity.func_184614_ca(), entity.func_184592_cb()};
            ModelBiped.ArmPose[] armPoses = new ModelBiped.ArmPose[]{ModelBiped.ArmPose.EMPTY, ModelBiped.ArmPose.EMPTY};
            for (int side = 0; side < 2; ++side) {
                if (handItems[side].func_190926_b()) continue;
                armPoses[side] = ModelBiped.ArmPose.ITEM;
                if (entity.func_184605_cv() <= 0) continue;
                EnumAction itemUseAction = handItems[side].func_77975_n();
                if (itemUseAction == EnumAction.BLOCK) {
                    armPoses[side] = ModelBiped.ArmPose.BLOCK;
                    continue;
                }
                if (itemUseAction != EnumAction.BOW) continue;
                armPoses[side] = ModelBiped.ArmPose.BOW_AND_ARROW;
            }
            if (entity.func_184591_cq() == EnumHandSide.RIGHT) {
                model.field_187076_m = armPoses[0];
                model.field_187075_l = armPoses[1];
            } else {
                model.field_187076_m = armPoses[1];
                model.field_187075_l = armPoses[0];
            }
        }

        @Nullable
        protected ResourceLocation getEntityTexture(AbstractClientPlayer entity) {
            return this.textureLocation;
        }
    }
}

