/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.renderers;

import com.tomboshoven.minecraft.magicmirror.blocks.BlockMagicMirror;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.TileEntityMagicMirrorBase;
import com.tomboshoven.minecraft.magicmirror.reflection.Reflection;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
class TileEntityMagicMirrorRenderer
extends TileEntitySpecialRenderer<TileEntityMagicMirrorBase> {
    private static final double MAX_DISTANCE = 8.0;

    TileEntityMagicMirrorRenderer() {
    }

    public void render(TileEntityMagicMirrorBase te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Entity reflected;
        Reflection reflection;
        super.func_192841_a((TileEntity)te, x, y, z, partialTicks, destroyStage, alpha);
        if (te.isComplete() && (reflection = te.getReflection()) != null && (reflected = reflection.getReflectedEntity()) != null) {
            BlockMagicMirror.EnumPartType part = te.getPart();
            EnumFacing facing = te.getFacing();
            Vec3d reflectedPos = reflected.func_174791_d();
            double distanceSq = te.func_174877_v().func_177954_c(reflectedPos.field_72450_a, reflectedPos.field_72448_b, reflectedPos.field_72449_c);
            TileEntityMagicMirrorRenderer.renderReflection(reflection, x, y, z, partialTicks, alpha, part, facing, distanceSq);
        }
    }

    private static void renderReflection(Reflection reflection, double x, double y, double z, float partialTicks, float alpha, BlockMagicMirror.EnumPartType part, EnumFacing facing, double distanceSq) {
        reflection.render(partialTicks);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        float reflectionAlpha = Math.min(1.0f, 1.2f - (float)(distanceSq / 64.0));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * reflectionAlpha));
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)facing.func_185119_l(), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.4);
        GlStateManager.func_179140_f();
        reflection.bind();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double texTop = part == BlockMagicMirror.EnumPartType.TOP ? 0.0 : 0.5;
        double texBottom = part == BlockMagicMirror.EnumPartType.TOP ? 0.5 : 1.0;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, texBottom).func_181675_d();
        bufferbuilder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, texBottom).func_181675_d();
        bufferbuilder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, texTop).func_181675_d();
        bufferbuilder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, texTop).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }
}

