/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.blocks;

import com.tomboshoven.minecraft.magicmirror.MagicMirrorMod;
import com.tomboshoven.minecraft.magicmirror.blocks.modifiers.MagicMirrorModifier;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.MagicMirrorBaseTileEntity;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.MagicMirrorCoreTileEntity;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.MagicMirrorPartTileEntity;
import com.tomboshoven.minecraft.magicmirror.packets.Network;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MagicMirrorBlock
extends HorizontalBlock {
    private static final BooleanProperty COMPLETE = BooleanProperty.func_177716_a((String)"complete");
    public static final EnumProperty<EnumPartType> PART = EnumProperty.func_177709_a((String)"part", EnumPartType.class);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{MagicMirrorBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), MagicMirrorBlock.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), MagicMirrorBlock.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), MagicMirrorBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)};

    MagicMirrorBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)COMPLETE, (Comparable)Boolean.FALSE)).func_206870_a(PART, (Comparable)((Object)EnumPartType.BOTTOM)));
    }

    private static void attachModifier(World worldIn, BlockPos pos, ItemStack heldItem, MagicMirrorModifier modifier) {
        ItemStack originalHeldItem = heldItem.func_77946_l();
        modifier.apply((IBlockReader)worldIn, pos, heldItem);
        MessageAttachModifier message = new MessageAttachModifier(pos, originalHeldItem, modifier);
        PacketDistributor.PacketTarget target = PacketDistributor.TRACKING_CHUNK.with(() -> worldIn.func_175726_f(pos));
        Network.CHANNEL.send(target, (Object)message);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        BlockState blockBelow = worldIn.func_180495_p(pos.func_177977_b());
        BlockState blockAbove = worldIn.func_180495_p(pos.func_177984_a());
        if (blockBelow.func_177230_c() == this && !((Boolean)blockBelow.func_177229_b((IProperty)COMPLETE)).booleanValue() && blockBelow.func_177229_b((IProperty)field_185512_D) == state.func_177229_b((IProperty)field_185512_D)) {
            worldIn.func_175656_a(pos.func_177977_b(), (BlockState)((BlockState)blockBelow.func_206870_a((IProperty)COMPLETE, (Comparable)Boolean.valueOf(true))).func_206870_a(PART, (Comparable)((Object)EnumPartType.BOTTOM)));
            worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((IProperty)COMPLETE, (Comparable)Boolean.valueOf(true))).func_206870_a(PART, (Comparable)((Object)EnumPartType.TOP)));
        } else if (blockAbove.func_177230_c() == this && !((Boolean)blockAbove.func_177229_b((IProperty)COMPLETE)).booleanValue() && blockAbove.func_177229_b((IProperty)field_185512_D) == state.func_177229_b((IProperty)field_185512_D)) {
            worldIn.func_175656_a(pos.func_177984_a(), (BlockState)((BlockState)blockAbove.func_206870_a((IProperty)COMPLETE, (Comparable)Boolean.valueOf(true))).func_206870_a(PART, (Comparable)((Object)EnumPartType.TOP)));
            worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((IProperty)COMPLETE, (Comparable)Boolean.valueOf(true))).func_206870_a(PART, (Comparable)((Object)EnumPartType.BOTTOM)));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, COMPLETE, PART});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176736_b()];
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)COMPLETE);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (state.func_177229_b(PART) == EnumPartType.BOTTOM) {
            return new MagicMirrorCoreTileEntity();
        }
        return new MagicMirrorPartTileEntity();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)field_185512_D)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction horizontalDirection = Direction.NORTH;
        for (Direction direction : context.func_196009_e()) {
            if (!direction.func_176740_k().func_176722_c()) continue;
            horizontalDirection = direction;
            break;
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)horizontalDirection.func_176734_d());
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (state.func_177229_b((IProperty)field_185512_D) == hit.func_216354_b()) {
            if (!worldIn.field_72995_K) {
                TileEntity tileEntity;
                ItemStack heldItem = player.func_184586_b(handIn);
                if (!heldItem.func_190926_b()) {
                    for (MagicMirrorModifier modifier : MagicMirrorModifier.getModifiers()) {
                        if (!modifier.canModify(worldIn, pos, heldItem)) continue;
                        MagicMirrorBlock.attachModifier(worldIn, pos, heldItem, modifier);
                        return true;
                    }
                }
                if ((tileEntity = worldIn.func_175625_s(pos)) instanceof MagicMirrorBaseTileEntity && ((MagicMirrorBaseTileEntity)tileEntity).tryActivate(player, handIn)) {
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (((Boolean)state.func_177229_b((IProperty)COMPLETE)).booleanValue()) {
            BlockPos otherPos;
            BlockState otherState;
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof MagicMirrorBaseTileEntity) {
                ((MagicMirrorBaseTileEntity)tileEntity).removeModifiers(worldIn, pos);
            }
            if ((otherState = worldIn.func_180495_p(otherPos = state.func_177229_b(PART) == EnumPartType.TOP ? pos.func_177977_b() : pos.func_177984_a())).func_177230_c() == this) {
                worldIn.func_175656_a(otherPos, (BlockState)otherState.func_206870_a((IProperty)COMPLETE, (Comparable)Boolean.valueOf(false)));
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public static void onMessageAttachModifier(MessageAttachModifier message, Supplier<? extends NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            TileEntity te = world.func_175625_s(message.mirrorPos);
            if (te instanceof MagicMirrorBaseTileEntity) {
                MagicMirrorModifier modifier = MagicMirrorModifier.getModifier(message.modifierName);
                if (modifier == null) {
                    MagicMirrorMod.LOGGER.error("Received a request to add modifier \"{}\" which does not exist.", (Object)message.modifierName);
                    return;
                }
                modifier.apply((IBlockReader)world, message.mirrorPos, message.usedItemStack);
                world.func_184156_a(message.mirrorPos, SoundEvents.field_187719_p, SoundCategory.BLOCKS, 0.6f, 0.6f, true);
            }
        }));
        ctx.setPacketHandled(true);
    }

    public static class MessageAttachModifier {
        BlockPos mirrorPos;
        ItemStack usedItemStack;
        String modifierName;

        public MessageAttachModifier() {
        }

        MessageAttachModifier(BlockPos mirrorPos, ItemStack usedItemStack, MagicMirrorModifier modifier) {
            this.mirrorPos = mirrorPos;
            this.usedItemStack = usedItemStack;
            this.modifierName = modifier.getName();
        }

        public static MessageAttachModifier decode(PacketBuffer buf) {
            MessageAttachModifier result = new MessageAttachModifier();
            result.mirrorPos = buf.func_179259_c();
            result.usedItemStack = buf.func_150791_c();
            result.modifierName = buf.func_218666_n();
            return result;
        }

        public void encode(PacketBuffer buf) {
            buf.func_179255_a(this.mirrorPos);
            buf.func_150788_a(this.usedItemStack);
            buf.func_180714_a(this.modifierName);
        }
    }

    public static enum EnumPartType implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

