/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.tomboshoven.minecraft.magicmirror.blocks.Blocks;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.ValidationResults;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
class LootTables
extends LootTableProvider {
    LootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new BlockTables(), (Object)LootParameterSets.field_216267_h));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationResults validationresults) {
        map.forEach((name, table) -> LootTableManager.func_215302_a((ValidationResults)validationresults, (ResourceLocation)name, (LootTable)table, map::get));
    }

    @Nonnull
    public String func_200397_b() {
        return String.format("%s %s", "magic_mirror", super.func_200397_b());
    }

    private static class BlockTables
    extends BlockLootTables {
        private BlockTables() {
        }

        protected void addTables() {
            this.func_218492_c(Blocks.MAGIC_MIRROR);
        }

        protected Iterable<Block> getKnownBlocks() {
            return Stream.of(Blocks.MAGIC_MIRROR)::iterator;
        }
    }
}

