/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.reflection;

import com.tomboshoven.minecraft.magicmirror.reflection.Reflection;
import com.tomboshoven.minecraft.magicmirror.reflection.modifiers.ReflectionModifier;
import com.tomboshoven.minecraft.magicmirror.reflection.renderers.ReflectionRenderer;
import com.tomboshoven.minecraft.magicmirror.reflection.renderers.ReflectionRendererBase;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class ReflectionClient
extends Reflection {
    private static final int TEXTURE_WIDTH = 64;
    private static final int TEXTURE_HEIGHT = 128;
    @Nullable
    private ReflectionRendererBase reflectionRenderer;
    @Nullable
    private Framebuffer frameBuffer;
    private float lastRenderPartialTicks = -1.0f;

    @Override
    void incrementActiveClientReflections() {
        ++activeReflectionsClient;
    }

    @Override
    void decrementActiveReflections() {
        --activeReflectionsClient;
    }

    @Override
    void buildFrameBuffer() {
        super.buildFrameBuffer();
        this.frameBuffer = new Framebuffer(64, 128, true, Minecraft.field_142025_a);
        this.frameBuffer.func_147609_e();
    }

    @Override
    void cleanUpFrameBuffer() {
        super.cleanUpFrameBuffer();
        if (this.frameBuffer != null) {
            this.frameBuffer.func_147608_a();
            this.frameBuffer = null;
        }
    }

    @Override
    void rebuildRenderer() {
        super.rebuildRenderer();
        Entity reflectedEntity = this.getReflectedEntity();
        if (reflectedEntity != null) {
            this.reflectionRenderer = new ReflectionRenderer(reflectedEntity);
            for (ReflectionModifier modifier : this.modifiers) {
                this.reflectionRenderer = modifier.apply(this.reflectionRenderer);
            }
        }
    }

    @Override
    void cleanUpRenderer() {
        this.reflectionRenderer = null;
    }

    @Override
    public void render(Direction facing, float partialTicks) {
        super.render(facing, partialTicks);
        if (this.reflectedEntity != null && this.frameBuffer == null) {
            this.buildFrameBuffer();
        } else if (this.reflectedEntity == null && this.frameBuffer != null) {
            this.cleanUpFrameBuffer();
        }
        if (this.lastRenderPartialTicks >= partialTicks) {
            return;
        }
        this.lastRenderPartialTicks = partialTicks;
        if (this.frameBuffer != null && this.reflectionRenderer != null) {
            this.frameBuffer.func_216493_b(Minecraft.field_142025_a);
            this.frameBuffer.func_147610_a(true);
            this.reflectionRenderer.setUp();
            this.reflectionRenderer.render(facing.func_185119_l(), partialTicks);
            this.reflectionRenderer.tearDown();
            this.frameBuffer.func_147609_e();
        }
    }

    @Override
    public void forceRerender() {
        super.forceRerender();
        this.lastRenderPartialTicks = -1.0f;
    }

    @Override
    public void bind() {
        super.bind();
        if (this.frameBuffer == null) {
            throw new RuntimeException("No active reflection");
        }
        this.frameBuffer.func_147612_c();
    }
}

