/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.reflection.renderers.modifiers;

import com.google.common.collect.ImmutableList;
import com.tomboshoven.minecraft.magicmirror.reflection.renderers.ReflectionRendererBase;
import com.tomboshoven.minecraft.magicmirror.reflection.renderers.modifiers.ReflectionRendererModifier;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BannerTextures;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BannerReflectionRendererModifier
extends ReflectionRendererModifier {
    private static final double BACKGROUND_DISTANCE = 16.0;
    private static final double BANNER_TEXTURE_START_U = 0.0;
    private static final double BANNER_TEXTURE_END_U = 0.34375;
    private static final double BANNER_TEXTURE_START_V = 0.0;
    private static final double BANNER_TEXTURE_END_V = 0.640625;
    private final ImmutableList<BannerPattern> patternList;
    private final ImmutableList<DyeColor> colorList;
    private final String bannerPatternString;

    public BannerReflectionRendererModifier(ReflectionRendererBase baseRenderer, Collection<Pair<BannerPattern, DyeColor>> patternColorList) {
        super(baseRenderer);
        this.patternList = patternColorList.stream().map(Pair::getLeft).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        this.colorList = patternColorList.stream().map(Pair::getRight).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        this.bannerPatternString = BannerReflectionRendererModifier.generateBannerPatternString(patternColorList);
    }

    private static String generateBannerPatternString(Collection<? extends Pair<BannerPattern, DyeColor>> patternColorList) {
        return patternColorList.stream().flatMap(patternItem -> Stream.of(((BannerPattern)patternItem.getLeft()).func_190993_b(), Integer.toString(((DyeColor)patternItem.getRight()).func_196059_a()))).collect(Collectors.joining());
    }

    @Nullable
    private ResourceLocation getBannerResourceLocation() {
        return BannerTextures.field_178466_c.func_187478_a(this.bannerPatternString, this.patternList, this.colorList);
    }

    @Override
    public void render(float facing, float partialTicks) {
        super.render(facing, partialTicks);
        ResourceLocation bannerLocation = this.getBannerResourceLocation();
        if (bannerLocation != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(bannerLocation);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(-8.0, 16.0, 16.0).func_187315_a(0.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(8.0, 16.0, 16.0).func_187315_a(0.34375, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(8.0, -16.0, 16.0).func_187315_a(0.34375, 0.640625).func_181675_d();
            bufferbuilder.func_181662_b(-8.0, -16.0, 16.0).func_187315_a(0.0, 0.640625).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

