/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.reflection.renderers.modifiers;

import com.tomboshoven.minecraft.magicmirror.reflection.renderers.ReflectionRendererBase;
import com.tomboshoven.minecraft.magicmirror.reflection.renderers.modifiers.ReflectionRendererModifier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CreatureReflectionRendererModifier
extends ReflectionRendererModifier {
    private final EntityRenderer<? extends Entity> replacementRenderer = new RenderOffModelPlayer(Minecraft.func_71410_x().func_175598_ae(), new ModelSkeletonPlayer(), new ResourceLocation("textures/entity/skeleton/skeleton.png"));

    public CreatureReflectionRendererModifier(ReflectionRendererBase baseRenderer) {
        super(baseRenderer);
    }

    @Override
    public void render(float facing, float partialTicks) {
        EntityRenderer originalRenderer = this.getRenderer();
        this.setRenderer((EntityRenderer)this.replacementRenderer);
        super.render(facing, partialTicks);
        this.setRenderer(originalRenderer);
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class ModelSkeletonPlayer<T extends LivingEntity>
    extends BipedModel<T> {
        ModelSkeletonPlayer() {
            super(0.0f, 0.0f, 64, 32);
            this.field_178723_h = new RendererModel((Model)this, 40, 16);
            this.field_178723_h.func_78790_a(-1.0f, -2.0f, -1.0f, 2, 12, 2, 0.0f);
            this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.field_178724_i = new RendererModel((Model)this, 40, 16);
            this.field_178724_i.field_78809_i = true;
            this.field_178724_i.func_78790_a(-1.0f, -2.0f, -1.0f, 2, 12, 2, 0.0f);
            this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
            this.field_178721_j = new RendererModel((Model)this, 0, 16);
            this.field_178721_j.func_78790_a(-1.0f, 0.0f, -1.0f, 2, 12, 2, 0.0f);
            this.field_178721_j.func_78793_a(-2.0f, 12.0f, 0.0f);
            this.field_178722_k = new RendererModel((Model)this, 0, 16);
            this.field_178722_k.field_78809_i = true;
            this.field_178722_k.func_78790_a(-1.0f, 0.0f, -1.0f, 2, 12, 2, 0.0f);
            this.field_178722_k.func_78793_a(2.0f, 12.0f, 0.0f);
        }
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class RenderOffModelPlayer<T extends LivingEntity, M extends EntityModel<T>>
    extends LivingRenderer<T, M> {
        private final ResourceLocation textureLocation;

        RenderOffModelPlayer(EntityRendererManager renderManager, M model, ResourceLocation textureLocation) {
            super(renderManager, model, 0.0f);
            if (model instanceof IHasHead) {
                this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
            }
            this.func_177094_a((LayerRenderer)new ElytraLayer((IEntityRenderer)this));
            this.func_177094_a((LayerRenderer)new ArrowLayer((LivingRenderer)this));
            if (model instanceof IHasArm) {
                this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
            }
            if (model instanceof BipedModel) {
                this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
            }
            this.textureLocation = textureLocation;
        }

        public void func_76986_a(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
            this.setArmPoses(entity);
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        }

        private void setArmPoses(T entity) {
            EntityModel model = this.func_217764_d();
            ItemStack[] handItems = new ItemStack[]{entity.func_184614_ca(), entity.func_184592_cb()};
            BipedModel.ArmPose[] armPoses = new BipedModel.ArmPose[]{BipedModel.ArmPose.EMPTY, BipedModel.ArmPose.EMPTY};
            for (int side = 0; side < 2; ++side) {
                if (handItems[side].func_190926_b()) continue;
                armPoses[side] = BipedModel.ArmPose.ITEM;
                if (entity.func_184605_cv() <= 0) continue;
                UseAction itemUseAction = handItems[side].func_77975_n();
                if (itemUseAction == UseAction.BLOCK) {
                    armPoses[side] = BipedModel.ArmPose.BLOCK;
                    continue;
                }
                if (itemUseAction != UseAction.BOW) continue;
                armPoses[side] = BipedModel.ArmPose.BOW_AND_ARROW;
            }
            if (model instanceof BipedModel) {
                BipedModel bipedModel = (BipedModel)model;
                bipedModel.field_78117_n = entity.func_70093_af();
                if (entity.func_184591_cq() == HandSide.RIGHT) {
                    bipedModel.field_187076_m = armPoses[0];
                    bipedModel.field_187075_l = armPoses[1];
                } else {
                    bipedModel.field_187076_m = armPoses[1];
                    bipedModel.field_187075_l = armPoses[0];
                }
            }
        }

        @Nullable
        protected ResourceLocation getEntityTexture(T entity) {
            return this.textureLocation;
        }
    }
}

