/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.tomboshoven.minecraft.magicmirror.blocks.MagicMirrorBlock;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.MagicMirrorBaseTileEntity;
import com.tomboshoven.minecraft.magicmirror.reflection.Reflection;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
class TileEntityMagicMirrorRenderer
extends TileEntityRenderer<MagicMirrorBaseTileEntity> {
    private static final double MAX_HORIZONTAL_DISTANCE_SQ = 64.0;
    private static final double MAX_VERTICAL_DISTANCE_SQ = 9.0;

    TileEntityMagicMirrorRenderer() {
    }

    public void render(MagicMirrorBaseTileEntity tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        Entity reflected;
        super.func_199341_a((TileEntity)tileEntityIn, x, y, z, partialTicks, destroyStage);
        Reflection reflection = tileEntityIn.getReflection();
        if (reflection != null && (reflected = reflection.getReflectedEntity()) != null) {
            MagicMirrorBlock.EnumPartType part = tileEntityIn.getPart();
            Direction facing = tileEntityIn.getFacing();
            BlockPos tePos = tileEntityIn.func_174877_v();
            Vec3d reflectedPos = reflected.func_174791_d().func_72441_c(0.5, 0.5, 0.5);
            Vec3d distanceVector = reflectedPos.func_178786_a((double)tePos.func_177958_n(), (double)tePos.func_177956_o(), (double)tePos.func_177952_p());
            TileEntityMagicMirrorRenderer.renderReflection(reflection, x, y, z, partialTicks, part, facing, distanceVector);
        }
    }

    private static void renderReflection(Reflection reflection, double x, double y, double z, float partialTicks, MagicMirrorBlock.EnumPartType part, Direction facing, Vec3d distance) {
        reflection.render(facing, partialTicks);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        double horizontalDistanceSq = distance.field_72450_a * distance.field_72450_a + distance.field_72449_c * distance.field_72449_c;
        double verticalDistanceSq = distance.field_72448_b * distance.field_72448_b;
        float reflectionAlpha = Math.min(1.0f, 1.2f - (float)(horizontalDistanceSq / 64.0) - (float)(verticalDistanceSq / 9.0));
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)reflectionAlpha);
        GlStateManager.translated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.rotatef((float)facing.func_185119_l(), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.translated((double)0.0, (double)0.0, (double)-0.4);
        GlStateManager.disableLighting();
        reflection.bind();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double texTop = part == MagicMirrorBlock.EnumPartType.TOP ? 0.0 : 0.5;
        double texBottom = part == MagicMirrorBlock.EnumPartType.TOP ? 0.5 : 1.0;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, texBottom).func_181675_d();
        bufferbuilder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, texBottom).func_181675_d();
        bufferbuilder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, texTop).func_181675_d();
        bufferbuilder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, texTop).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }
}

