/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.blocks.tileentities;

import com.tomboshoven.minecraft.magicmirror.blocks.MagicMirrorBlock;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.MagicMirrorCoreTileEntity;
import com.tomboshoven.minecraft.magicmirror.blocks.tileentities.modifiers.MagicMirrorTileEntityModifier;
import com.tomboshoven.minecraft.magicmirror.reflection.Reflection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class MagicMirrorBaseTileEntity
extends TileEntity {
    MagicMirrorBaseTileEntity(TileEntityType<? extends MagicMirrorBaseTileEntity> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Nullable
    protected abstract MagicMirrorCoreTileEntity getCore();

    @Nullable
    public Reflection getReflection() {
        MagicMirrorCoreTileEntity core = this.getCore();
        if (core != null) {
            return core.getReflection();
        }
        return null;
    }

    public List<MagicMirrorTileEntityModifier> getModifiers() {
        MagicMirrorCoreTileEntity core = this.getCore();
        if (core != null) {
            return core.getModifiers();
        }
        return Collections.emptyList();
    }

    public void addModifier(MagicMirrorTileEntityModifier modifier) {
        MagicMirrorCoreTileEntity core = this.getCore();
        if (core != null) {
            core.addModifier(modifier);
        }
    }

    public void removeModifiers(World worldIn, BlockPos pos) {
        MagicMirrorCoreTileEntity core = this.getCore();
        if (core != null) {
            core.removeModifiers(worldIn, pos);
        }
    }

    public boolean tryActivate(PlayerEntity playerIn, Hand hand) {
        MagicMirrorCoreTileEntity core = this.getCore();
        if (core != null) {
            return core.tryActivate(playerIn, hand);
        }
        return false;
    }

    public Direction getFacing() {
        return (Direction)this.func_195044_w().func_177229_b((IProperty)HorizontalBlock.field_185512_D);
    }

    public MagicMirrorBlock.EnumPartType getPart() {
        return (MagicMirrorBlock.EnumPartType)((Object)this.func_195044_w().func_177229_b(MagicMirrorBlock.PART));
    }
}

