/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicmirror.reflection.renderers.modifiers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.tomboshoven.minecraft.magicmirror.reflection.renderers.ReflectionRendererBase;
import com.tomboshoven.minecraft.magicmirror.reflection.renderers.modifiers.ReflectionRendererModifier;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.layers.ParrotVariantLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CreatureReflectionRendererModifier
extends ReflectionRendererModifier {
    private final EntityRenderer<? extends Entity> replacementRenderer = new RenderOffModelPlayer(Minecraft.func_71410_x().func_175598_ae(), new ModelSkeletonPlayer(), new ResourceLocation("textures/entity/skeleton/skeleton.png"));

    public CreatureReflectionRendererModifier(ReflectionRendererBase baseRenderer) {
        super(baseRenderer);
    }

    @Override
    public void render(float facing, float partialTicks, IRenderTypeBuffer renderTypeBuffer) {
        EntityRenderer originalRenderer = this.getRenderer();
        this.setRenderer((EntityRenderer)this.replacementRenderer);
        super.render(facing, partialTicks, renderTypeBuffer);
        this.setRenderer(originalRenderer);
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class ModelSkeletonPlayer<T extends LivingEntity>
    extends BipedModel<T> {
        ModelSkeletonPlayer() {
            super(0.0f, 0.0f, 64, 32);
            this.field_178723_h = new ModelRenderer((Model)this, 40, 16);
            this.field_178723_h.func_228301_a_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, 0.0f);
            this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.field_178724_i = new ModelRenderer((Model)this, 40, 16);
            this.field_178724_i.field_78809_i = true;
            this.field_178724_i.func_228301_a_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, 0.0f);
            this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
            this.field_178721_j = new ModelRenderer((Model)this, 0, 16);
            this.field_178721_j.func_228301_a_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, 0.0f);
            this.field_178721_j.func_78793_a(-2.0f, 12.0f, 0.0f);
            this.field_178722_k = new ModelRenderer((Model)this, 0, 16);
            this.field_178722_k.field_78809_i = true;
            this.field_178722_k.func_228301_a_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, 0.0f);
            this.field_178722_k.func_78793_a(2.0f, 12.0f, 0.0f);
        }
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class RenderOffModelPlayer<T extends LivingEntity, M extends EntityModel<T>>
    extends LivingRenderer<T, M> {
        private final ResourceLocation textureLocation;

        RenderOffModelPlayer(EntityRendererManager renderManager, M model, ResourceLocation textureLocation) {
            super(renderManager, model, 0.0f);
            if (model instanceof IHasHead) {
                this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
            }
            this.func_177094_a((LayerRenderer)new ElytraLayer((IEntityRenderer)this));
            if (model instanceof IHasArm) {
                this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
            }
            if (model instanceof BipedModel) {
                this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
            }
            if (model instanceof PlayerModel) {
                this.func_177094_a((LayerRenderer)new ArrowLayer((LivingRenderer)this));
                this.func_177094_a((LayerRenderer)new ParrotVariantLayer((IEntityRenderer)this));
                this.func_177094_a((LayerRenderer)new SpinAttackEffectLayer((IEntityRenderer)this));
                this.func_177094_a((LayerRenderer)new BeeStingerLayer((LivingRenderer)this));
            }
            this.textureLocation = textureLocation;
        }

        public void func_225623_a_(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
            this.setArmPoses(entityIn);
            super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }

        private void setArmPoses(T entity) {
            EntityModel model = this.func_217764_d();
            ItemStack[] handItems = new ItemStack[]{entity.func_184614_ca(), entity.func_184592_cb()};
            BipedModel.ArmPose[] armPoses = new BipedModel.ArmPose[]{BipedModel.ArmPose.EMPTY, BipedModel.ArmPose.EMPTY};
            for (int side = 0; side < 2; ++side) {
                if (handItems[side].func_190926_b()) continue;
                armPoses[side] = BipedModel.ArmPose.ITEM;
                if (entity.func_184605_cv() <= 0) continue;
                UseAction itemUseAction = handItems[side].func_77975_n();
                if (itemUseAction == UseAction.BLOCK) {
                    armPoses[side] = BipedModel.ArmPose.BLOCK;
                    continue;
                }
                if (itemUseAction != UseAction.BOW) continue;
                armPoses[side] = BipedModel.ArmPose.BOW_AND_ARROW;
            }
            if (model instanceof BipedModel) {
                BipedModel bipedModel = (BipedModel)model;
                bipedModel.field_228270_o_ = entity.func_225608_bj_();
                if (entity.func_184591_cq() == HandSide.RIGHT) {
                    bipedModel.field_187076_m = armPoses[0];
                    bipedModel.field_187075_l = armPoses[1];
                } else {
                    bipedModel.field_187076_m = armPoses[1];
                    bipedModel.field_187075_l = armPoses[0];
                }
            }
        }

        public ResourceLocation getEntityTexture(T entity) {
            return this.textureLocation;
        }
    }
}

