/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.BlockCamo;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.integration.top.ElementModule;
import me.desht.modularrouters.integration.top.TOPInfoProvider;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.item.upgrade.ItemUpgrade;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BlockItemRouter
extends BlockCamo
implements TOPInfoProvider {
    private static final String BLOCK_NAME = "item_router";
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyBool OPEN_F = PropertyBool.func_177716_a((String)"open_f");
    public static final PropertyBool OPEN_B = PropertyBool.func_177716_a((String)"open_b");
    public static final PropertyBool OPEN_U = PropertyBool.func_177716_a((String)"open_u");
    public static final PropertyBool OPEN_D = PropertyBool.func_177716_a((String)"open_d");
    public static final PropertyBool OPEN_L = PropertyBool.func_177716_a((String)"open_l");
    public static final PropertyBool OPEN_R = PropertyBool.func_177716_a((String)"open_r");
    public static final PropertyBool CAN_EMIT = PropertyBool.func_177716_a((String)"can_emit");
    public static final String NBT_MODULES = "Modules";
    public static final String NBT_UPGRADES = "Upgrades";
    public static final String NBT_MODULE_COUNT = "ModuleCount";
    public static final String NBT_UPGRADE_COUNT = "UpgradeCount";
    public static final String NBT_REDSTONE_BEHAVIOUR = "RedstoneBehaviour";

    public BlockItemRouter() {
        super(Material.field_151573_f, BLOCK_NAME);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(((IExtendedBlockState)this.field_176227_L.func_177621_b()).withProperty((IUnlistedProperty)CAMOUFLAGE_STATE, null).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CAN_EMIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{FACING, ACTIVE, OPEN_F, OPEN_B, OPEN_U, OPEN_D, OPEN_L, OPEN_R, CAN_EMIT}, new IUnlistedProperty[]{CAMOUFLAGE_STATE, BLOCK_ACCESS, BLOCK_POS});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt(world, pos);
        if (router != null && router.getCamouflage() == null) {
            state = state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(router.isActive() && router.getUpgradeCount(ItemUpgrade.UpgradeType.MUFFLER) < 3));
            for (Module.RelativeDirection side : Module.RelativeDirection.realSides()) {
                state = state.func_177226_a((IProperty)side.getProperty(), (Comparable)Boolean.valueOf(router.isSideOpen(side)));
            }
        }
        return state;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer == null ? facing : EnumFacing.func_176733_a((double)placer.field_70177_z).func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)world, pos);
        NBTTagCompound compound = stack.func_77978_p();
        if (router != null && compound != null) {
            ((ItemStackHandler)router.getModules()).deserializeNBT(compound.func_74775_l(NBT_MODULES));
            ((ItemStackHandler)router.getUpgrades()).deserializeNBT(compound.func_74775_l(NBT_UPGRADES));
            try {
                router.setRedstoneBehaviour(RouterRedstoneBehaviour.valueOf(compound.func_74779_i(NBT_REDSTONE_BEHAVIOUR)));
            }
            catch (IllegalArgumentException e) {
                router.setRedstoneBehaviour(RouterRedstoneBehaviour.ALWAYS);
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing.func_176736_b();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityItemRouter();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState blockstate) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)world, pos);
        if (router != null) {
            InventoryUtils.dropInventoryItems(world, pos, router.getBuffer());
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, blockstate);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)world, pos);
        if (router != null) {
            ItemStack stack = router.getBufferItemStack();
            return stack.func_190926_b() ? 0 : MathHelper.func_76141_d((float)(1.0f + (float)stack.func_190916_E() / (float)stack.func_77976_d() * 14.0f));
        }
        return 0;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> l, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt(world, pos);
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
        if (router != null) {
            if (router.getModuleCount() > 0 || router.getUpgradeCount() > 0 || router.getRedstoneBehaviour() != RouterRedstoneBehaviour.ALWAYS) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                NBTTagCompound compound = stack.func_77978_p();
                compound.func_74782_a(NBT_MODULES, (NBTBase)((ItemStackHandler)router.getModules()).serializeNBT());
                compound.func_74782_a(NBT_UPGRADES, (NBTBase)((ItemStackHandler)router.getUpgrades()).serializeNBT());
                compound.func_74778_a(NBT_REDSTONE_BEHAVIOUR, router.getRedstoneBehaviour().toString());
                compound.func_74768_a(NBT_MODULE_COUNT, router.getModuleCount());
                for (ItemUpgrade.UpgradeType type : ItemUpgrade.UpgradeType.values()) {
                    compound.func_74768_a("UpgradeCount." + (Object)((Object)type), router.getUpgradeCount(type));
                }
            }
            l.add((Object)stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b(NBT_MODULE_COUNT)) {
            tooltip.add(I18n.func_135052_a((String)"itemText.misc.routerConfigured", (Object[])new Object[0]));
            int modules = compound.func_74762_e(NBT_MODULE_COUNT);
            MiscUtil.appendMultiline(tooltip, "itemText.misc.moduleCount", modules);
            if (modules > 0) {
                ItemStackHandler modulesHandler = new ItemStackHandler(9);
                modulesHandler.deserializeNBT(compound.func_74775_l(NBT_MODULES));
                for (int i = 0; i < modulesHandler.getSlots(); ++i) {
                    ItemStack moduleStack = modulesHandler.getStackInSlot(i);
                    if (moduleStack.func_190926_b()) continue;
                    tooltip.add(TextFormatting.AQUA + "\u2022 " + I18n.func_135052_a((String)(moduleStack.func_77977_a() + ".name"), (Object[])new Object[0]));
                }
            }
            for (ItemUpgrade.UpgradeType type : ItemUpgrade.UpgradeType.values()) {
                int c = compound.func_74762_e("UpgradeCount." + (Object)((Object)type));
                if (c <= 0) continue;
                String name = I18n.func_135052_a((String)("item." + type.toString().toLowerCase() + "_upgrade.name"), (Object[])new Object[0]);
                tooltip.add(I18n.func_135052_a((String)"itemText.misc.upgradeCount", (Object[])new Object[]{name, c}));
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityItemRouter router;
        if (!player.func_70093_af() && (router = TileEntityItemRouter.getRouterAt((IBlockAccess)world, pos)) != null) {
            if (router.isPermitted(player) && !world.field_72995_K) {
                player.openGui((Object)ModularRouters.instance, ModularRouters.GUI_ROUTER, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else if (!router.isPermitted(player) && world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chatText.security.accessDenied", new Object[0]), false);
                player.func_184185_a(RegistrarMR.SOUND_ERROR, 1.0f, 1.0f);
            }
        }
        return true;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)world, data.getPos());
        if (router != null) {
            if (router.isPermitted(player)) {
                IItemHandler modules = router.getModules();
                IProbeInfo sub = probeInfo.horizontal();
                for (int i = 0; i < modules.getSlots(); ++i) {
                    ItemStack stack = modules.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    sub.element((IElement)new ElementModule(stack));
                }
                sub = probeInfo.horizontal();
                for (ItemUpgrade.UpgradeType type : ItemUpgrade.UpgradeType.values()) {
                    if (router.getUpgradeCount(type) <= 0) continue;
                    sub.item(ItemUpgrade.makeItemStack(type, router.getUpgradeCount(type)));
                }
                probeInfo.text(TextFormatting.WHITE + MiscUtil.translate("guiText.tooltip.redstone.label", new Object[0]) + ": " + TextFormatting.AQUA + MiscUtil.translate("guiText.tooltip.redstone." + (Object)((Object)router.getRedstoneBehaviour()), new Object[0]));
            } else {
                probeInfo.text(MiscUtil.translate("chatText.security.accessDenied", new Object[0]));
            }
        }
    }

    @Override
    public boolean func_149744_f(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CAN_EMIT);
    }

    @Override
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt(blockAccess, pos);
        if (router != null) {
            int l = router.getRedstoneLevel(side, false);
            return l < 0 ? super.func_180656_a(blockState, blockAccess, pos, side) : l;
        }
        return 0;
    }

    @Override
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt(blockAccess, pos);
        if (router != null) {
            int l = router.getRedstoneLevel(side, true);
            return l < 0 ? super.func_176211_b(blockState, blockAccess, pos, side) : l;
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)worldIn, pos);
        if (router != null) {
            router.checkForRedstonePulse();
            router.notifyModules();
        }
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt(world, pos);
        return (router == null || router.getUpgradeCount(ItemUpgrade.UpgradeType.BLAST) <= 0) && super.canEntityDestroy(state, world, pos, entity);
    }

    @Override
    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)world, pos);
        if (router != null && router.getUpgradeCount(ItemUpgrade.UpgradeType.BLAST) > 0) {
            return 20000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }
}

