/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block.tile;

import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.ICamouflageable;
import me.desht.modularrouters.util.Scheduler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TileEntityTemplateFrame
extends TileEntity
implements ICamouflageable {
    private static final String NBT_CAMO_NAME = "CamouflageName";
    private static final String NBT_CAMO_META = "CamouflageMeta";
    private static final String NBT_MIMIC = "Mimic";
    private IBlockState camouflage = null;
    private boolean extendedMimic;

    @Nullable
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.templateFrame.name", new Object[0]);
    }

    public static TileEntityTemplateFrame getTileEntitySafely(IBlockAccess world, BlockPos pos) {
        TileEntity te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        return te instanceof TileEntityTemplateFrame ? (TileEntityTemplateFrame)te : null;
    }

    @Override
    public IBlockState getCamouflage() {
        return this.camouflage;
    }

    @Override
    public void setCamouflage(IBlockState camouflage) {
        this.camouflage = camouflage;
    }

    @Override
    public boolean extendedMimic() {
        return this.extendedMimic;
    }

    @Override
    public void setExtendedMimic(boolean mimic) {
        this.extendedMimic = mimic;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.camouflage = TileEntityTemplateFrame.getCamoStateFromNBT(compound);
        this.extendedMimic = compound.func_74767_n(NBT_MIMIC);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74757_a(NBT_MIMIC, this.extendedMimic);
        return TileEntityTemplateFrame.getNBTFromCamoState(compound, this.camouflage);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.camouflage = TileEntityTemplateFrame.getCamoStateFromNBT(pkt.func_148857_g());
        this.extendedMimic = pkt.func_148857_g().func_74767_n(NBT_MIMIC);
        if (this.camouflage != null && this.extendedMimic && this.camouflage.func_177230_c().func_149750_m(this.camouflage) > 0) {
            this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
        }
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.camouflage = TileEntityTemplateFrame.getCamoStateFromNBT(tag);
        this.extendedMimic = tag.func_74767_n(NBT_MIMIC);
        if (this.camouflage != null && this.extendedMimic && this.camouflage.func_177230_c().func_149750_m(this.camouflage) > 0) {
            Scheduler.client().schedule(() -> this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v()), 1L);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        compound.func_74757_a(NBT_MIMIC, this.extendedMimic);
        return TileEntityTemplateFrame.getNBTFromCamoState(compound, this.camouflage);
    }

    private static IBlockState getCamoStateFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b(NBT_CAMO_NAME)) {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.func_74779_i(NBT_CAMO_NAME)));
            return b != null ? b.func_176203_a(tag.func_74762_e(NBT_CAMO_META)) : null;
        }
        return null;
    }

    private static NBTTagCompound getNBTFromCamoState(NBTTagCompound compound, IBlockState camouflage) {
        if (camouflage != null) {
            Block b = camouflage.func_177230_c();
            compound.func_74778_a(NBT_CAMO_NAME, b.getRegistryName().toString());
            compound.func_74768_a(NBT_CAMO_META, b.func_176201_c(camouflage));
        }
        return compound;
    }

    public void setCamouflage(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemBlock) {
            this.camouflage = ((ItemBlock)itemStack.func_77973_b()).func_179223_d().func_176203_a(itemStack.func_77960_j());
        }
    }
}

