/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import me.desht.modularrouters.client.gui.IMouseOverHelpProvider;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MouseOverHelp {
    private static final int TEXT_MARGIN = 8;
    private final List<HelpRegion> helpRegions = new ArrayList<HelpRegion>();
    private final GuiContainer screen;
    private boolean active = false;

    public MouseOverHelp(GuiContainer screen) {
        this.screen = screen;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void addHelpRegion(int x1, int y1, int x2, int y2, String key) {
        this.addHelpRegion(x1, y1, x2, y2, key, HelpRegion.YES);
    }

    public void addHelpRegion(int x1, int y1, int x2, int y2, String key, Predicate<GuiContainer> showPredicate) {
        this.helpRegions.add(new HelpRegion(x1, y1, x2, y2, MiscUtil.wrapString(I18n.func_135052_a((String)key, (Object[])new Object[0])), showPredicate));
    }

    private void onMouseOver(int mouseX, int mouseY) {
        HelpRegion region;
        if (this.active && (region = this.getRegionAt(mouseX, mouseY)) != null) {
            MouseOverHelp.showPopupBox(this.screen, Minecraft.func_71410_x().field_71466_p, region.extent, -1073741824, 1614872575, 0, null);
            MouseOverHelp.showPopupBox(this.screen, Minecraft.func_71410_x().field_71466_p, region.extent, -1073741824, -534765536, -2039584, region.text);
        }
    }

    private HelpRegion getRegionAt(int mouseX, int mouseY) {
        for (HelpRegion region : this.helpRegions) {
            if (!region.extent.contains(mouseX, mouseY) || !region.showPredicate.test(this.screen)) continue;
            return region;
        }
        return null;
    }

    private static void showPopupBox(GuiContainer screen, FontRenderer fontRenderer, Rectangle rect, int borderColor, int bgColor, int textColor, List<String> helpText) {
        Rectangle rect2 = new Rectangle(rect);
        if (helpText != null && !helpText.isEmpty()) {
            int boxWidth = 0;
            int boxHeight = helpText.size() * fontRenderer.field_78288_b;
            for (String s : helpText) {
                boxWidth = Math.max(boxWidth, fontRenderer.func_78256_a(s));
            }
            int xOff = rect.x - screen.getGuiLeft() < screen.getXSize() / 2 ? rect.width + 10 : -(boxWidth + 8 + 10);
            int yOff = (rect.height - boxHeight - 8) / 2;
            rect2.setBounds(rect.x + xOff, rect.y + yOff, boxWidth + 8, boxHeight + 8);
        }
        int x1 = rect2.x - screen.getGuiLeft();
        int y1 = rect2.y - screen.getGuiTop();
        int x2 = x1 + rect2.width;
        int y2 = y1 + rect2.height;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
        Gui.func_73734_a((int)x1, (int)y1, (int)x2, (int)y2, (int)bgColor);
        Gui.func_73734_a((int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)borderColor);
        Gui.func_73734_a((int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)borderColor);
        Gui.func_73734_a((int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)borderColor);
        Gui.func_73734_a((int)x2, (int)y1, (int)(x2 + 1), (int)(y2 + 1), (int)borderColor);
        if (helpText != null) {
            for (String s : helpText) {
                fontRenderer.func_78276_b(s, x1 + 4, y1 + 4, textColor);
                y1 += fontRenderer.field_78288_b;
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
    }

    @SubscribeEvent
    public static void drawMouseOver(GuiContainerEvent.DrawForeground event) {
        if (event.getGuiContainer() instanceof IMouseOverHelpProvider) {
            ((IMouseOverHelpProvider)event.getGuiContainer()).getMouseOverHelp().onMouseOver(event.getMouseX(), event.getMouseY());
        }
    }

    public static class Button
    extends TexturedToggleButton {
        private final MouseOverHelp mouseOverHelp;

        public Button(int buttonId, int x, int y, MouseOverHelp mouseOverHelp) {
            super(buttonId, x, y, 16, 16, false);
            this.mouseOverHelp = mouseOverHelp;
            this.tooltip1.addAll(MiscUtil.wrapString(I18n.func_135052_a((String)"guiText.tooltip.mouseOverHelp.false", (Object[])new Object[0])));
            this.tooltip2.addAll(MiscUtil.wrapString(I18n.func_135052_a((String)"guiText.tooltip.mouseOverHelp.true", (Object[])new Object[0])));
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        @Override
        public boolean sendToServer() {
            return false;
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 208 : 192;
        }

        @Override
        protected int getTextureY() {
            return 0;
        }
    }

    public static class HelpRegion {
        final Rectangle extent;
        final List<String> text;
        final Predicate<GuiContainer> showPredicate;
        static final Predicate<GuiContainer> YES = guiContainer -> true;

        HelpRegion(int x1, int y1, int x2, int y2, List<String> text) {
            this(x1, y1, x2, y2, text, YES);
        }

        HelpRegion(int x1, int y1, int x2, int y2, List<String> text, Predicate<GuiContainer> showPredicate) {
            this.extent = new Rectangle(x1, y1, x2 - x1, y2 - y1);
            this.text = text;
            this.showPredicate = showPredicate;
        }
    }
}

