/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.smartfilter.ItemSmartFilter;
import me.desht.modularrouters.item.smartfilter.SmartFilter;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FilterGuiFactory {
    public static GuiScreen createGui(EntityPlayer player, EnumHand hand) {
        return FilterGuiFactory.createGui(player, player.func_184586_b(hand), null, -1, -1, hand);
    }

    public static GuiScreen createGui(EntityPlayer player, World world, int x, int y, int z) {
        int filterIndex;
        int moduleIndex;
        ItemStack filterStack;
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)world, new BlockPos(x, y, z));
        if (router != null && ItemSmartFilter.getFilter(filterStack = FilterGuiFactory.getFilterStackInInstalledModule(router, moduleIndex = router.getModuleConfigSlot(player), filterIndex = router.getFilterConfigSlot(player))) != null) {
            router.clearConfigSlot(player);
            return FilterGuiFactory.createGui(player, filterStack, router.func_174877_v(), moduleIndex, filterIndex, null);
        }
        return null;
    }

    private static GuiScreen createGui(EntityPlayer player, ItemStack heldStack, BlockPos routerPos, int moduleSlotIndex, int filterSlotIndex, EnumHand hand) {
        ItemStack filterStack;
        if (ItemModule.getModule(heldStack) != null) {
            filterSlotIndex = ModuleHelper.getFilterConfigSlot(heldStack);
            filterStack = FilterGuiFactory.getFilterStackInUninstalledModule(heldStack, filterSlotIndex);
            ModuleHelper.setFilterConfigSlot(heldStack, -1);
        } else if (ItemSmartFilter.getFilter(heldStack) != null) {
            filterStack = heldStack;
        } else {
            return null;
        }
        if (filterStack.func_190926_b()) {
            return null;
        }
        try {
            SmartFilter filter = ItemSmartFilter.getFilter(filterStack);
            Class<? extends GuiScreen> clazz = filter.getGuiHandler();
            if (filter.hasGuiContainer()) {
                Constructor<? extends GuiScreen> ctor = clazz.getConstructor(ContainerSmartFilter.class, BlockPos.class, Integer.class, Integer.class, EnumHand.class);
                TileEntityItemRouter router = routerPos == null ? null : TileEntityItemRouter.getRouterAt((IBlockAccess)player.func_130014_f_(), routerPos);
                return ctor.newInstance(FilterGuiFactory.createContainer(player, filterStack, hand, router), routerPos, moduleSlotIndex, filterSlotIndex, hand);
            }
            Constructor<? extends GuiScreen> ctor = clazz.getConstructor(ItemStack.class, BlockPos.class, Integer.class, Integer.class, EnumHand.class);
            return ctor.newInstance(filterStack, routerPos, moduleSlotIndex, filterSlotIndex, hand);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Container createContainer(EntityPlayer player, EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (ItemModule.getModule(heldStack) != null) {
            int filterIndex = ModuleHelper.getFilterConfigSlot(heldStack);
            if (filterIndex >= 0) {
                ItemStack filterStack = FilterGuiFactory.getFilterStackInUninstalledModule(heldStack, filterIndex);
                ModuleHelper.setFilterConfigSlot(heldStack, -1);
                return FilterGuiFactory.createContainer(player, filterStack, hand, null);
            }
        } else {
            return FilterGuiFactory.createContainer(player, heldStack, hand, null);
        }
        return null;
    }

    public static Container createContainer(EntityPlayer player, World world, int x, int y, int z) {
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)world, new BlockPos(x, y, z));
        if (router != null) {
            int moduleIndex = router.getModuleConfigSlot(player);
            int filterIndex = router.getFilterConfigSlot(player);
            ItemStack filterStack = FilterGuiFactory.getFilterStackInInstalledModule(router, moduleIndex, filterIndex);
            return FilterGuiFactory.createContainer(player, filterStack, null, router);
        }
        return null;
    }

    private static Container createContainer(EntityPlayer player, ItemStack stack, EnumHand hand, TileEntityItemRouter router) {
        SmartFilter f = ItemSmartFilter.getFilter(stack);
        return f != null && f.hasGuiContainer() ? f.createContainer(player, stack, hand, router) : null;
    }

    private static ItemStack getFilterStackInUninstalledModule(ItemStack moduleStack, int filterIdx) {
        return FilterGuiFactory.getStackInSlot(moduleStack, filterIdx);
    }

    private static ItemStack getFilterStackInInstalledModule(TileEntityItemRouter router, int moduleIdx, int filterIdx) {
        if (moduleIdx < 0 || filterIdx < 0) {
            return null;
        }
        ItemStack installedModuleStack = router.getModules().getStackInSlot(moduleIdx);
        return FilterGuiFactory.getStackInSlot(installedModuleStack, filterIdx);
    }

    private static ItemStack getStackInSlot(ItemStack moduleStack, int filterIdx) {
        BaseModuleHandler.ModuleFilterHandler handler = new BaseModuleHandler.ModuleFilterHandler(moduleStack);
        ItemStack stack = handler.getStackInSlot(filterIdx);
        if (!stack.func_190926_b()) {
            return stack;
        }
        ModularRouters.logger.warn("can't find filter item in module '" + moduleStack + "', slot " + filterIdx);
        return null;
    }
}

