/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.base.Joiner;
import java.io.IOException;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.gui.BackButton;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.filter.GuiFilterScreen;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.item.smartfilter.InspectionFilter;
import me.desht.modularrouters.logic.filter.matchers.InspectionMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiInspectionFilter
extends GuiFilterScreen {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/inspectionfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 191;
    private static final int BACK_BUTTON_ID = 1;
    private static final int SUBJECT_BUTTON_ID = 2;
    private static final int OP_BUTTON_ID = 3;
    private static final int ADD_BUTTON_ID = 4;
    private static final int MATCH_BUTTON_ID = 5;
    private static final int BASE_REMOVE_ID = 100;
    private int xPos;
    private int yPos;
    private InspectionMatcher.ComparisonList comparisonList;
    private IntegerTextField valueTextField;
    private InspectionMatcher.InspectionSubject currentSubject = InspectionMatcher.InspectionSubject.NONE;
    private InspectionMatcher.InspectionOp currentOp = InspectionMatcher.InspectionOp.NONE;

    public GuiInspectionFilter(ItemStack filterStack, BlockPos routerPos, Integer moduleSlotIndex, Integer filterSlotIndex, EnumHand hand) {
        super(filterStack, routerPos, moduleSlotIndex, filterSlotIndex, hand);
        this.comparisonList = InspectionFilter.getComparisonList(filterStack);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.xPos = (this.field_146294_l - 176) / 2;
        this.yPos = (this.field_146295_m - 191) / 2;
        this.field_146292_n.clear();
        if (this.filterSlotIndex >= 0) {
            this.field_146292_n.add(new BackButton(1, this.xPos - 12, this.yPos));
        }
        this.field_146292_n.add(new GuiButton(2, this.xPos + 8, this.yPos + 23, 90, 20, I18n.func_135052_a((String)("guiText.label.inspectionSubject." + (Object)((Object)this.currentSubject)), (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(3, this.xPos + 95, this.yPos + 23, 20, 20, I18n.func_135052_a((String)("guiText.label.inspectionOp." + (Object)((Object)this.currentOp)), (Object[])new Object[0])));
        this.field_146292_n.add(new Buttons.AddButton(4, this.xPos + 152, this.yPos + 23));
        this.field_146292_n.add(new GuiButton(5, this.xPos + 8, this.yPos + 167, 60, 20, I18n.func_135052_a((String)("guiText.label.matchAll." + this.comparisonList.isMatchAll()), (Object[])new Object[0])));
        for (int i = 0; i < this.comparisonList.items.size(); ++i) {
            this.field_146292_n.add(new Buttons.DeleteButton(100 + i, this.xPos + 8, this.yPos + 52 + i * 19));
        }
        TextFieldManager manager = this.getTextFieldManager().clear();
        this.valueTextField = new IntegerTextField(manager, 1, this.field_146289_q, this.xPos + 120, this.yPos + 28, 20, 14, 0, 100);
        this.valueTextField.useGuiTextBackground();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(textureLocation);
        this.func_73729_b(this.xPos, this.yPos, 0, 0, 176, 191);
        this.field_146289_q.func_78276_b(this.title, this.xPos + 88 - this.field_146289_q.func_78256_a(this.title) / 2, this.yPos + 6, 0x404040);
        for (int i = 0; i < this.comparisonList.items.size(); ++i) {
            InspectionMatcher.Comparison comparison = this.comparisonList.items.get(i);
            this.field_146289_q.func_78276_b(comparison.asLocalizedText(), this.xPos + 28, this.yPos + 55 + i * 19, 0x404080);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 2: {
                this.currentSubject = this.currentSubject.cycle(GuiScreen.func_146272_n() ? -1 : 1);
                button.field_146126_j = I18n.func_135052_a((String)("guiText.label.inspectionSubject." + (Object)((Object)this.currentSubject)), (Object[])new Object[0]);
                break;
            }
            case 3: {
                this.currentOp = this.currentOp.cycle(GuiScreen.func_146272_n() ? -1 : 1);
                button.field_146126_j = I18n.func_135052_a((String)("guiText.label.inspectionOp." + (Object)((Object)this.currentOp)), (Object[])new Object[0]);
                break;
            }
            case 4: {
                int val = this.valueTextField.getValue();
                String s = Joiner.on((String)" ").join((Object)this.currentSubject, (Object)this.currentOp, new Object[]{val});
                this.sendAddStringMessage("Comparison", s);
                this.valueTextField.func_146180_a("");
                break;
            }
            case 5: {
                NBTTagCompound ext = new NBTTagCompound();
                ext.func_74757_a("MatchAll", !this.comparisonList.isMatchAll());
                if (this.routerPos != null) {
                    ModularRouters.network.sendToServer((IMessage)new FilterSettingsMessage(FilterSettingsMessage.Operation.ANY_ALL_FLAG, this.routerPos, this.moduleSlotIndex, this.filterSlotIndex, ext));
                } else {
                    ModularRouters.network.sendToServer((IMessage)new FilterSettingsMessage(FilterSettingsMessage.Operation.ANY_ALL_FLAG, this.hand, (int)this.filterSlotIndex, ext));
                }
            }
            default: {
                if (button.field_146127_k >= 100 && button.field_146127_k < 100 + this.comparisonList.items.size()) {
                    this.sendRemovePosMessage(button.field_146127_k - 100);
                    break;
                }
                super.func_146284_a(button);
            }
        }
    }

    @Override
    public void resync(ItemStack stack) {
        this.comparisonList = InspectionFilter.getComparisonList(stack);
        this.func_73866_w_();
    }
}

