/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.gui.BackButton;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.filter.GuiFilterContainer;
import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.item.smartfilter.ModFilter;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiModFilter
extends GuiFilterContainer {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/modfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 252;
    private static final int ADD_BUTTON_ID = 1;
    private static final int BACK_BUTTON_ID = 2;
    private static final int BASE_REMOVE_ID = 100;
    private final List<String> mods = Lists.newArrayList();
    private ItemStack prevInSlot = ItemStack.field_190927_a;
    private String modId = "";
    private String modName = "";

    public GuiModFilter(ContainerSmartFilter container, BlockPos routerPos, Integer moduleSlotIndex, Integer filterSlotIndex, EnumHand hand) {
        super(container, routerPos, moduleSlotIndex, filterSlotIndex, hand);
        this.field_146999_f = 176;
        this.field_147000_g = 252;
        this.mods.addAll(ModFilter.getModList(this.filterStack));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        if (this.filterSlotIndex >= 0) {
            this.field_146292_n.add(new BackButton(2, this.field_147003_i - 12, this.field_147009_r));
        }
        this.field_146292_n.add(new Buttons.AddButton(1, this.field_147003_i + 154, this.field_147009_r + 19));
        for (int i = 0; i < this.mods.size(); ++i) {
            this.field_146292_n.add(new Buttons.DeleteButton(100 + i, this.field_147003_i + 8, this.field_147009_r + 44 + i * 19));
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String title = this.filterStack.func_82833_r() + (this.routerPos != null ? I18n.func_135052_a((String)"guiText.label.installed", (Object[])new Object[0]) : "");
        this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(title) / 2, 8, 0x404040);
        if (!this.modName.isEmpty()) {
            this.field_146289_q.func_78276_b(this.modName, 29, 23, 0x404040);
        }
        for (int i = 0; i < this.mods.size(); ++i) {
            String mod = ModNameCache.getModName(this.mods.get(i));
            this.field_146289_q.func_78276_b(mod, 28, 47 + i * 19, 0x404080);
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        ItemStack inSlot = (ItemStack)this.field_147002_h.func_75138_a().get(0);
        if (inSlot.func_190926_b() && !this.prevInSlot.func_190926_b()) {
            this.modName = "";
            this.modId = "";
        } else if (!(inSlot.func_190926_b() || !this.prevInSlot.func_190926_b() && inSlot.func_185136_b(this.prevInSlot))) {
            this.modId = inSlot.func_77973_b().getRegistryName().func_110624_b();
            this.modName = ModNameCache.getModName(this.modId);
        }
        this.prevInSlot = inSlot;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(textureLocation);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 1 && !this.modId.isEmpty()) {
            NBTTagCompound ext = new NBTTagCompound();
            ext.func_74778_a("ModId", this.modId);
            if (this.routerPos != null) {
                ModularRouters.network.sendToServer((IMessage)new FilterSettingsMessage(FilterSettingsMessage.Operation.ADD_STRING, this.routerPos, this.moduleSlotIndex, this.filterSlotIndex, ext));
            } else {
                ModularRouters.network.sendToServer((IMessage)new FilterSettingsMessage(FilterSettingsMessage.Operation.ADD_STRING, this.hand, (int)this.filterSlotIndex, ext));
            }
            ((Slot)this.field_147002_h.field_75151_b.get(0)).func_75215_d(ItemStack.field_190927_a);
        } else if (button.field_146127_k >= 100 && button.field_146127_k < 100 + this.mods.size()) {
            NBTTagCompound ext = new NBTTagCompound();
            ext.func_74768_a("Pos", button.field_146127_k - 100);
            if (this.routerPos != null) {
                ModularRouters.network.sendToServer((IMessage)new FilterSettingsMessage(FilterSettingsMessage.Operation.REMOVE_AT, this.routerPos, this.moduleSlotIndex, this.filterSlotIndex, ext));
            } else {
                ModularRouters.network.sendToServer((IMessage)new FilterSettingsMessage(FilterSettingsMessage.Operation.REMOVE_AT, this.hand, (int)this.filterSlotIndex, ext));
            }
        } else if (button.field_146127_k == 2) {
            this.closeGUI();
        } else {
            super.func_146284_a(button);
        }
    }

    @Override
    public void resync(ItemStack filterStack) {
        this.mods.clear();
        this.mods.addAll(ModFilter.getModList(filterStack));
        this.func_73866_w_();
    }
}

