/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.logic.compiled.CompiledDetectorModule;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class GuiModuleDetector
extends GuiModule {
    private static final int STRENGTH_BUTTON_ID = 1000;
    private static final int TOOLTIP_BUTTON_ID = 1001;
    private static final int SIGNAL_LEVEL_TEXTFIELD_ID = 1000;
    private static final ItemStack redstoneStack = new ItemStack(Items.field_151137_ax);
    private int signalStrength;
    private boolean isStrong;

    public GuiModuleDetector(ContainerModule containerItem, EnumHand hand) {
        this(containerItem, null, -1, hand);
    }

    public GuiModuleDetector(ContainerModule containerItem, BlockPos routerPos, Integer slotIndex, EnumHand hand) {
        super(containerItem, routerPos, slotIndex, hand);
        CompiledDetectorModule settings = new CompiledDetectorModule(null, this.moduleItemStack);
        this.signalStrength = settings.getSignalLevel();
        this.isStrong = settings.isStrongSignal();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        TextFieldManager manager = this.getOrCreateTextFieldManager();
        IntegerTextField intField = new IntegerTextField(manager, 1000, this.field_146289_q, this.field_147003_i + 152, this.field_147009_r + 19, 20, 12, 0, 15);
        intField.setValue(this.signalStrength);
        intField.func_175207_a(this);
        intField.setIncr(1, 4);
        intField.useGuiTextBackground();
        manager.focus(0);
        String label = I18n.func_135052_a((String)("itemText.misc.strongSignal." + this.isStrong), (Object[])new Object[0]);
        this.field_146292_n.add(new GuiButton(1000, this.field_147003_i + 138, this.field_147009_r + 33, 40, 20, label));
        this.field_146292_n.add(new TooltipButton(1001, this.field_147003_i + 132, this.field_147009_r + 15, 16, 16, redstoneStack));
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 129, this.field_147009_r + 14, this.field_147003_i + 172, this.field_147009_r + 31, "guiText.popup.detector.signalLevel");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 135, this.field_147009_r + 31, this.field_147003_i + 180, this.field_147009_r + 54, "guiText.popup.detector.weakStrong");
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.func_73729_b(this.field_147003_i + 148, this.field_147009_r + 16, GuiModuleDetector.SMALL_TEXTFIELD_XY.x, GuiModuleDetector.SMALL_TEXTFIELD_XY.y, 21, 14);
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 1000) {
            this.isStrong = !this.isStrong;
            button.field_146126_j = I18n.func_135052_a((String)("itemText.misc.strongSignal." + this.isStrong), (Object[])new Object[0]);
            this.sendModuleSettingsToServer();
        } else {
            super.func_146284_a(button);
        }
    }

    @Override
    public void func_175319_a(int id, String value) {
        if (id == 1000) {
            this.signalStrength = value.isEmpty() ? 0 : Integer.parseInt(value);
            this.sendModuleSettingsDelayed(5);
        } else {
            super.func_175319_a(id, value);
        }
    }

    @Override
    protected NBTTagCompound buildMessageData() {
        NBTTagCompound compound = super.buildMessageData();
        compound.func_74774_a("SignalLevel", (byte)this.signalStrength);
        compound.func_74757_a("StrongSignal", this.isStrong);
        return compound;
    }

    private static class TooltipButton
    extends ItemStackButton {
        TooltipButton(int buttonId, int x, int y, int width, int height, ItemStack renderStack) {
            super(buttonId, x, y, width, height, renderStack, true);
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.detectorTooltip", new Object[0]);
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.numberFieldTooltip", new Object[0]);
        }

        public void func_146113_a(SoundHandler soundHandlerIn) {
        }
    }
}

