/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.RenderHelper;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.module.FluidModule;
import me.desht.modularrouters.logic.compiled.CompiledFluidModule;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.block.Block;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class GuiModuleFluid
extends GuiModule {
    private static final ItemStack bucketStack = new ItemStack(Items.field_151133_ar);
    private static final ItemStack routerStack = new ItemStack((Block)RegistrarMR.ITEM_ROUTER);
    private static final ItemStack waterStack = new ItemStack(Items.field_151131_as);
    private static final int TRANSFER_TEXTFIELD_ID = 1;
    private static final int TOOLTIP_BUTTON_ID = 1000;
    private static final int FLUID_DIRECTION_BUTTON_ID = 1001;
    private static final int FORCE_EMPTY_BUTTON_ID = 1002;
    private ForceEmptyButton forceEmptyButton;
    private FluidModule.FluidDirection fluidDirection;
    private int maxTransfer;
    private boolean forceEmpty;

    public GuiModuleFluid(ContainerModule containerItem, EnumHand hand) {
        this(containerItem, null, -1, hand);
    }

    public GuiModuleFluid(ContainerModule containerItem, BlockPos routerPos, Integer slotIndex, EnumHand hand) {
        super(containerItem, routerPos, slotIndex, hand);
        CompiledFluidModule cfm = new CompiledFluidModule(null, this.moduleItemStack);
        this.fluidDirection = cfm.getFluidDirection();
        this.maxTransfer = cfm.getMaxTransfer();
        this.forceEmpty = cfm.isForceEmpty();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        TextFieldManager manager = this.getOrCreateTextFieldManager();
        int max = ConfigHandler.router.baseTickRate * ConfigHandler.router.fluidMaxTransferRate;
        IntegerTextField intField = new IntegerTextField(manager, 1, this.field_146289_q, this.field_147003_i + 152, this.field_147009_r + 23, 34, 12, 0, max);
        intField.setValue(this.maxTransfer);
        intField.func_175207_a(this);
        intField.setIncr(100, 10, 10);
        intField.useGuiTextBackground();
        manager.focus(0);
        this.field_146292_n.add(new TooltipButton(1000, this.field_147003_i + 130, this.field_147009_r + 19, 16, 16, bucketStack));
        this.field_146292_n.add(new FluidDirectionButton(1001, this.field_147003_i + 148, this.field_147009_r + 44, this.fluidDirection));
        this.forceEmptyButton = new ForceEmptyButton(1002, this.field_147003_i + 168, this.field_147009_r + 69, this.forceEmpty);
        this.field_146292_n.add(this.forceEmptyButton);
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 128, this.field_147009_r + 17, this.field_147003_i + 183, this.field_147009_r + 35, "guiText.popup.fluid.maxTransfer");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 126, this.field_147009_r + 42, this.field_147003_i + 185, this.field_147009_r + 61, "guiText.popup.fluid.direction");
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 128, this.field_147009_r + 67, this.field_147003_i + 185, this.field_147009_r + 86, "guiText.popup.fluid.forceEmpty");
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.func_73729_b(this.field_147003_i + 146, this.field_147009_r + 20, GuiModuleFluid.LARGE_TEXTFIELD_XY.x, GuiModuleFluid.LARGE_TEXTFIELD_XY.y, 35, 14);
        RenderHelper.renderItemStack(this.field_146297_k, routerStack, this.field_147003_i + 128, this.field_147009_r + 44, "");
        RenderHelper.renderItemStack(this.field_146297_k, waterStack, this.field_147003_i + 168, this.field_147009_r + 44, "");
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        if (this.regulatorTextField.func_146176_q()) {
            this.field_146297_k.field_71466_p.func_78276_b("%", 179, 77, 0x404040);
        }
        if (this.fluidDirection == FluidModule.FluidDirection.OUT) {
            String s = I18n.func_135052_a((String)"guiText.label.fluidForceEmpty", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_78276_b(s, 165 - this.field_146297_k.field_71466_p.func_78256_a(s), 73, 0x202040);
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.forceEmptyButton.field_146125_m = this.fluidDirection == FluidModule.FluidDirection.OUT;
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 1001: {
                FluidDirectionButton fb = (FluidDirectionButton)button;
                fb.cycle(true);
                this.fluidDirection = (FluidModule.FluidDirection)((Object)fb.getState());
                this.sendModuleSettingsToServer();
                break;
            }
            case 1002: {
                ForceEmptyButton forceButton = (ForceEmptyButton)button;
                forceButton.toggle();
                this.forceEmpty = forceButton.isToggled();
                this.sendModuleSettingsToServer();
                break;
            }
            default: {
                super.func_146284_a(button);
            }
        }
    }

    @Override
    public void func_175319_a(int id, String value) {
        switch (id) {
            case 1: {
                this.maxTransfer = value.isEmpty() ? 0 : Integer.parseInt(value);
                this.sendModuleSettingsDelayed(5);
                break;
            }
            default: {
                super.func_175319_a(id, value);
            }
        }
    }

    @Override
    protected NBTTagCompound buildMessageData() {
        NBTTagCompound compound = super.buildMessageData();
        compound.func_74768_a("MaxTransfer", this.maxTransfer);
        compound.func_74774_a("FluidDir", (byte)this.fluidDirection.ordinal());
        compound.func_74757_a("ForceEmpty", this.forceEmpty);
        return compound;
    }

    private static class ForceEmptyButton
    extends TexturedToggleButton {
        ForceEmptyButton(int buttonId, int x, int y, boolean initialVal) {
            super(buttonId, x, y, 16, 16, initialVal);
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.fluidForceEmpty.false", new Object[0]);
            MiscUtil.appendMultiline(this.tooltip2, "guiText.tooltip.fluidForceEmpty.true", new Object[0]);
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 192 : 112;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    private static class FluidDirectionButton
    extends TexturedCyclerButton<FluidModule.FluidDirection> {
        private final List<List<String>> tooltips = Lists.newArrayList();

        FluidDirectionButton(int buttonId, int x, int y, FluidModule.FluidDirection initialVal) {
            super(buttonId, x, y, 16, 16, initialVal);
            for (FluidModule.FluidDirection dir : FluidModule.FluidDirection.values()) {
                this.tooltips.add(Collections.singletonList(I18n.func_135052_a((String)("itemText.fluid.direction." + (Object)((Object)dir)), (Object[])new Object[0])));
            }
        }

        @Override
        protected int getTextureX() {
            return 160 + ((FluidModule.FluidDirection)((Object)this.getState())).ordinal() * 16;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }

        @Override
        public List<String> getTooltip() {
            return this.tooltips.get(((FluidModule.FluidDirection)((Object)this.getState())).ordinal());
        }
    }

    private class TooltipButton
    extends ItemStackButton {
        TooltipButton(int buttonId, int x, int y, int width, int height, ItemStack renderStack) {
            super(buttonId, x, y, width, height, renderStack, true);
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.fluidTransferTooltip", new Object[0]);
            this.tooltip1.add("");
            TileEntityItemRouter router = GuiModuleFluid.this.getItemRouterTE();
            if (router != null) {
                int ftRate = router.getFluidTransferRate();
                int tickRate = router.getTickRate();
                this.tooltip1.add(TextFormatting.GRAY + I18n.func_135052_a((String)"guiText.tooltip.maxFluidPerOp", (Object[])new Object[]{ftRate * tickRate, tickRate, ftRate}));
            }
            MiscUtil.appendMultiline(this.tooltip1, "guiText.tooltip.numberFieldTooltip", new Object[0]);
        }

        public void func_146113_a(SoundHandler soundHandlerIn) {
        }
    }
}

