/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.module.Module;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ModuleGuiFactory {
    public static GuiModule createGui(EntityPlayer player, EnumHand hand) {
        return ModuleGuiFactory.createGui(player, player.func_184586_b(hand), null, -1, hand);
    }

    public static GuiModule createGui(EntityPlayer player, ItemStack moduleStack, BlockPos routerPos, int slotIndex) {
        return ModuleGuiFactory.createGui(player, moduleStack, routerPos, slotIndex, null);
    }

    public static GuiModule createGui(EntityPlayer player, World world, int x, int y, int z) {
        int moduleSlotIndex;
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)world, new BlockPos(x, y, z));
        if (router != null && (moduleSlotIndex = router.getModuleConfigSlot(player)) >= 0) {
            router.clearConfigSlot(player);
            ItemStack installedModuleStack = router.getModules().getStackInSlot(moduleSlotIndex);
            return installedModuleStack.func_190926_b() ? null : ModuleGuiFactory.createGui(player, installedModuleStack, router.func_174877_v(), moduleSlotIndex);
        }
        return null;
    }

    public static Container createContainer(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Module module = ItemModule.getModule(stack);
        return module == null ? null : module.createGuiContainer(player, hand, stack, null);
    }

    public static Container createContainer(EntityPlayer player, World world, int x, int y, int z) {
        int slotIndex;
        TileEntityItemRouter router = TileEntityItemRouter.getRouterAt((IBlockAccess)world, new BlockPos(x, y, z));
        if (router != null && (slotIndex = router.getModuleConfigSlot(player)) >= 0) {
            router.clearConfigSlot(player);
            ItemStack installedModuleStack = router.getModules().getStackInSlot(slotIndex);
            Module module = ItemModule.getModule(installedModuleStack);
            return module == null ? null : module.createGuiContainer(player, null, installedModuleStack, router);
        }
        return null;
    }

    private static GuiModule createGui(EntityPlayer player, ItemStack moduleStack, BlockPos routerPos, int slotIndex, EnumHand hand) {
        Module module = ItemModule.getModule(moduleStack);
        if (module == null) {
            return null;
        }
        Class<? extends GuiModule> clazz = module.getGuiHandler();
        try {
            Constructor<? extends GuiModule> ctor = clazz.getConstructor(ContainerModule.class, BlockPos.class, Integer.class, EnumHand.class);
            TileEntityItemRouter router = routerPos == null ? null : TileEntityItemRouter.getRouterAt((IBlockAccess)player.func_130014_f_(), routerPos);
            return ctor.newInstance(new Object[]{module.createGuiContainer(player, hand, moduleStack, router), routerPos, slotIndex, hand});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

