/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.textfield;

import java.util.regex.Pattern;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidget;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;

public class IntegerTextField
extends TextFieldWidget {
    private final int min;
    private final int max;
    private int incr = 1;
    private int coarseIncr = 10;
    private int fineIncr = 1;
    private static final Pattern INT_MATCHER = Pattern.compile("^-?[0-9]+$");

    public IntegerTextField(TextFieldManager parent, int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height, int min, int max) {
        super(parent, componentId, fontrendererObj, x, y, par5Width, par6Height);
        this.min = min;
        this.max = max;
        this.func_146203_f(Math.max(Integer.toString(min).length(), Integer.toString(max).length()));
        this.func_175205_a(input -> {
            if (input == null || input.isEmpty()) {
                return true;
            }
            if (!INT_MATCHER.matcher((CharSequence)input).matches()) {
                return false;
            }
            int n = Integer.parseInt(input);
            return n >= this.min && n <= this.max;
        });
    }

    public boolean func_146201_a(char typedChar, int keyCode) {
        switch (keyCode) {
            case 200: {
                return this.adjustField(this.getAdjustment());
            }
            case 208: {
                return this.adjustField(-this.getAdjustment());
            }
            case 201: {
                return this.adjustField(this.max);
            }
            case 209: {
                return this.adjustField(-this.max);
            }
        }
        return super.func_146201_a(typedChar, keyCode);
    }

    @Override
    public void onMouseWheel(int direction) {
        this.adjustField(direction > 0 ? this.getAdjustment() : -this.getAdjustment());
    }

    public void setValue(int val) {
        if (val >= this.min && val <= this.max) {
            this.func_146180_a(Integer.toString(val));
        }
    }

    public int getValue() {
        int val;
        try {
            val = Integer.parseInt(this.func_146179_b());
        }
        catch (NumberFormatException e) {
            val = this.min;
        }
        return val;
    }

    public void setIncr(int incr, int coarseAdjustMult) {
        this.setIncr(incr, coarseAdjustMult, 1);
    }

    public void setIncr(int incr, int coarseAdjustMult, int fineAdjustDiv) {
        this.incr = incr;
        this.coarseIncr = incr * coarseAdjustMult;
        this.fineIncr = incr / fineAdjustDiv;
    }

    private int getAdjustment() {
        if (GuiScreen.func_146272_n()) {
            return this.coarseIncr;
        }
        if (GuiScreen.func_146271_m()) {
            return this.fineIncr;
        }
        return this.incr;
    }

    private boolean adjustField(int adj) {
        int newVal = Math.max(this.min, Math.min(this.max, this.getValue() + adj));
        if (newVal != this.getValue()) {
            this.func_146180_a("");
            this.func_146191_b(Integer.toString(newVal));
        }
        return true;
    }
}

