/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container;

import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.container.slot.BaseModuleSlot;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumHand;

public class ContainerExtruder2Module
extends ContainerModule {
    private static final int TEMPLATE_SLOTS = 9;

    public ContainerExtruder2Module(EntityPlayer player, EnumHand hand, ItemStack moduleStack) {
        this(player, hand, moduleStack, null);
    }

    public ContainerExtruder2Module(EntityPlayer player, EnumHand hand, ItemStack moduleStack, TileEntityItemRouter router) {
        super(player, hand, moduleStack, router);
        TemplateHandler handler = new TemplateHandler(moduleStack);
        for (int i = 0; i < 9; ++i) {
            int x = 129 + 18 * (i % 3);
            int y = 17 + 18 * (i / 3);
            TemplateSlot slot = router == null ? new TemplateSlot(handler, player, hand, i, x, y) : new TemplateSlot(handler, router, i, x, y);
            this.func_75146_a((Slot)slot);
        }
    }

    @Override
    protected void transferStackInExtraSlot(EntityPlayer player, int index) {
        ((Slot)this.field_75151_b.get(index)).func_75215_d(ItemStack.field_190927_a);
    }

    @Override
    protected ItemStack slotClickExtraSlot(int slot, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        Slot s = (Slot)this.field_75151_b.get(slot);
        ItemStack stackOnCursor = player.field_71071_by.func_70445_o();
        ItemStack stackInSlot = s.func_75211_c().func_77946_l();
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            s.func_75215_d(ItemStack.field_190927_a);
        } else if (!stackOnCursor.func_190926_b() && !ItemStack.func_179545_c((ItemStack)stackInSlot, (ItemStack)stackOnCursor)) {
            ItemStack stack1 = stackOnCursor.func_77946_l();
            if (dragType == 1) {
                stack1.func_190920_e(1);
            }
            s.func_75215_d(stack1);
        } else if (!stackInSlot.func_190926_b()) {
            if (dragType == 1) {
                stackInSlot.func_190920_e(Math.min(stackInSlot.func_77976_d(), stackInSlot.func_190916_E() + 1));
            } else if (dragType == 0) {
                stackInSlot.func_190918_g(1);
            }
            s.func_75215_d(stackInSlot);
            s.func_75218_e();
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isItemOKForTemplate(ItemStack stack) {
        if (stack.func_190926_b()) {
            return true;
        }
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            return true;
        }
        Block b = ((ItemBlock)stack.func_77973_b()).func_179223_d();
        return b.func_176223_P().func_185901_i() == EnumBlockRenderType.MODEL;
    }

    public static class TemplateHandler
    extends BaseModuleHandler {
        private static final String NBT_TEMPLATE = "Template";

        public TemplateHandler(ItemStack holderStack) {
            super(holderStack, 9, NBT_TEMPLATE);
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return ContainerExtruder2Module.isItemOKForTemplate(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        @Override
        public void setStackInSlot(int slot, ItemStack stack) {
            if (ContainerExtruder2Module.isItemOKForTemplate(stack)) {
                super.setStackInSlot(slot, stack);
            }
        }
    }

    private static class TemplateSlot
    extends BaseModuleSlot<TemplateHandler> {
        public TemplateSlot(TemplateHandler itemHandler, TileEntityItemRouter router, int index, int xPosition, int yPosition) {
            super(itemHandler, router, index, xPosition, yPosition);
        }

        public TemplateSlot(TemplateHandler itemHandler, EntityPlayer player, EnumHand hand, int index, int xPosition, int yPosition) {
            super(itemHandler, player, hand, index, xPosition, yPosition);
        }
    }
}

