/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import me.desht.modularrouters.container.handler.GhostItemHandler;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.module.Module;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class BaseModuleHandler
extends GhostItemHandler {
    private final ItemStack holderStack;
    private final String tagName;

    public BaseModuleHandler(ItemStack holderStack, int size, String tagName) {
        super(size);
        this.holderStack = holderStack;
        this.tagName = tagName;
        if (!holderStack.func_77942_o()) {
            holderStack.func_77982_d(new NBTTagCompound());
        }
        this.deserializeNBT(holderStack.func_77978_p().func_150295_c(tagName, 10));
    }

    public ItemStack getHolderStack() {
        return this.holderStack;
    }

    public static int getFilterSize(ItemStack holderStack, String tagName) {
        if (holderStack.func_77942_o()) {
            return holderStack.func_77978_p().func_150295_c(tagName, 10).func_74745_c();
        }
        return 0;
    }

    public void save() {
        this.holderStack.func_77978_p().func_74782_a(this.tagName, (NBTBase)this.serializeNBT());
    }

    public static class ModuleFilterHandler
    extends BaseModuleHandler {
        public ModuleFilterHandler(ItemStack holderStack) {
            super(holderStack, 9, "ModuleFilter");
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            Module module = ItemModule.getModule(this.getHolderStack());
            return module.isItemValidForFilter(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        @Override
        public void setStackInSlot(int slot, ItemStack stack) {
            Module module = ItemModule.getModule(this.getHolderStack());
            if (module.isItemValidForFilter(stack)) {
                super.setStackInSlot(slot, stack);
            }
        }
    }

    public static class BulkFilterHandler
    extends BaseModuleHandler {
        public BulkFilterHandler(ItemStack holderStack) {
            super(holderStack, 54, "ModuleFilter");
        }
    }
}

