/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration;

import java.util.Arrays;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class XPCollection {
    private static final boolean[] AVAILABLE = new boolean[XPCollectionType.values().length];
    private static final ItemStack[] ICONS = new ItemStack[XPCollectionType.values().length];
    private static final boolean[] SOLID = new boolean[XPCollectionType.values().length];

    public static void detectXPFluids() {
        Arrays.stream(XPCollectionType.values()).forEach(type -> {
            XPCollection.AVAILABLE[type.ordinal()] = !XPCollection.getIconForResource(((XPCollectionType)type).registryName).func_190926_b();
        });
        for (XPCollectionType type2 : XPCollectionType.values()) {
            XPCollection.AVAILABLE[type2.ordinal()] = !XPCollection.getIconForResource(type2.registryName).func_190926_b();
            XPCollection.SOLID[type2.ordinal()] = type2.registryName.indexOf(58) >= 0;
        }
        Arrays.fill(ICONS, null);
    }

    private static ItemStack getIconForResource(String resource) {
        Fluid fluid;
        Item item;
        ItemStack stack = resource.contains(":") ? ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resource))) == null ? ItemStack.field_190927_a : new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resource)))) : ((fluid = FluidRegistry.getFluid((String)resource)) == null ? ItemStack.field_190927_a : FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000)));
        return stack;
    }

    public static enum XPCollectionType {
        BOTTLE_O_ENCHANTING(7, "minecraft:experience_bottle"),
        SOLIDIFIED_EXPERIENCE(8, "actuallyadditions:item_solidified_experience"),
        XPJUICE(20, "xpjuice"),
        KNOWLEDGE(20, "experience"),
        ESSENCE(20, "essence");

        private final int xpRatio;
        private final String registryName;

        private XPCollectionType(int xpRatio, String registryName) {
            this.xpRatio = xpRatio;
            this.registryName = registryName;
        }

        public int getXpRatio() {
            return this.xpRatio;
        }

        public String getRegistryName() {
            return this.registryName;
        }

        public boolean isSolid() {
            return SOLID[this.ordinal()];
        }

        public Fluid getFluid() {
            return FluidRegistry.getFluid((String)this.registryName);
        }

        public String getModId() {
            int idx = this.registryName.indexOf(58);
            return idx >= 0 ? this.registryName.substring(0, idx) : FluidRegistry.getModId((FluidStack)FluidRegistry.getFluidStack((String)this.registryName, (int)1000));
        }

        public boolean isAvailable() {
            return AVAILABLE[this.ordinal()];
        }

        public ItemStack getIcon() {
            if (ICONS[this.ordinal()] == null) {
                ICONS[this.ordinal()] = XPCollection.getIconForResource(this.registryName);
            }
            return ICONS[this.ordinal()];
        }
    }
}

