/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.gui.filter.GuiRegexFilter;
import me.desht.modularrouters.item.smartfilter.SmartFilter;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.RegexMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RegexFilter
extends SmartFilter {
    private static final String NBT_REGEX = "Regex";
    private static final int MAX_SIZE = 6;

    public static List<String> getRegexList(ItemStack filterStack) {
        if (filterStack.func_77942_o()) {
            NBTTagList items = filterStack.func_77978_p().func_150295_c(NBT_REGEX, 8);
            ArrayList res = Lists.newArrayListWithExpectedSize((int)items.func_74745_c());
            for (int i = 0; i < items.func_74745_c(); ++i) {
                res.add(items.func_150307_f(i));
            }
            return res;
        }
        return Lists.newArrayList();
    }

    public static void setRegexList(ItemStack filterStack, List<String> regex) {
        if (!filterStack.func_77942_o()) {
            filterStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = new NBTTagList();
        for (String r : regex) {
            list.func_74742_a((NBTBase)new NBTTagString(r));
        }
        NBTTagCompound compound = filterStack.func_77978_p();
        compound.func_74782_a(NBT_REGEX, (NBTBase)list);
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        super.addExtraInformation(itemstack, player, list, advanced);
        NBTTagCompound compound = itemstack.func_77978_p();
        if (compound != null) {
            List<String> l = RegexFilter.getRegexList(itemstack);
            list.add(I18n.func_135052_a((String)"itemText.misc.regexFilter.count", (Object[])new Object[]{l.size()}));
            list.addAll(l.stream().map(s -> " \u2022 " + TextFormatting.AQUA + "/" + s + "/").collect(Collectors.toList()));
        } else {
            list.add(I18n.func_135052_a((String)"itemText.misc.regexFilter.count", (Object[])new Object[]{0}));
        }
    }

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        return new RegexMatcher(RegexFilter.getRegexList(filterStack));
    }

    @Override
    public Class<? extends GuiScreen> getGuiHandler() {
        return GuiRegexFilter.class;
    }

    @Override
    public boolean hasGuiContainer() {
        return false;
    }

    @Override
    public IMessage dispatchMessage(EntityPlayer player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        switch (message.getOp()) {
            case ADD_STRING: {
                String regex = message.getNbtData().func_74779_i("String");
                List<String> l = RegexFilter.getRegexList(filterStack);
                if (l.size() >= 6) break;
                l.add(regex);
                RegexFilter.setRegexList(filterStack, l);
                return new GuiSyncMessage(filterStack);
            }
            case REMOVE_AT: {
                int pos = message.getNbtData().func_74762_e("Pos");
                List<String> l = RegexFilter.getRegexList(filterStack);
                if (pos < 0 || pos >= l.size()) break;
                l.remove(pos);
                RegexFilter.setRegexList(filterStack, l);
                return new GuiSyncMessage(filterStack);
            }
            default: {
                ModularRouters.logger.warn("received unexpected message type " + (Object)((Object)message.getOp()) + " for " + filterStack);
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        return filterStack.func_77942_o() ? filterStack.func_77978_p().func_150295_c(NBT_REGEX, 8).func_74745_c() : 0;
    }
}

