/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.item.module.TargetedModule;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledSenderModule2;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CompiledDistributorModule
extends CompiledSenderModule2 {
    public static final String NBT_STRATEGY = "DistStrategy";
    private final DistributionStrategy distributionStrategy;
    private int nextTarget = 0;

    public CompiledDistributorModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            this.distributionStrategy = DistributionStrategy.values()[compound.func_74762_e(NBT_STRATEGY)];
            if (this.distributionStrategy == DistributionStrategy.FURTHEST_FIRST) {
                this.nextTarget = this.getTargets().size() - 1;
            }
        } else {
            this.distributionStrategy = DistributionStrategy.ROUND_ROBIN;
        }
    }

    @Override
    public boolean execute(TileEntityItemRouter router) {
        return super.execute(router);
    }

    public DistributionStrategy getDistributionStrategy() {
        return this.distributionStrategy;
    }

    @Override
    protected List<ModuleTarget> setupTarget(TileEntityItemRouter router, ItemStack stack) {
        Set<ModuleTarget> t = TargetedModule.getTargets(stack, true);
        ArrayList l = Lists.newArrayList(t);
        if (router == null) {
            return l;
        }
        l.sort(Comparator.comparingDouble(o -> CompiledDistributorModule.calcDist(o, router)));
        return l;
    }

    private static double calcDist(ModuleTarget tgt, TileEntity te) {
        double distance = tgt.pos.func_185332_f(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
        if (tgt.dimId != te.func_145831_w().field_73011_w.getDimension()) {
            distance += 1.0E8;
        }
        return distance;
    }

    @Override
    public ModuleTarget getActualTarget(TileEntityItemRouter router) {
        if (this.getTargets() == null || this.getTargets().isEmpty()) {
            return null;
        }
        int nTargets = this.getTargets().size();
        if (nTargets == 1) {
            return this.getTargets().get(0);
        }
        ModuleTarget res = null;
        ItemStack stack = router.peekBuffer(this.getItemsPerTick(router));
        block0 : switch (this.distributionStrategy) {
            case ROUND_ROBIN: {
                for (int i = 1; i <= nTargets; ++i) {
                    ModuleTarget tgt;
                    ++this.nextTarget;
                    if (this.nextTarget >= nTargets) {
                        this.nextTarget -= nTargets;
                    }
                    if (!this.okToInsert(tgt = this.getTargets().get(this.nextTarget), stack)) continue;
                    res = tgt;
                    break block0;
                }
                break;
            }
            case RANDOM: {
                int r = ModularRouters.random.nextInt(this.getTargets().size());
                res = this.getTargets().get(r);
                break;
            }
            case NEAREST_FIRST: {
                for (ModuleTarget tgt : this.getTargets()) {
                    if (!this.okToInsert(tgt, stack)) continue;
                    res = tgt;
                    break block0;
                }
                break;
            }
            case FURTHEST_FIRST: {
                for (int i = this.getTargets().size() - 1; i >= 0; --i) {
                    if (!this.okToInsert(this.getTargets().get(i), stack)) continue;
                    res = this.getTargets().get(i);
                    break block0;
                }
                break;
            }
        }
        return res;
    }

    private boolean okToInsert(ModuleTarget target, ItemStack stack) {
        IItemHandler handler = target.getItemHandler();
        return handler != null && ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true).func_190926_b();
    }

    public static enum DistributionStrategy {
        ROUND_ROBIN,
        RANDOM,
        NEAREST_FIRST,
        FURTHEST_FIRST;

    }
}

