/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.ArrayList;
import java.util.List;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.block.tile.TileEntityTemplateFrame;
import me.desht.modularrouters.container.ContainerExtruder2Module;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.logic.compiled.CompiledExtruderModule;
import me.desht.modularrouters.util.BlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class CompiledExtruder2Module
extends CompiledExtruderModule {
    private static final ItemStack TEMPLATE_STACK = new ItemStack((Block)RegistrarMR.TEMPLATE_FRAME);
    private final List<ItemStack> blockList;
    private final ItemStack pick = new ItemStack(Items.field_151046_w);

    public CompiledExtruder2Module(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        this.blockList = new ArrayList<ItemStack>();
        ContainerExtruder2Module.TemplateHandler handler = new ContainerExtruder2Module.TemplateHandler(stack);
        block0: for (int i = 0; i < handler.getSlots() && this.blockList.size() < this.getRange(); ++i) {
            ItemStack stack1 = handler.getStackInSlot(i);
            for (int j = 0; j < stack1.func_190916_E(); ++j) {
                ItemStack copy = stack1.func_77946_l();
                copy.func_190920_e(1);
                this.blockList.add(copy);
                if (this.blockList.size() >= this.getRange()) continue block0;
            }
        }
    }

    @Override
    public boolean execute(TileEntityItemRouter router) {
        boolean extend = this.shouldExtend(router);
        World world = router.func_145831_w();
        if (extend && this.distance < this.blockList.size()) {
            if (!(this.blockList.get(this.distance).func_77973_b() instanceof ItemBlock)) {
                router.getExtData().func_74768_a("ExtruderDist" + this.getFacing(), ++this.distance);
            } else {
                BlockPos placePos = router.func_174877_v().func_177967_a(this.getFacing(), this.distance + 1);
                IBlockState state = BlockUtil.tryPlaceAsBlock(TEMPLATE_STACK, world, placePos, this.getFacing(), this.getRouterFacing());
                if (state != null) {
                    TileEntityTemplateFrame te = TileEntityTemplateFrame.getTileEntitySafely((IBlockAccess)world, placePos);
                    if (te != null) {
                        te.setCamouflage(this.blockList.get(this.distance));
                        te.setExtendedMimic(this.getAugmentCount(ItemAugment.AugmentType.MIMIC) > 0);
                        if (te.extendedMimic()) {
                            world.func_175685_c(placePos, state.func_177230_c(), true);
                        }
                    }
                    router.playSound(null, placePos, state.func_177230_c().getSoundType(state, world, placePos, null).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                    router.getExtData().func_74768_a("ExtruderDist" + this.getFacing(), ++this.distance);
                    this.tryPushEntities(router.func_145831_w(), placePos, this.getFacing());
                    return true;
                }
            }
        } else if (!extend && this.distance > 0) {
            BlockPos breakPos = router.func_174877_v().func_177967_a(this.getFacing(), this.distance);
            IBlockState oldState = world.func_180495_p(breakPos);
            router.getExtData().func_74768_a("ExtruderDist" + this.getFacing(), --this.distance);
            if (this.okToBreak(oldState, world, breakPos)) {
                BlockUtil.BreakResult breakResult = BlockUtil.tryBreakBlock(world, breakPos, this.getFilter(), this.pick);
                if (breakResult.isBlockBroken()) {
                    router.playSound(null, breakPos, RegistrarMR.TEMPLATE_FRAME.getSoundType(oldState, world, breakPos, null).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                }
                return true;
            }
        }
        return false;
    }

    private boolean okToBreak(IBlockState state, World world, BlockPos pos) {
        Block b = state.func_177230_c();
        return b.isAir(state, (IBlockAccess)world, pos) || b == RegistrarMR.TEMPLATE_FRAME || b instanceof BlockLiquid || b instanceof IFluidBlock;
    }
}

