/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.item.upgrade.ItemUpgrade;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledDropperModule;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;

public class CompiledFlingerModule
extends CompiledDropperModule {
    public static final String NBT_SPEED = "Speed";
    public static final String NBT_PITCH = "Pitch";
    public static final String NBT_YAW = "Yaw";
    private final float speed;
    private final float pitch;
    private final float yaw;

    public CompiledFlingerModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        NBTTagCompound compound = ModuleHelper.validateNBT(stack);
        for (String key : new String[]{NBT_SPEED, NBT_PITCH, NBT_YAW}) {
            if (compound.func_74764_b(key)) continue;
            compound.func_74776_a(key, 0.0f);
        }
        this.speed = compound.func_74760_g(NBT_SPEED);
        this.pitch = compound.func_74760_g(NBT_PITCH);
        this.yaw = compound.func_74760_g(NBT_YAW);
    }

    @Override
    public boolean execute(TileEntityItemRouter router) {
        boolean fired = super.execute(router);
        if (fired && ConfigHandler.module.flingerEffects) {
            ModuleTarget t = this.getTarget();
            int n = Math.round(this.speed * 5.0f);
            if (router.getUpgradeCount(ItemUpgrade.UpgradeType.MUFFLER) < 2) {
                ((WorldServer)router.func_145831_w()).func_180505_a(EnumParticleTypes.EXPLOSION_NORMAL, false, (double)t.pos.func_177958_n() + 0.5, (double)t.pos.func_177956_o() + 0.5, (double)t.pos.func_177952_p() + 0.5, n, 0.0, 0.0, 0.0, 0.0, new int[0]);
            }
            router.playSound(null, t.pos, RegistrarMR.SOUND_THUD, SoundCategory.BLOCKS, 0.5f + this.speed, 1.0f);
        }
        return fired;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getSpeed() {
        return this.speed;
    }

    @Override
    protected void setupItemVelocity(TileEntityItemRouter router, EntityItem item) {
        float baseYaw;
        EnumFacing routerFacing = router.getAbsoluteFacing(Module.RelativeDirection.FRONT);
        float basePitch = 0.0f;
        switch (this.getDirection()) {
            case UP: {
                basePitch = 90.0f;
                baseYaw = this.yawFromFacing(routerFacing);
                break;
            }
            case DOWN: {
                basePitch = -90.0f;
                baseYaw = this.yawFromFacing(routerFacing);
                break;
            }
            default: {
                baseYaw = this.yawFromFacing(this.getFacing());
            }
        }
        double yawRad = Math.toRadians(baseYaw + this.yaw);
        double pitchRad = Math.toRadians(basePitch + this.pitch);
        double x = Math.cos(yawRad) * Math.cos(pitchRad);
        double y = Math.sin(pitchRad);
        double z = -(Math.sin(yawRad) * Math.cos(pitchRad));
        item.field_70159_w = x * (double)this.speed;
        item.field_70181_x = y * (double)this.speed;
        item.field_70179_y = z * (double)this.speed;
    }

    private float yawFromFacing(EnumFacing absoluteFacing) {
        switch (absoluteFacing) {
            case EAST: {
                return 0.0f;
            }
            case NORTH: {
                return 90.0f;
            }
            case WEST: {
                return 180.0f;
            }
            case SOUTH: {
                return 270.0f;
            }
        }
        return 0.0f;
    }
}

