/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.fx.ParticleBeam;
import me.desht.modularrouters.client.fx.Vector3;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ParticleBeamMessage
implements IMessage {
    private int rgb;
    private float size;
    private boolean flat;
    private double x;
    private double y;
    private double z;
    private double x2;
    private double y2;
    private double z2;

    public ParticleBeamMessage() {
    }

    public ParticleBeamMessage(double x, double y, double z, double x2, double y2, double z2, Color color, float size) {
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
        this.x = x;
        this.y = y;
        this.z = z;
        this.flat = color != null;
        this.rgb = this.flat ? color.getRGB() : 0;
        this.size = size;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.x2 = buf.readDouble();
        this.y2 = buf.readDouble();
        this.z2 = buf.readDouble();
        this.flat = buf.readBoolean();
        this.rgb = buf.readInt();
        this.size = (float)buf.readByte() / 255.0f;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.x2);
        buf.writeDouble(this.y2);
        buf.writeDouble(this.z2);
        buf.writeBoolean(this.flat);
        buf.writeInt(this.rgb);
        buf.writeByte((int)((byte)(this.size * 255.0f)));
    }

    public static class Handler
    implements IMessageHandler<ParticleBeamMessage, IMessage> {
        public IMessage onMessage(ParticleBeamMessage msg, MessageContext ctx) {
            World w = ModularRouters.proxy.theClientWorld();
            if (w != null) {
                ParticleBeam.doParticleBeam(w, new Vector3(msg.x, msg.y, msg.z), new Vector3(msg.x2, msg.y2, msg.z2), msg.flat ? new Color(msg.rgb) : null, msg.size);
            }
            return null;
        }
    }
}

